/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio.tone;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.spi.dtmf.DtmfTonesData;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class ToneTrackImpl
implements Track {
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private int period = 20;
    private int frameSize;
    private boolean eom;
    private long duration;
    private byte[] source;
    private boolean first = true;
    private SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss,SSS");
    private int position = 0;
    public static final String extention = ".tone";

    public ToneTrackImpl(URL url) throws UnsupportedAudioFileException, IOException {
        if (!url.getHost().endsWith(extention)) {
            throw new UnsupportedAudioFileException("Invalid extention");
        }
        String toneName = url.getHost().substring(0, url.getHost().length() - extention.length());
        if (toneName.length() > 1) {
            throw new UnsupportedAudioFileException("Invalid tone");
        }
        char currTone = toneName.charAt(0);
        if (currTone >= '0' && currTone <= '9') {
            this.source = DtmfTonesData.buffer[currTone - 48];
        } else if (currTone == '*') {
            this.source = DtmfTonesData.buffer[10];
        } else if (currTone == '#') {
            this.source = DtmfTonesData.buffer[11];
        } else if (currTone >= 'A' && currTone <= 'D') {
            this.source = DtmfTonesData.buffer[currTone - 65 + 12];
        } else if (currTone >= 'a' && currTone <= 'd') {
            this.source = DtmfTonesData.buffer[currTone - 97 + 12];
        } else {
            throw new UnsupportedAudioFileException("Invalid tone");
        }
        this.position = 0;
        this.frameSize = this.period * this.format.getChannels() * this.format.getSampleSize() * this.format.getSampleRate() / 8000;
        this.duration = (long)(this.source.length / this.frameSize * this.period) * 1000000L;
    }

    public void setPeriod(int period) {
        this.period = period;
        this.frameSize = period * this.format.getChannels() * this.format.getSampleSize() * this.format.getSampleRate() / 8000;
    }

    public int getPeriod() {
        return this.period;
    }

    @Override
    public long getMediaTime() {
        return 0L;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setMediaTime(long timestamp) {
    }

    private void skip(long timestamp) {
        long offset = (long)this.frameSize * (timestamp / (long)this.period / 1000000L);
        this.position = (int)((long)this.position + offset);
    }

    private int readPacket(byte[] packet, int offset, int psize) throws IOException {
        int length = 0;
        if (this.position + psize < this.source.length) {
            length = psize;
            System.arraycopy(this.source, this.position, packet, offset, length);
            this.position += psize;
        } else if (this.position < this.source.length) {
            length = this.source.length - this.position;
            System.arraycopy(this.source, this.position, packet, offset, length);
            this.position += length;
        }
        return length;
    }

    private void padding(byte[] data, int count) {
        int offset = data.length - count;
        for (int i = 0; i < count; ++i) {
            data[i + offset] = 0;
        }
    }

    @Override
    public Frame process(long timestamp) throws IOException {
        int len;
        Frame frame;
        byte[] data;
        if (this.first) {
            if (timestamp > 0L) {
                this.skip(timestamp);
            }
            this.first = false;
        }
        if ((data = (frame = Memory.allocate((int)this.frameSize)).getData()) == null) {
            data = new byte[this.frameSize];
        }
        if ((len = this.readPacket(data, 0, this.frameSize)) == 0) {
            this.eom = true;
        }
        if (len < this.frameSize) {
            this.padding(data, this.frameSize - len);
            this.eom = true;
        }
        frame.setOffset(0);
        frame.setLength(this.frameSize);
        frame.setEOM(this.eom);
        frame.setDuration((long)this.period * 1000000L);
        frame.setFormat((Format)this.format);
        return frame;
    }

    @Override
    public void close() {
        this.position = this.source.length;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }
}

