/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.AudioInput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.AudioPlayerEvent;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.gsm.GsmTrackImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.mpeg.AMRTrackImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.tone.ToneTrackImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.tts.TtsTrackImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.wav.WavTrackImpl;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.Listener;
import org.mobicents.media.server.spi.listener.Listeners;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.spi.resource.TTSEngine;

public class AudioPlayerImpl
extends AbstractSource
implements Player,
TTSEngine {
    private static final AudioFormat LINEAR = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * LINEAR.getSampleRate() / 1000 * LINEAR.getSampleSize() / 8;
    private Processor dsp;
    private Track track;
    private String voiceName = "kevin";
    private int volume;
    private Listeners<PlayerListener> listeners = new Listeners();
    private static final Logger logger = Logger.getLogger(AudioPlayerImpl.class);
    private AudioInput input = new AudioInput(ComponentType.PLAYER.getType(), this.packetSize);

    public AudioPlayerImpl(String name, Scheduler scheduler) {
        super(name, scheduler, Scheduler.INPUT_QUEUE.intValue());
        this.connect((AbstractSink)this.input);
    }

    public AudioInput getAudioInput() {
        return this.input;
    }

    public void setDsp(Processor dsp) {
        this.dsp = dsp;
    }

    public Processor getDsp() {
        return this.dsp;
    }

    public void setURL(String passedURI) throws ResourceUnavailableException, MalformedURLException {
        block14: {
            if (this.track != null) {
                this.track.close();
                this.track = null;
            }
            if (!this.isConnected()) {
                throw new IllegalStateException("Component should be connected");
            }
            int pos = passedURI.lastIndexOf(46);
            if (pos == -1) {
                throw new MalformedURLException("Unknow file type: " + passedURI);
            }
            String ext = passedURI.substring(pos + 1).toLowerCase();
            URL targetURL = new URL(passedURI);
            try {
                if (ext.matches("wav")) {
                    this.track = new WavTrackImpl(targetURL);
                    break block14;
                }
                if (ext.matches("gsm")) {
                    this.track = new GsmTrackImpl(targetURL);
                    break block14;
                }
                if (ext.matches("tone")) {
                    this.track = new ToneTrackImpl(targetURL);
                    break block14;
                }
                if (ext.matches("txt")) {
                    this.track = new TtsTrackImpl(targetURL, this.voiceName, null);
                    break block14;
                }
                if (ext.matches("mov") || ext.matches("mp4") || ext.matches("3gp")) {
                    this.track = new AMRTrackImpl(targetURL);
                    break block14;
                }
                if (this.getEndpoint() == null) {
                    logger.info((Object)("unknown extension:" + passedURI));
                } else {
                    logger.info((Object)("(" + this.getEndpoint().getLocalName() + ") unknown extension:" + passedURI));
                }
                throw new ResourceUnavailableException("Unknown extension: " + passedURI);
            }
            catch (Exception e) {
                if (this.getEndpoint() == null) {
                    logger.error((Object)"error occured", (Throwable)e);
                } else {
                    logger.error((Object)("(" + this.getEndpoint().getLocalName() + ") error occured"), (Throwable)e);
                }
                throw new ResourceUnavailableException((Throwable)e);
            }
        }
        this.duration = this.track.getDuration();
    }

    public void activate() {
        if (this.track == null) {
            throw new IllegalStateException("The media source is not specified");
        }
        this.start();
        this.listeners.dispatch((Event)new AudioPlayerEvent(this, 1));
    }

    public void deactivate() {
        this.stop();
        if (this.track != null) {
            this.track.close();
            this.track = null;
        }
    }

    protected void stopped() {
        this.listeners.dispatch((Event)new AudioPlayerEvent(this, 2));
    }

    protected void completed() {
        super.completed();
        this.listeners.dispatch((Event)new AudioPlayerEvent(this, 2));
    }

    public Frame evolve(long timestamp) {
        try {
            Frame frame = this.track.process(timestamp);
            if (frame == null) {
                return null;
            }
            frame.setTimestamp(timestamp);
            if (frame.isEOM()) {
                if (this.getEndpoint() == null) {
                    logger.info((Object)"End of file reached");
                } else {
                    logger.info((Object)("(" + this.getEndpoint().getLocalName() + ") End of file reached"));
                }
            }
            if (this.dsp != null) {
                try {
                    frame = this.dsp.process(frame, frame.getFormat(), (Format)LINEAR);
                }
                catch (Exception e) {
                    if (this.getEndpoint() == null) {
                        logger.error((Object)e);
                    }
                    logger.error((Object)("(" + this.getEndpoint().getLocalName() + ")"), (Throwable)e);
                }
            }
            if (frame.isEOM()) {
                this.track.close();
            }
            return frame;
        }
        catch (IOException e) {
            if (this.getEndpoint() == null) {
                logger.error((Object)e);
            } else {
                logger.error((Object)("(" + this.getEndpoint().getLocalName() + ")"), (Throwable)e);
            }
            this.track.close();
            return null;
        }
    }

    public void setVoiceName(String voiceName) {
        this.voiceName = voiceName;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setText(String text) {
        this.track = new TtsTrackImpl(text, this.voiceName, null);
    }

    public void addListener(PlayerListener listener) throws TooManyListenersException {
        this.listeners.add((Listener)listener);
    }

    public void removeListener(PlayerListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void clearAllListeners() {
        this.listeners.clear();
    }

    public void setMaxDuration(long duration) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

