/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.sdp.fields.parser;

import java.util.regex.Pattern;
import org.mobicents.media.server.io.sdp.SdpException;
import org.mobicents.media.server.io.sdp.SdpParser;
import org.mobicents.media.server.io.sdp.attributes.GenericAttribute;

public class GenericAttributeParser
implements SdpParser<GenericAttribute> {
    protected static final String REGEX = "^a=[\\w-]+(:\\S+\\s?)?$";
    protected static final Pattern PATTERN = Pattern.compile("^a=[\\w-]+(:\\S+\\s?)?$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public GenericAttribute parse(String sdp) throws SdpException {
        try {
            String value;
            String key;
            int separator = sdp.indexOf(":");
            boolean hasValue = separator != -1;
            sdp = sdp.trim();
            if (!hasValue) {
                key = sdp.substring(2);
                value = null;
            } else {
                key = sdp.substring(2, separator);
                value = sdp.substring(separator + 1);
            }
            return new GenericAttribute(key, value);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(GenericAttribute field, String sdp) throws SdpException {
        try {
            String value;
            String key;
            int separator = sdp.indexOf(":");
            boolean hasValue = separator != -1;
            sdp = sdp.trim();
            if (!hasValue) {
                key = sdp.substring(2);
                value = null;
            } else {
                key = sdp.substring(2, separator);
                value = sdp.substring(separator + 1);
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException("The key is empty");
            }
            field.setKey(key);
            field.setValue(value);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

