/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.sdp.attributes.parser;

import java.util.regex.Pattern;
import org.mobicents.media.server.io.sdp.SdpException;
import org.mobicents.media.server.io.sdp.SdpParser;
import org.mobicents.media.server.io.sdp.attributes.RtpMapAttribute;

public class RtpMapAttributeParser
implements SdpParser<RtpMapAttribute> {
    private static final String REGEX = "^a=rtpmap:\\d+\\s\\w+/\\d+(/\\d+)?$";
    private static final Pattern PATTERN = Pattern.compile("^a=rtpmap:\\d+\\s\\w+/\\d+(/\\d+)?$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public RtpMapAttribute parse(String sdp) throws SdpException {
        try {
            int index = 0;
            String[] values = sdp.trim().substring(9).split("\\s|/");
            int payloadType = Integer.parseInt(values[index++]);
            String codec = values[index++];
            int clockRate = Integer.parseInt(values[index++]);
            int codecParams = 1;
            if (index == values.length - 1) {
                codecParams = Integer.parseInt(values[index]);
            }
            return new RtpMapAttribute(payloadType, codec, clockRate, codecParams);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(RtpMapAttribute field, String sdp) throws SdpException {
        try {
            int index = 0;
            String[] values = sdp.trim().substring(9).split("\\s|/");
            int payloadType = Integer.parseInt(values[index++]);
            String codec = values[index++];
            int clockRate = Integer.parseInt(values[index++]);
            int codecParams = 1;
            if (index == values.length - 1) {
                codecParams = Integer.parseInt(values[index]);
            }
            field.setPayloadType(payloadType);
            field.setCodec(codec);
            field.setClockRate(clockRate);
            field.setCodecParams(codecParams);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

