/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.sdp.attributes;

import java.util.HashMap;
import java.util.Map;
import org.mobicents.media.server.io.sdp.fields.AttributeField;

public class SsrcAttribute
extends AttributeField {
    public static final String ATTRIBUTE_TYPE = "ssrc";
    public static final String BEGIN = "a=ssrc:";
    public static final String NEWLINE = "\n";
    private String ssrcId;
    private final Map<String, String> attributes;
    private String lastAttribute;
    private String lastValue;

    public SsrcAttribute(String ssrcId) {
        super(ATTRIBUTE_TYPE);
        this.ssrcId = ssrcId;
        this.attributes = new HashMap<String, String>(3);
        this.lastAttribute = "";
        this.lastValue = "";
    }

    public void setSsrcId(String ssrcId) {
        this.ssrcId = ssrcId;
    }

    public String getSsrcId() {
        return this.ssrcId;
    }

    public String getAttributeValue(String attribute) {
        return this.attributes.get(attribute);
    }

    public void addAttribute(String attribute, String value) {
        this.lastAttribute = attribute;
        this.lastValue = value;
        this.attributes.put(attribute, value);
    }

    public String getLastAttribute() {
        return this.lastAttribute;
    }

    public String getLastValue() {
        return this.lastValue;
    }

    public void reset() {
        this.ssrcId = null;
        this.attributes.clear();
    }

    @Override
    public String toString() {
        this.builder.setLength(0);
        for (Map.Entry<String, String> value : this.attributes.entrySet()) {
            this.builder.append(BEGIN).append(this.ssrcId).append(" ").append(value.getKey());
            if (value.getValue() == null || value.getValue().isEmpty()) continue;
            this.builder.append(":").append(value.getValue()).append(NEWLINE);
        }
        this.builder.deleteCharAt(this.builder.length() - 1);
        return this.builder.toString();
    }
}

