/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.sdp;

import org.mobicents.media.server.io.sdp.SdpException;
import org.mobicents.media.server.io.sdp.SdpField;
import org.mobicents.media.server.io.sdp.SdpParser;
import org.mobicents.media.server.io.sdp.SdpParserPipeline;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.mobicents.media.server.io.sdp.attributes.ConnectionModeAttribute;
import org.mobicents.media.server.io.sdp.attributes.FormatParameterAttribute;
import org.mobicents.media.server.io.sdp.attributes.MaxPacketTimeAttribute;
import org.mobicents.media.server.io.sdp.attributes.PacketTimeAttribute;
import org.mobicents.media.server.io.sdp.attributes.RtpMapAttribute;
import org.mobicents.media.server.io.sdp.attributes.SsrcAttribute;
import org.mobicents.media.server.io.sdp.dtls.attributes.FingerprintAttribute;
import org.mobicents.media.server.io.sdp.dtls.attributes.SetupAttribute;
import org.mobicents.media.server.io.sdp.fields.AttributeField;
import org.mobicents.media.server.io.sdp.fields.ConnectionField;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.fields.OriginField;
import org.mobicents.media.server.io.sdp.fields.SessionNameField;
import org.mobicents.media.server.io.sdp.fields.TimingField;
import org.mobicents.media.server.io.sdp.fields.VersionField;
import org.mobicents.media.server.io.sdp.ice.attributes.CandidateAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IceLiteAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IcePwdAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IceUfragAttribute;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpAttribute;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpMuxAttribute;

public class SessionDescriptionParser {
    private static final String NEWLINE = "\n";
    private static final String PARSE_ERROR = "Cannot parse SDP: ";
    private static final String PARSE_ERROR_EMPTY = "Cannot parse SDP: empty";
    private static final SdpParserPipeline PARSERS = new SdpParserPipeline();

    public static SessionDescription parse(String text) throws SdpException {
        String[] lines;
        if (text == null || text.isEmpty()) {
            throw new SdpException(PARSE_ERROR_EMPTY);
        }
        SdpParsingInfo info = new SdpParsingInfo();
        block5: for (String line : lines = text.split(NEWLINE)) {
            try {
                char fieldType = line.charAt(0);
                switch (fieldType) {
                    case 'a': {
                        int separator = line.indexOf(":");
                        String attributeType = separator == -1 ? line.substring(2).trim() : line.substring(2, separator);
                        SdpParser<? extends AttributeField> attributeParser = PARSERS.getAttributeParser(attributeType);
                        if (attributeParser == null) continue block5;
                        SessionDescriptionParser.convertAndApplyAttribute(attributeParser.parse(line), info);
                        break;
                    }
                    default: {
                        SdpParser<? extends SdpField> fieldParser = PARSERS.getFieldParser(fieldType);
                        if (fieldParser == null) continue block5;
                        SessionDescriptionParser.convertAndApplyField(fieldParser.parse(line), info);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new SdpException("Could not parse SDP: " + line, e);
            }
        }
        return info.sdp;
    }

    private static void convertAndApplyField(SdpField field, SdpParsingInfo info) {
        switch (field.getFieldType()) {
            case 'v': {
                info.sdp.setVersion((VersionField)field);
                break;
            }
            case 'o': {
                info.sdp.setOrigin((OriginField)field);
                break;
            }
            case 's': {
                info.sdp.setSessionName((SessionNameField)field);
                break;
            }
            case 't': {
                info.sdp.setTiming((TimingField)field);
                break;
            }
            case 'c': {
                if (info.media == null) {
                    info.sdp.setConnection((ConnectionField)field);
                    break;
                }
                info.media.setConnection((ConnectionField)field);
                break;
            }
            case 'm': {
                info.media = (MediaDescriptionField)field;
                info.sdp.addMediaDescription(info.media);
                info.media.setSession(info.sdp);
                break;
            }
        }
    }

    private static void convertAndApplyAttribute(AttributeField attribute, SdpParsingInfo info) {
        switch (attribute.getKey()) {
            case "rtpmap": {
                info.format = (RtpMapAttribute)attribute;
                info.media.addFormat(info.format);
                break;
            }
            case "fmtp": {
                info.format.setParameters((FormatParameterAttribute)attribute);
                break;
            }
            case "ptime": {
                info.media.setPtime((PacketTimeAttribute)attribute);
                break;
            }
            case "maxptime": {
                info.media.setMaxptime((MaxPacketTimeAttribute)attribute);
                break;
            }
            case "sendonly": 
            case "recvonly": 
            case "sendrecv": 
            case "inactive": {
                if (info.media == null) {
                    info.sdp.setConnectionMode((ConnectionModeAttribute)attribute);
                    break;
                }
                info.media.setConnectionMode((ConnectionModeAttribute)attribute);
                break;
            }
            case "rtcp": {
                info.media.setRtcp((RtcpAttribute)attribute);
                break;
            }
            case "rtcp-mux": {
                info.media.setRtcpMux((RtcpMuxAttribute)attribute);
                break;
            }
            case "ice-lite": {
                info.sdp.setIceLite((IceLiteAttribute)attribute);
                break;
            }
            case "ice-ufrag": {
                if (info.media == null) {
                    info.sdp.setIceUfrag((IceUfragAttribute)attribute);
                    break;
                }
                info.media.setIceUfrag((IceUfragAttribute)attribute);
                break;
            }
            case "ice-pwd": {
                if (info.media == null) {
                    info.sdp.setIcePwd((IcePwdAttribute)attribute);
                    break;
                }
                info.media.setIcePwd((IcePwdAttribute)attribute);
                break;
            }
            case "candidate": {
                info.media.addCandidate((CandidateAttribute)attribute);
                break;
            }
            case "setup": {
                if (info.media == null) {
                    info.sdp.setSetup((SetupAttribute)attribute);
                    break;
                }
                info.media.setSetup((SetupAttribute)attribute);
                break;
            }
            case "fingerprint": {
                if (info.media == null) {
                    info.sdp.setFingerprint((FingerprintAttribute)attribute);
                    break;
                }
                info.media.setFingerprint((FingerprintAttribute)attribute);
                break;
            }
            case "ssrc": {
                SsrcAttribute ssrc = (SsrcAttribute)attribute;
                SsrcAttribute ssrcAttribute = info.media.getSsrc();
                if (ssrcAttribute == null) {
                    info.media.setSsrc(ssrc);
                    break;
                }
                ssrcAttribute.addAttribute(ssrc.getLastAttribute(), ssrc.getLastValue());
                break;
            }
        }
    }

    private static class SdpParsingInfo {
        final SessionDescription sdp = new SessionDescription();
        MediaDescriptionField media;
        RtpMapAttribute format;
    }
}

