/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.sdp;

import java.util.HashMap;
import java.util.Map;
import org.mobicents.media.server.io.sdp.SdpField;
import org.mobicents.media.server.io.sdp.SdpParser;
import org.mobicents.media.server.io.sdp.attributes.parser.ConnectionModeAttributeParser;
import org.mobicents.media.server.io.sdp.attributes.parser.FormatParameterAttributeParser;
import org.mobicents.media.server.io.sdp.attributes.parser.MaxPacketTimeAttributeParser;
import org.mobicents.media.server.io.sdp.attributes.parser.PacketTimeAttributeParser;
import org.mobicents.media.server.io.sdp.attributes.parser.RtpMapAttributeParser;
import org.mobicents.media.server.io.sdp.attributes.parser.SsrcAttributeParser;
import org.mobicents.media.server.io.sdp.dtls.attributes.parser.FingerprintAttributeParser;
import org.mobicents.media.server.io.sdp.dtls.attributes.parser.SetupAttributeParser;
import org.mobicents.media.server.io.sdp.fields.AttributeField;
import org.mobicents.media.server.io.sdp.fields.parser.ConnectionFieldParser;
import org.mobicents.media.server.io.sdp.fields.parser.MediaDescriptionFieldParser;
import org.mobicents.media.server.io.sdp.fields.parser.OriginFieldParser;
import org.mobicents.media.server.io.sdp.fields.parser.SessionNameFieldParser;
import org.mobicents.media.server.io.sdp.fields.parser.TimingFieldParser;
import org.mobicents.media.server.io.sdp.fields.parser.VersionFieldParser;
import org.mobicents.media.server.io.sdp.ice.attributes.parser.CandidateAttributeParser;
import org.mobicents.media.server.io.sdp.ice.attributes.parser.IceLiteAttributeParser;
import org.mobicents.media.server.io.sdp.ice.attributes.parser.IcePwdAttributeParser;
import org.mobicents.media.server.io.sdp.ice.attributes.parser.IceUfragAttributeParser;
import org.mobicents.media.server.io.sdp.rtcp.attributes.parser.RtcpAttributeParser;
import org.mobicents.media.server.io.sdp.rtcp.attributes.parser.RtcpMuxAttributeParser;

public class SdpParserPipeline {
    private final Map<Character, SdpParser<? extends SdpField>> fieldParsers = new HashMap<Character, SdpParser<? extends SdpField>>(6);
    private final Map<String, SdpParser<? extends AttributeField>> attributeParsers = new HashMap<String, SdpParser<? extends AttributeField>>(16);

    public SdpParserPipeline() {
        this.fieldParsers.put(Character.valueOf('v'), new VersionFieldParser());
        this.fieldParsers.put(Character.valueOf('o'), new OriginFieldParser());
        this.fieldParsers.put(Character.valueOf('s'), new SessionNameFieldParser());
        this.fieldParsers.put(Character.valueOf('t'), new TimingFieldParser());
        this.fieldParsers.put(Character.valueOf('c'), new ConnectionFieldParser());
        this.fieldParsers.put(Character.valueOf('m'), new MediaDescriptionFieldParser());
        ConnectionModeAttributeParser connModeParser = new ConnectionModeAttributeParser();
        this.attributeParsers.put("sendonly", connModeParser);
        this.attributeParsers.put("recvonly", connModeParser);
        this.attributeParsers.put("sendrecv", connModeParser);
        this.attributeParsers.put("inactive", connModeParser);
        this.attributeParsers.put("ptime", new PacketTimeAttributeParser());
        this.attributeParsers.put("maxptime", new MaxPacketTimeAttributeParser());
        this.attributeParsers.put("rtpmap", new RtpMapAttributeParser());
        this.attributeParsers.put("fmtp", new FormatParameterAttributeParser());
        this.attributeParsers.put("rtcp", new RtcpAttributeParser());
        this.attributeParsers.put("rtcp-mux", new RtcpMuxAttributeParser());
        this.attributeParsers.put("ssrc", new SsrcAttributeParser());
        this.attributeParsers.put("ice-lite", new IceLiteAttributeParser());
        this.attributeParsers.put("ice-pwd", new IcePwdAttributeParser());
        this.attributeParsers.put("ice-ufrag", new IceUfragAttributeParser());
        this.attributeParsers.put("candidate", new CandidateAttributeParser());
        this.attributeParsers.put("setup", new SetupAttributeParser());
        this.attributeParsers.put("fingerprint", new FingerprintAttributeParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFieldParser(char type, SdpParser<? extends SdpField> parser) {
        Map<Character, SdpParser<? extends SdpField>> map = this.fieldParsers;
        synchronized (map) {
            this.fieldParsers.put(Character.valueOf(type), parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFieldParser(char type) {
        Map<Character, SdpParser<? extends SdpField>> map = this.fieldParsers;
        synchronized (map) {
            this.fieldParsers.remove(Character.valueOf(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFieldParsers() {
        Map<Character, SdpParser<? extends SdpField>> map = this.fieldParsers;
        synchronized (map) {
            this.fieldParsers.clear();
        }
    }

    public SdpParser<? extends SdpField> getFieldParser(char type) {
        return this.fieldParsers.get(Character.valueOf(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributeParser(String type, SdpParser<? extends AttributeField> parser) {
        Map<String, SdpParser<? extends AttributeField>> map = this.attributeParsers;
        synchronized (map) {
            this.attributeParsers.put(type, parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeParser(String type) {
        Map<String, SdpParser<? extends AttributeField>> map = this.attributeParsers;
        synchronized (map) {
            this.attributeParsers.remove(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAttributeParsers() {
        Map<String, SdpParser<? extends AttributeField>> map = this.attributeParsers;
        synchronized (map) {
            this.attributeParsers.clear();
        }
    }

    public SdpParser<? extends AttributeField> getAttributeParser(String type) {
        return this.attributeParsers.get(type);
    }
}

