/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.interpreter.rcml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.interpreter.rcml.Attribute;
import org.mobicents.servlet.restcomm.interpreter.rcml.Tag;

@ThreadSafe
public final class TagPrinter {
    private static final int TAB_SPACES = 2;

    private TagPrinter() {
    }

    public static String print(Tag tag) {
        int depth;
        StringBuilder buffer = new StringBuilder();
        Iterator<Tag> iterator = tag.iterator();
        Stack<Tag> parents = new Stack<Tag>();
        while (iterator.hasNext()) {
            Tag current = iterator.next();
            if (!parents.isEmpty() && parents.peek() != current.parent()) {
                Tag parent = (Tag)parents.pop();
                int depth2 = TagPrinter.getTagDepth(parent);
                TagPrinter.appendClosingTag(buffer, depth2, parent);
            }
            depth = TagPrinter.getTagDepth(current);
            TagPrinter.appendOpeningTag(buffer, depth, current);
            if (!current.hasChildren()) {
                TagPrinter.appendText(buffer, depth, current);
                TagPrinter.appendClosingTag(buffer, depth, current);
                continue;
            }
            parents.push(current);
        }
        if (!parents.isEmpty()) {
            Tag parent = (Tag)parents.pop();
            depth = TagPrinter.getTagDepth(parent);
            TagPrinter.appendClosingTag(buffer, depth, parent);
        }
        return buffer.toString();
    }

    private static void appendAttributes(StringBuilder buffer, Tag tag) {
        List<Attribute> attributes = tag.attributes();
        for (int index = 0; index < attributes.size(); ++index) {
            Attribute attribute = attributes.get(index);
            buffer.append(attribute.name()).append("=\"").append(attribute.value()).append("\"");
            if (index >= attributes.size() - 1) continue;
            buffer.append(" ");
        }
    }

    private static void appendOpeningTag(StringBuilder buffer, int tabs, Tag tag) {
        TagPrinter.appendTabs(buffer, tabs);
        buffer.append("<").append(tag.name());
        if (tag.hasAttributes()) {
            buffer.append(" ");
            TagPrinter.appendAttributes(buffer, tag);
        }
        if (tag.hasChildren() || tag.text() != null) {
            buffer.append(">");
        } else {
            buffer.append("/>");
        }
        buffer.append("\n");
    }

    private static void appendClosingTag(StringBuilder buffer, int tabs, Tag tag) {
        if (tag.hasChildren() || tag.text() != null) {
            TagPrinter.appendTabs(buffer, tabs);
            buffer.append("</").append(tag.name()).append(">");
            buffer.append("\n");
        }
    }

    private static void appendTabs(StringBuilder buffer, int tabs) {
        int spaces = tabs * 2;
        for (int counter = 0; counter < spaces; ++counter) {
            buffer.append(" ");
        }
    }

    private static void appendText(StringBuilder buffer, int tabs, Tag tag) {
        String text = tag.text();
        if (text != null && !text.isEmpty()) {
            ByteArrayInputStream input = new ByteArrayInputStream(text.getBytes());
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            try {
                String line = reader.readLine();
                while (line != null) {
                    TagPrinter.appendTabs(buffer, tabs + 1);
                    buffer.append(line);
                    buffer.append("\n");
                    line = reader.readLine();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    private static int getTagDepth(Tag tag) {
        int depth = 0;
        for (Tag parent = tag.parent(); parent != null; parent = parent.parent()) {
            ++depth;
        }
        return depth;
    }
}

