/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.interpreter.rcml;

import akka.actor.ActorRef;
import akka.actor.UntypedActor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.mobicents.servlet.restcomm.interpreter.rcml.Attribute;
import org.mobicents.servlet.restcomm.interpreter.rcml.End;
import org.mobicents.servlet.restcomm.interpreter.rcml.GetNextVerb;
import org.mobicents.servlet.restcomm.interpreter.rcml.Tag;
import org.mobicents.servlet.restcomm.interpreter.rcml.Verbs;

public final class Parser
extends UntypedActor {
    private final Tag document;
    private final Iterator<Tag> iterator;
    private Tag current;

    public Parser(InputStream input) throws IOException {
        this(new InputStreamReader(input));
    }

    public Parser(Reader reader) throws IOException {
        XMLInputFactory inputs = XMLInputFactory.newInstance();
        inputs.setProperty("javax.xml.stream.isCoalescing", true);
        XMLStreamReader stream = null;
        try {
            stream = inputs.createXMLStreamReader(reader);
            this.document = this.parse(stream);
            if (this.document == null) {
                throw new IOException("There was an error parsing the RCML.");
            }
            this.iterator = this.document.iterator();
        }
        catch (XMLStreamException exception) {
            throw new IOException(exception);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (XMLStreamException nested) {
                    throw new IOException(nested);
                }
            }
        }
    }

    public Parser(String text) throws IOException {
        this(new StringReader(text.trim().replaceAll("&([^;]+(?!(?:\\w|;)))", "&amp;$1")));
    }

    private void end(Stack<Tag.Builder> builders, XMLStreamReader stream) {
        if (builders.size() > 1) {
            Tag.Builder builder = builders.pop();
            Tag tag = builder.build();
            builders.peek().addChild(tag);
        }
    }

    private void start(Stack<Tag.Builder> builders, XMLStreamReader stream) {
        Tag.Builder builder = Tag.builder();
        builder.setName(stream.getLocalName());
        int limit = stream.getAttributeCount();
        for (int index = 0; index < limit; ++index) {
            String name = stream.getAttributeLocalName(index);
            String value = stream.getAttributeValue(index).trim();
            Attribute attribute = new Attribute(name, value);
            builder.addAttribute(attribute);
        }
        builders.push(builder);
    }

    private Tag next() {
        while (this.iterator.hasNext()) {
            List<Tag> children;
            Tag tag = this.iterator.next();
            if (!Verbs.isVerb(tag) || this.current != null && this.current.hasChildren() && (children = this.current.children()).contains(tag)) continue;
            this.current = tag;
            return this.current;
        }
        return null;
    }

    private Tag parse(XMLStreamReader stream) throws IOException, XMLStreamException {
        Stack<Tag.Builder> builders = new Stack<Tag.Builder>();
        while (stream.hasNext()) {
            switch (stream.next()) {
                case 1: {
                    this.start(builders, stream);
                    break;
                }
                case 4: {
                    this.text(builders, stream);
                    break;
                }
                case 2: {
                    this.end(builders, stream);
                    break;
                }
                case 8: {
                    if (builders.isEmpty()) break;
                    return builders.pop().build();
                }
            }
        }
        return null;
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (GetNextVerb.class.equals(klass)) {
            Tag verb = this.next();
            if (verb != null) {
                sender.tell((Object)verb, self);
            } else {
                End end = End.instance();
                sender.tell((Object)end, sender);
            }
        }
    }

    private void text(Stack<Tag.Builder> builders, XMLStreamReader stream) {
        if (!stream.isWhiteSpace()) {
            Tag.Builder builder = builders.peek();
            String text = stream.getText().trim();
            builder.setText(text);
        }
    }
}

