/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActorContext;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.mobicents.servlet.restcomm.asr.AsrResponse;
import org.mobicents.servlet.restcomm.cache.DiskCacheResponse;
import org.mobicents.servlet.restcomm.dao.CallDetailRecordsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.NotificationsDao;
import org.mobicents.servlet.restcomm.entities.CallDetailRecord;
import org.mobicents.servlet.restcomm.entities.Notification;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.fax.FaxResponse;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.http.client.DownloaderResponse;
import org.mobicents.servlet.restcomm.http.client.HttpRequestDescriptor;
import org.mobicents.servlet.restcomm.http.client.HttpResponseDescriptor;
import org.mobicents.servlet.restcomm.interpreter.BaseVoiceInterpreter;
import org.mobicents.servlet.restcomm.interpreter.Fork;
import org.mobicents.servlet.restcomm.interpreter.StartForking;
import org.mobicents.servlet.restcomm.interpreter.StartGathering;
import org.mobicents.servlet.restcomm.interpreter.StartInterpreter;
import org.mobicents.servlet.restcomm.interpreter.StopInterpreter;
import org.mobicents.servlet.restcomm.interpreter.SubVoiceInterpreterBuilder;
import org.mobicents.servlet.restcomm.interpreter.rcml.Attribute;
import org.mobicents.servlet.restcomm.interpreter.rcml.End;
import org.mobicents.servlet.restcomm.interpreter.rcml.GetNextVerb;
import org.mobicents.servlet.restcomm.interpreter.rcml.Tag;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupResponse;
import org.mobicents.servlet.restcomm.mscontrol.messages.Mute;
import org.mobicents.servlet.restcomm.mscontrol.messages.Play;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.Unmute;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import org.mobicents.servlet.restcomm.sms.SmsServiceResponse;
import org.mobicents.servlet.restcomm.sms.SmsSessionResponse;
import org.mobicents.servlet.restcomm.telephony.AddParticipant;
import org.mobicents.servlet.restcomm.telephony.Answer;
import org.mobicents.servlet.restcomm.telephony.BridgeManagerResponse;
import org.mobicents.servlet.restcomm.telephony.BridgeStateChanged;
import org.mobicents.servlet.restcomm.telephony.CallInfo;
import org.mobicents.servlet.restcomm.telephony.CallManagerResponse;
import org.mobicents.servlet.restcomm.telephony.CallResponse;
import org.mobicents.servlet.restcomm.telephony.CallStateChanged;
import org.mobicents.servlet.restcomm.telephony.Cancel;
import org.mobicents.servlet.restcomm.telephony.ConferenceCenterResponse;
import org.mobicents.servlet.restcomm.telephony.ConferenceInfo;
import org.mobicents.servlet.restcomm.telephony.ConferenceModeratorPresent;
import org.mobicents.servlet.restcomm.telephony.ConferenceResponse;
import org.mobicents.servlet.restcomm.telephony.ConferenceStateChanged;
import org.mobicents.servlet.restcomm.telephony.CreateBridge;
import org.mobicents.servlet.restcomm.telephony.CreateCall;
import org.mobicents.servlet.restcomm.telephony.CreateConference;
import org.mobicents.servlet.restcomm.telephony.DestroyCall;
import org.mobicents.servlet.restcomm.telephony.DestroyConference;
import org.mobicents.servlet.restcomm.telephony.Dial;
import org.mobicents.servlet.restcomm.telephony.GetCallInfo;
import org.mobicents.servlet.restcomm.telephony.GetConferenceInfo;
import org.mobicents.servlet.restcomm.telephony.GetOutboundCall;
import org.mobicents.servlet.restcomm.telephony.Hangup;
import org.mobicents.servlet.restcomm.telephony.JoinCalls;
import org.mobicents.servlet.restcomm.telephony.Reject;
import org.mobicents.servlet.restcomm.telephony.RemoveParticipant;
import org.mobicents.servlet.restcomm.telephony.StartBridge;
import org.mobicents.servlet.restcomm.telephony.StopBridge;
import org.mobicents.servlet.restcomm.telephony.StopConference;
import org.mobicents.servlet.restcomm.tts.api.SpeechSynthesizerResponse;
import org.mobicents.servlet.restcomm.util.UriUtils;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public final class VoiceInterpreter
extends BaseVoiceInterpreter {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State startDialing;
    private final State processingDialChildren;
    private final State acquiringOutboundCallInfo;
    private final State forking;
    private final State creatingBridge;
    private final State initializingBridge;
    private final State bridging;
    private final State bridged;
    private final State finishDialing;
    private final State acquiringConferenceInfo;
    private final State joiningConference;
    private final State conferencing;
    private final State finishConferencing;
    private final State downloadingRcml;
    private final State downloadingFallbackRcml;
    private final State initializingCall;
    private final State ready;
    private final State notFound;
    private final State rejecting;
    private final State finished;
    private final ActorRef conferenceManager;
    private boolean isForking;
    private List<ActorRef> dialBranches;
    private List<Tag> dialChildren;
    private Map<ActorRef, Tag> dialChildrenWithAttributes;
    private ActorRef conference;
    private ConferenceInfo conferenceInfo;
    private ConferenceStateChanged.State conferenceState;
    private boolean muteCall;
    private boolean startConferenceOnEnter = true;
    private ActorRef confSubVoiceInterpreter;
    private Attribute dialRecordAttribute;
    private boolean dialActionExecuted = false;
    private ActorRef sender;
    private boolean liveCallModification = false;
    private boolean recordingCall = true;
    private final ActorRef bridgeManager;
    private ActorRef bridge;

    public VoiceInterpreter(Configuration configuration, Sid account, Sid phone, String version, URI url, String method, URI fallbackUrl, String fallbackMethod, URI statusCallback, String statusCallbackMethod, String emailAddress, ActorRef callManager, ActorRef conferenceManager, ActorRef bridgeManager, ActorRef sms, DaoManager storage) {
        ActorRef source = this.self();
        this.downloadingRcml = new State("downloading rcml", (Action)new DownloadingRcml(source), null);
        this.downloadingFallbackRcml = new State("downloading fallback rcml", (Action)new DownloadingFallbackRcml(source), null);
        this.initializingCall = new State("initializing call", (Action)new InitializingCall(source), null);
        this.ready = new State("ready", (Action)new Ready(source), null);
        this.notFound = new State("notFound", (Action)new NotFound(source), null);
        this.rejecting = new State("rejecting", (Action)new Rejecting(source), null);
        this.startDialing = new State("start dialing", (Action)new StartDialing(source), null);
        this.processingDialChildren = new State("processing dial children", (Action)new ProcessingDialChildren(source), null);
        this.acquiringOutboundCallInfo = new State("acquiring outbound call info", (Action)new AcquiringOutboundCallInfo(source), null);
        this.forking = new State("forking", (Action)new Forking(source), null);
        this.creatingBridge = new State("creating bridge", (Action)new CreatingBridge(source), null);
        this.initializingBridge = new State("initializing bridge", (Action)new InitializingBridge(source), null);
        this.bridging = new State("bridging", (Action)new Bridging(source), null);
        this.bridged = new State("bridged", (Action)new Bridged(source), null);
        this.finishDialing = new State("finish dialing", (Action)new FinishDialing(source), null);
        this.acquiringConferenceInfo = new State("acquiring conference info", (Action)new AcquiringConferenceInfo(source), null);
        this.joiningConference = new State("joining conference", (Action)new JoiningConference(source), null);
        this.conferencing = new State("conferencing", (Action)new Conferencing(source), null);
        this.finishConferencing = new State("finish conferencing", (Action)new FinishConferencing(source), null);
        this.finished = new State("finished", (Action)new Finished(source), null);
        this.transitions.add(new Transition(this.acquiringAsrInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringSynthesizerInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.initializingCall));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.downloadingRcml));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.finished));
        this.transitions.add(new Transition(this.initializingCall, this.downloadingRcml));
        this.transitions.add(new Transition(this.initializingCall, this.hangingUp));
        this.transitions.add(new Transition(this.initializingCall, this.finished));
        this.transitions.add(new Transition(this.downloadingRcml, this.ready));
        this.transitions.add(new Transition(this.downloadingRcml, this.notFound));
        this.transitions.add(new Transition(this.downloadingRcml, this.downloadingFallbackRcml));
        this.transitions.add(new Transition(this.downloadingRcml, this.hangingUp));
        this.transitions.add(new Transition(this.downloadingRcml, this.finished));
        this.transitions.add(new Transition(this.downloadingFallbackRcml, this.ready));
        this.transitions.add(new Transition(this.downloadingFallbackRcml, this.hangingUp));
        this.transitions.add(new Transition(this.downloadingFallbackRcml, this.finished));
        this.transitions.add(new Transition(this.ready, this.initializingCall));
        this.transitions.add(new Transition(this.ready, this.faxing));
        this.transitions.add(new Transition(this.ready, this.pausing));
        this.transitions.add(new Transition(this.ready, this.checkingCache));
        this.transitions.add(new Transition(this.ready, this.caching));
        this.transitions.add(new Transition(this.ready, this.synthesizing));
        this.transitions.add(new Transition(this.ready, this.rejecting));
        this.transitions.add(new Transition(this.ready, this.redirecting));
        this.transitions.add(new Transition(this.ready, this.processingGatherChildren));
        this.transitions.add(new Transition(this.ready, this.creatingRecording));
        this.transitions.add(new Transition(this.ready, this.creatingSmsSession));
        this.transitions.add(new Transition(this.ready, this.startDialing));
        this.transitions.add(new Transition(this.ready, this.hangingUp));
        this.transitions.add(new Transition(this.ready, this.finished));
        this.transitions.add(new Transition(this.pausing, this.ready));
        this.transitions.add(new Transition(this.pausing, this.finished));
        this.transitions.add(new Transition(this.rejecting, this.finished));
        this.transitions.add(new Transition(this.faxing, this.ready));
        this.transitions.add(new Transition(this.faxing, this.finished));
        this.transitions.add(new Transition(this.caching, this.finished));
        this.transitions.add(new Transition(this.playing, this.ready));
        this.transitions.add(new Transition(this.playing, this.finished));
        this.transitions.add(new Transition(this.synthesizing, this.finished));
        this.transitions.add(new Transition(this.redirecting, this.ready));
        this.transitions.add(new Transition(this.redirecting, this.finished));
        this.transitions.add(new Transition(this.creatingRecording, this.finished));
        this.transitions.add(new Transition(this.finishRecording, this.ready));
        this.transitions.add(new Transition(this.finishRecording, this.finished));
        this.transitions.add(new Transition(this.processingGatherChildren, this.finished));
        this.transitions.add(new Transition(this.gathering, this.finished));
        this.transitions.add(new Transition(this.finishGathering, this.ready));
        this.transitions.add(new Transition(this.finishGathering, this.finishGathering));
        this.transitions.add(new Transition(this.finishGathering, this.finished));
        this.transitions.add(new Transition(this.creatingSmsSession, this.finished));
        this.transitions.add(new Transition(this.sendingSms, this.ready));
        this.transitions.add(new Transition(this.sendingSms, this.startDialing));
        this.transitions.add(new Transition(this.sendingSms, this.finished));
        this.transitions.add(new Transition(this.startDialing, this.processingDialChildren));
        this.transitions.add(new Transition(this.startDialing, this.acquiringConferenceInfo));
        this.transitions.add(new Transition(this.startDialing, this.faxing));
        this.transitions.add(new Transition(this.startDialing, this.pausing));
        this.transitions.add(new Transition(this.startDialing, this.checkingCache));
        this.transitions.add(new Transition(this.startDialing, this.caching));
        this.transitions.add(new Transition(this.startDialing, this.synthesizing));
        this.transitions.add(new Transition(this.startDialing, this.redirecting));
        this.transitions.add(new Transition(this.startDialing, this.processingGatherChildren));
        this.transitions.add(new Transition(this.startDialing, this.creatingRecording));
        this.transitions.add(new Transition(this.startDialing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.startDialing, this.startDialing));
        this.transitions.add(new Transition(this.startDialing, this.hangingUp));
        this.transitions.add(new Transition(this.startDialing, this.finished));
        this.transitions.add(new Transition(this.processingDialChildren, this.processingDialChildren));
        this.transitions.add(new Transition(this.processingDialChildren, this.forking));
        this.transitions.add(new Transition(this.processingDialChildren, this.hangingUp));
        this.transitions.add(new Transition(this.processingDialChildren, this.finished));
        this.transitions.add(new Transition(this.forking, this.acquiringOutboundCallInfo));
        this.transitions.add(new Transition(this.forking, this.finishDialing));
        this.transitions.add(new Transition(this.forking, this.hangingUp));
        this.transitions.add(new Transition(this.forking, this.finished));
        this.transitions.add(new Transition(this.acquiringOutboundCallInfo, this.hangingUp));
        this.transitions.add(new Transition(this.acquiringOutboundCallInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringOutboundCallInfo, this.creatingBridge));
        this.transitions.add(new Transition(this.creatingBridge, this.initializingBridge));
        this.transitions.add(new Transition(this.creatingBridge, this.finishDialing));
        this.transitions.add(new Transition(this.initializingBridge, this.bridging));
        this.transitions.add(new Transition(this.initializingBridge, this.hangingUp));
        this.transitions.add(new Transition(this.bridging, this.bridged));
        this.transitions.add(new Transition(this.bridging, this.finishDialing));
        this.transitions.add(new Transition(this.bridged, this.finishDialing));
        this.transitions.add(new Transition(this.bridged, this.finished));
        this.transitions.add(new Transition(this.finishDialing, this.ready));
        this.transitions.add(new Transition(this.finishDialing, this.faxing));
        this.transitions.add(new Transition(this.finishDialing, this.pausing));
        this.transitions.add(new Transition(this.finishDialing, this.checkingCache));
        this.transitions.add(new Transition(this.finishDialing, this.caching));
        this.transitions.add(new Transition(this.finishDialing, this.synthesizing));
        this.transitions.add(new Transition(this.finishDialing, this.redirecting));
        this.transitions.add(new Transition(this.finishDialing, this.processingGatherChildren));
        this.transitions.add(new Transition(this.finishDialing, this.creatingRecording));
        this.transitions.add(new Transition(this.finishDialing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.finishDialing, this.startDialing));
        this.transitions.add(new Transition(this.finishDialing, this.hangingUp));
        this.transitions.add(new Transition(this.finishDialing, this.finished));
        this.transitions.add(new Transition(this.finishDialing, this.initializingCall));
        this.transitions.add(new Transition(this.acquiringConferenceInfo, this.joiningConference));
        this.transitions.add(new Transition(this.acquiringConferenceInfo, this.hangingUp));
        this.transitions.add(new Transition(this.acquiringConferenceInfo, this.finished));
        this.transitions.add(new Transition(this.joiningConference, this.conferencing));
        this.transitions.add(new Transition(this.joiningConference, this.hangingUp));
        this.transitions.add(new Transition(this.joiningConference, this.finished));
        this.transitions.add(new Transition(this.conferencing, this.finishConferencing));
        this.transitions.add(new Transition(this.conferencing, this.hangingUp));
        this.transitions.add(new Transition(this.conferencing, this.finished));
        this.transitions.add(new Transition(this.finishConferencing, this.ready));
        this.transitions.add(new Transition(this.finishConferencing, this.faxing));
        this.transitions.add(new Transition(this.finishConferencing, this.pausing));
        this.transitions.add(new Transition(this.finishConferencing, this.checkingCache));
        this.transitions.add(new Transition(this.finishConferencing, this.caching));
        this.transitions.add(new Transition(this.finishConferencing, this.synthesizing));
        this.transitions.add(new Transition(this.finishConferencing, this.redirecting));
        this.transitions.add(new Transition(this.finishConferencing, this.processingGatherChildren));
        this.transitions.add(new Transition(this.finishConferencing, this.creatingRecording));
        this.transitions.add(new Transition(this.finishConferencing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.finishConferencing, this.startDialing));
        this.transitions.add(new Transition(this.finishConferencing, this.hangingUp));
        this.transitions.add(new Transition(this.finishConferencing, this.finished));
        this.transitions.add(new Transition(this.hangingUp, this.finished));
        this.transitions.add(new Transition(this.hangingUp, this.finishDialing));
        this.transitions.add(new Transition(this.uninitialized, this.finished));
        this.fsm = new FiniteStateMachine(this.uninitialized, this.transitions);
        this.accountId = account;
        this.phoneId = phone;
        this.version = version;
        this.url = url;
        this.method = method;
        this.fallbackUrl = fallbackUrl;
        this.fallbackMethod = fallbackMethod;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.emailAddress = emailAddress;
        this.configuration = configuration;
        this.callManager = callManager;
        this.conferenceManager = conferenceManager;
        this.bridgeManager = bridgeManager;
        this.asrService = this.asr(configuration.subset("speech-recognizer"));
        this.faxService = this.fax(configuration.subset("fax-service"));
        this.smsService = sms;
        this.smsSessions = new HashMap();
        this.storage = storage;
        this.synthesizer = this.tts(configuration.subset("speech-synthesizer"));
        this.mailer = this.mailer(configuration.subset("smtp"));
        Configuration runtime = configuration.subset("runtime-settings");
        String path = runtime.getString("cache-path");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.cachePath = path = path + this.accountId.toString();
        String uri = runtime.getString("cache-uri");
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.accountId.toString();
        this.cache = this.cache(path, uri);
        this.downloader = this.downloader();
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private Notification notification(int log, int error, String message) {
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(this.accountId);
        builder.setCallSid(this.callInfo.sid());
        builder.setApiVersion(this.version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        if (this.request != null) {
            builder.setRequestUrl(this.request.getUri());
            builder.setRequestMethod(this.request.getMethod());
            builder.setRequestVariables(this.request.getParametersAsString());
        }
        if (this.response != null) {
            builder.setResponseHeaders(this.response.getHeadersAsString());
            String type = this.response.getContentType();
            if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                try {
                    builder.setResponseBody(this.response.getContentAsString());
                }
                catch (IOException exception) {
                    this.logger.error("There was an error while reading the contents of the resource located @ " + this.url.toString(), (Object)exception);
                }
            }
        }
        buffer = new StringBuilder();
        buffer.append("/").append(this.version).append("/Accounts/");
        buffer.append(this.accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        this.sender = this.sender();
        ActorRef self = this.self();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** VoiceInterpreter's " + this.self().path() + " Current State: " + state.toString());
            this.logger.info(" ********** VoiceInterpreter's " + this.self().path() + " Processing Message: " + klass.getName());
        }
        if (StartInterpreter.class.equals(klass)) {
            this.fsm.transition(message, this.acquiringAsrInfo);
            return;
        }
        if (AsrResponse.class.equals(klass)) {
            if (this.outstandingAsrRequests > 0) {
                this.asrResponse(message);
                return;
            }
            this.fsm.transition(message, this.acquiringSynthesizerInfo);
            return;
        }
        if (SpeechSynthesizerResponse.class.equals(klass)) {
            if (this.acquiringSynthesizerInfo.equals((Object)state)) {
                this.fsm.transition(message, this.acquiringCallInfo);
                return;
            }
            if (this.processingGatherChildren.equals((Object)state) || this.processingGather.booleanValue()) {
                SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
                if (response.succeeded()) {
                    this.fsm.transition(message, this.processingGatherChildren);
                    return;
                }
                this.fsm.transition(message, this.hangingUp);
                return;
            }
            if (!this.synthesizing.equals((Object)state)) return;
            SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
            if (response.succeeded()) {
                this.fsm.transition(message, this.caching);
                return;
            }
            this.fsm.transition(message, this.hangingUp);
            return;
        }
        if (CallResponse.class.equals(klass)) {
            if (this.forking.equals((Object)state)) {
                CallResponse response = (CallResponse)message;
                if (this.sender == this.call) {
                    this.callInfo = (CallInfo)response.get();
                    return;
                }
                this.outboundCallInfo = (CallInfo)response.get();
                return;
            }
            if (!this.acquiringCallInfo.equals((Object)state)) {
                if (!this.acquiringOutboundCallInfo.equals((Object)state)) return;
                CallResponse response = (CallResponse)message;
                this.outboundCallInfo = (CallInfo)response.get();
                this.fsm.transition(message, this.creatingBridge);
                return;
            }
            CallResponse response = (CallResponse)message;
            if (this.sender == this.call) {
                this.callInfo = (CallInfo)response.get();
            } else {
                this.outboundCallInfo = (CallInfo)response.get();
            }
            String direction = this.callInfo.direction();
            if ("inbound".equals(direction)) {
                this.fsm.transition(message, this.downloadingRcml);
                return;
            }
            this.fsm.transition(message, this.initializingCall);
            return;
        }
        if (CallStateChanged.class.equals(klass)) {
            CallStateChanged event = (CallStateChanged)message;
            this.callState = event.state();
            if (CallStateChanged.State.RINGING == event.state()) {
                if (!this.forking.equals((Object)state)) return;
                this.outboundCall = this.sender;
                return;
            }
            if (CallStateChanged.State.IN_PROGRESS == event.state()) {
                if (this.initializingCall.equals((Object)state) || this.rejecting.equals((Object)state)) {
                    this.fsm.transition(message, this.downloadingRcml);
                    return;
                }
                if (this.joiningConference.equals((Object)state)) {
                    this.fsm.transition(message, this.conferencing);
                    return;
                }
                if (!this.forking.equals((Object)state)) {
                    if (!this.conferencing.equals((Object)state)) return;
                    if (this.liveCallModification) return;
                    Hangup hangup = new Hangup();
                    this.call.tell((Object)hangup, self);
                    return;
                }
                if (this.outboundCall == null || !this.sender.equals((Object)this.call)) {
                    this.outboundCall = this.sender;
                }
                this.fsm.transition(message, this.acquiringOutboundCallInfo);
                return;
            }
            if (CallStateChanged.State.NO_ANSWER == event.state() || CallStateChanged.State.COMPLETED == event.state() || CallStateChanged.State.FAILED == event.state()) {
                if (this.bridging.equals((Object)state)) {
                    this.fsm.transition(message, this.finishDialing);
                    return;
                }
                if (this.bridged.equals((Object)state) && (this.sender.equals((Object)this.outboundCall) || this.outboundCall != null)) {
                    this.fsm.transition(message, this.finishDialing);
                    return;
                }
                if (this.forking.equals((Object)state) && (this.dialBranches != null && this.dialBranches.contains(this.sender) || this.outboundCall == null)) {
                    this.fsm.transition(message, this.finishDialing);
                    return;
                }
                if (this.creatingRecording.equals((Object)state)) {
                    this.call.tell((Object)new StopMediaGroup(), null);
                    this.fsm.transition(message, this.finishRecording);
                    return;
                }
                if ((this.bridged.equals((Object)state) || this.forking.equals((Object)state)) && this.call == this.sender()) {
                    if (this.dialActionExecuted) return;
                    this.fsm.transition(message, this.finishDialing);
                    return;
                }
                if (this.finishDialing.equals((Object)state)) return;
                this.fsm.transition(message, this.finished);
                return;
            }
            if (CallStateChanged.State.BUSY == event.state()) {
                if (state == this.finishDialing) return;
                this.fsm.transition(message, this.finishDialing);
                return;
            }
            if (CallStateChanged.State.CANCELED != event.state()) return;
            this.callManager.tell((Object)new DestroyCall(this.sender), this.self());
            return;
        }
        if (CallManagerResponse.class.equals(klass)) {
            CallManagerResponse response = (CallManagerResponse)message;
            if (response.succeeded()) {
                if (this.startDialing.equals((Object)state)) {
                    this.fsm.transition(message, this.processingDialChildren);
                    return;
                }
                if (!this.processingDialChildren.equals((Object)state)) return;
                this.fsm.transition(message, this.processingDialChildren);
                return;
            }
            if (state.equals((Object)this.processingDialChildren)) {
                this.executeDialAction(message, this.outboundCall);
            }
            this.fsm.transition(message, this.hangingUp);
            return;
        }
        if (StartForking.class.equals(klass)) {
            this.fsm.transition(message, this.processingDialChildren);
            return;
        }
        if (ConferenceCenterResponse.class.equals(klass)) {
            if (!this.startDialing.equals((Object)state)) return;
            this.fsm.transition(message, this.acquiringConferenceInfo);
            return;
        }
        if (Fork.class.equals(klass)) {
            if (!this.processingDialChildren.equals((Object)state)) return;
            this.fsm.transition(message, this.forking);
            return;
        }
        if (ConferenceResponse.class.equals(klass)) {
            if (!this.acquiringConferenceInfo.equals((Object)state)) return;
            this.fsm.transition(message, this.joiningConference);
            return;
        }
        if (ConferenceStateChanged.class.equals(klass)) {
            ConferenceStateChanged event = (ConferenceStateChanged)message;
            switch (event.state()) {
                case RUNNING_MODERATOR_PRESENT: {
                    this.conferenceState = event.state();
                    this.conferenceStateModeratorPresent(message);
                    return;
                }
            }
            return;
        }
        if (DownloaderResponse.class.equals(klass)) {
            DownloaderResponse response = (DownloaderResponse)message;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rcml URI : " + ((HttpResponseDescriptor)response.get()).getURI() + "response succeeded " + response.succeeded() + ", statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
            }
            if (response.succeeded() && 200 == ((HttpResponseDescriptor)response.get()).getStatusCode()) {
                this.fsm.transition(message, this.ready);
                return;
            }
            if (response.succeeded() && 404 == ((HttpResponseDescriptor)response.get()).getStatusCode()) {
                this.fsm.transition(message, this.notFound);
                return;
            }
            if (!this.downloadingRcml.equals((Object)state)) {
                this.fsm.transition(message, this.finished);
                return;
            }
            if (this.fallbackUrl != null) {
                this.fsm.transition(message, this.downloadingFallbackRcml);
                return;
            }
            this.fsm.transition(message, this.finished);
            return;
        }
        if (DiskCacheResponse.class.equals(klass)) {
            DiskCacheResponse response = (DiskCacheResponse)message;
            if (response.succeeded()) {
                if (!this.caching.equals((Object)state) && !this.checkingCache.equals((Object)state)) {
                    if (!this.processingGatherChildren.equals((Object)state)) return;
                    this.fsm.transition(message, this.processingGatherChildren);
                    return;
                }
                if (!"Play".equals(this.verb.name()) && !"Say".equals(this.verb.name())) {
                    if (!"Fax".equals(this.verb.name())) return;
                    this.fsm.transition(message, this.faxing);
                    return;
                }
                this.fsm.transition(message, this.playing);
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DiskCacheResponse is " + response.toString());
            }
            if (!this.checkingCache.equals((Object)state) && !this.processingGatherChildren.equals((Object)state)) {
                this.fsm.transition(message, this.hangingUp);
                return;
            }
            this.fsm.transition(message, this.synthesizing);
            return;
        }
        if (Tag.class.equals(klass)) {
            this.verb = (Tag)message;
            if (CallStateChanged.State.RINGING == this.callState) {
                if ("Reject".equals(this.verb.name())) {
                    this.fsm.transition(message, this.rejecting);
                    return;
                }
                if ("Pause".equals(this.verb.name())) {
                    this.fsm.transition(message, this.pausing);
                    return;
                }
                this.fsm.transition(message, this.initializingCall);
                return;
            }
            if ("Dial".equals(this.verb.name())) {
                this.dialRecordAttribute = this.verb.attribute("record");
                this.fsm.transition(message, this.startDialing);
                return;
            }
            if ("Fax".equals(this.verb.name())) {
                this.fsm.transition(message, this.caching);
                return;
            }
            if ("Play".equals(this.verb.name())) {
                this.fsm.transition(message, this.caching);
                return;
            }
            if ("Say".equals(this.verb.name())) {
                this.fsm.transition(message, this.checkingCache);
                return;
            }
            if ("Gather".equals(this.verb.name())) {
                this.gatherVerb = this.verb;
                this.fsm.transition(message, this.processingGatherChildren);
                return;
            }
            if ("Pause".equals(this.verb.name())) {
                this.fsm.transition(message, this.pausing);
                return;
            }
            if ("Hangup".equals(this.verb.name())) {
                this.fsm.transition(message, this.hangingUp);
                return;
            }
            if ("Redirect".equals(this.verb.name())) {
                this.fsm.transition(message, this.redirecting);
                return;
            }
            if ("Record".equals(this.verb.name())) {
                this.fsm.transition(message, this.creatingRecording);
                return;
            }
            if ("Sms".equals(this.verb.name())) {
                this.fsm.transition(message, this.creatingSmsSession);
                return;
            }
            this.invalidVerb(this.verb);
            return;
        }
        if (End.class.equals(klass)) {
            this.fsm.transition(message, this.hangingUp);
            return;
        }
        if (StartGathering.class.equals(klass)) {
            this.fsm.transition(message, this.gathering);
            return;
        }
        if (MediaGroupResponse.class.equals(klass)) {
            MediaGroupResponse response = (MediaGroupResponse)message;
            if (!response.succeeded()) {
                this.fsm.transition(message, this.hangingUp);
                return;
            }
            if (this.playingRejectionPrompt.equals((Object)state)) {
                this.fsm.transition(message, this.hangingUp);
                return;
            }
            if (this.playing.equals((Object)state)) {
                this.fsm.transition(message, this.ready);
                return;
            }
            if (this.creatingRecording.equals((Object)state)) {
                this.fsm.transition(message, this.finishRecording);
                return;
            }
            if (this.gathering.equals((Object)state) || this.finishGathering.equals((Object)state) && !this.dtmfReceived.booleanValue()) {
                MediaGroupResponse dtmfResponse = (MediaGroupResponse)message;
                if (this.sender != this.call) {
                    this.collectedDigits.append((String)dtmfResponse.get());
                    this.fsm.transition(message, this.finishGathering);
                    return;
                }
                this.collectedDigits.append((String)dtmfResponse.get());
                if (this.numberOfDigits != Short.MAX_VALUE) {
                    if (this.collectedDigits.length() == this.numberOfDigits) {
                        this.dtmfReceived = true;
                        this.fsm.transition(message, this.finishGathering);
                        return;
                    }
                    this.dtmfReceived = false;
                    return;
                }
                if (this.collectedDigits.toString().endsWith(this.finishOnKey)) {
                    this.dtmfReceived = true;
                    this.fsm.transition(message, this.finishGathering);
                    return;
                }
                this.dtmfReceived = false;
                return;
            }
            if (!this.bridging.equals((Object)state)) return;
            JoinCalls bridgeCalls = new JoinCalls(this.call, this.outboundCall);
            this.bridge.tell((Object)bridgeCalls, self);
            return;
        }
        if (SmsServiceResponse.class.equals(klass)) {
            SmsServiceResponse response = (SmsServiceResponse)message;
            if (response.succeeded()) {
                if (!this.creatingSmsSession.equals((Object)state)) return;
                this.fsm.transition(message, this.sendingSms);
                return;
            }
            this.fsm.transition(message, this.hangingUp);
            return;
        }
        if (SmsSessionResponse.class.equals(klass)) {
            this.smsResponse(message);
            return;
        }
        if (FaxResponse.class.equals(klass)) {
            this.fsm.transition(message, this.ready);
            return;
        }
        if (StopInterpreter.class.equals(klass)) {
            this.liveCallModification = ((StopInterpreter)message).isLiveCallModification();
            if (CallStateChanged.State.IN_PROGRESS.equals((Object)this.callState) && !this.liveCallModification) {
                this.fsm.transition(message, this.hangingUp);
                return;
            }
            this.fsm.transition(message, this.finished);
            return;
        }
        if (message instanceof ReceiveTimeout) {
            if (this.pausing.equals((Object)state)) {
                this.fsm.transition(message, this.ready);
                return;
            }
            if (this.conferencing.equals((Object)state)) {
                this.fsm.transition(message, this.finishConferencing);
                return;
            }
            if (this.forking.equals((Object)state)) {
                this.fsm.transition(message, this.finishDialing);
                return;
            }
            if (this.bridged.equals((Object)state)) {
                this.fsm.transition(message, this.finishDialing);
                return;
            }
            if (!this.bridging.equals((Object)state)) return;
            this.fsm.transition(message, this.finishDialing);
            return;
        }
        if (BridgeManagerResponse.class.equals(klass)) {
            this.onBridgeManagerResponse((BridgeManagerResponse)message, self, this.sender);
            return;
        }
        if (BridgeStateChanged.class.equals(klass)) {
            this.onBridgeStateChanged((BridgeStateChanged)message, self, this.sender);
            return;
        }
        if (!GetOutboundCall.class.equals(klass)) return;
        this.onGetOutboundCall((GetOutboundCall)message, self, this.sender);
    }

    private void onBridgeManagerResponse(BridgeManagerResponse message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.creatingBridge)) {
            this.bridge = (ActorRef)message.get();
            this.fsm.transition((Object)message, this.initializingBridge);
        }
    }

    private void onBridgeStateChanged(BridgeStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.getState()) {
            case READY: {
                if (!this.is(this.initializingBridge)) break;
                this.fsm.transition((Object)message, this.bridging);
                break;
            }
            case BRIDGED: {
                if (!this.is(this.bridging)) break;
                this.fsm.transition((Object)message, this.bridged);
                break;
            }
            case FAILED: {
                if (!this.is(this.initializingBridge)) break;
                this.fsm.transition((Object)message, this.hangingUp);
            }
        }
    }

    private void onGetOutboundCall(GetOutboundCall message, ActorRef self, ActorRef sender) {
        if (this.outboundCall != null) {
            sender.tell((Object)this.outboundCall, self);
        } else {
            sender.tell((Object)new org.mobicents.servlet.restcomm.telephony.NotFound(), sender);
        }
    }

    private void conferenceStateModeratorPresent(Object message) {
        if (!this.startConferenceOnEnter && !this.muteCall) {
            this.logger.info("VoiceInterpreter#conferenceStateModeratorPresent will unmute the call");
            this.call.tell((Object)new Unmute(), this.self());
        }
        if (this.confSubVoiceInterpreter != null) {
            this.logger.info("VoiceInterpreter stopping confSubVoiceInterpreter");
            StopInterpreter stop = new StopInterpreter();
            this.confSubVoiceInterpreter.tell((Object)stop, this.self());
        }
    }

    @Override
    List<NameValuePair> parameters() {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        String callSid = this.callInfo.sid().toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallSid", callSid));
        String accountSid = this.accountId.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("AccountSid", accountSid));
        String from = this.e164(this.callInfo.from());
        parameters.add((NameValuePair)new BasicNameValuePair("From", from));
        String to = this.e164(this.callInfo.to());
        parameters.add((NameValuePair)new BasicNameValuePair("To", to));
        String state = this.callState.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallStatus", state));
        parameters.add((NameValuePair)new BasicNameValuePair("ApiVersion", this.version));
        String direction = this.callInfo.direction();
        parameters.add((NameValuePair)new BasicNameValuePair("Direction", direction));
        String callerName = this.callInfo.fromName();
        parameters.add((NameValuePair)new BasicNameValuePair("CallerName", callerName));
        String forwardedFrom = this.callInfo.forwardedFrom();
        parameters.add((NameValuePair)new BasicNameValuePair("ForwardedFrom", forwardedFrom));
        SipServletResponse lastResponse = this.callInfo.lastResponse();
        if (CreateCall.Type.SIP == this.callInfo.type() && lastResponse != null) {
            int statusCode = lastResponse.getStatus();
            String method = lastResponse.getMethod();
            if (statusCode >= 400 && "INVITE".equalsIgnoreCase(method) || statusCode >= 200 && statusCode < 300 && "BYE".equalsIgnoreCase(method)) {
                String sipCallId = lastResponse.getCallId();
                parameters.add((NameValuePair)new BasicNameValuePair("DialSipCallId", sipCallId));
                parameters.add((NameValuePair)new BasicNameValuePair("DialSipResponseCode", "" + statusCode));
                this.processCustomHeaders((SipServletMessage)lastResponse, "DialSipHeader_", parameters);
            }
        }
        if (lastResponse == null) {
            SipServletRequest invite = this.callInfo.invite();
            if (invite != null) {
                this.processCustomHeaders((SipServletMessage)invite, "SipHeader_", parameters);
            }
        } else {
            this.processCustomHeaders((SipServletMessage)lastResponse, "SipHeader_", parameters);
        }
        return parameters;
    }

    private void processCustomHeaders(SipServletMessage sipMessage, String prefix, List<NameValuePair> parameters) {
        Iterator headerNames = sipMessage.getHeaderNames();
        while (headerNames.hasNext()) {
            String headerName = (String)headerNames.next();
            if (!headerName.startsWith("X-")) continue;
            this.logger.debug("%%%%%%%%%%% Indetified customer header: " + headerName);
            parameters.add((NameValuePair)new BasicNameValuePair(prefix + headerName, sipMessage.getHeader(headerName)));
        }
    }

    private void record(ActorRef target) {
        Configuration runtimeSettings = this.configuration.subset("runtime-settings");
        this.recordingSid = Sid.generate((Sid.Type)Sid.Type.RECORDING);
        String path = runtimeSettings.getString("recordings-path");
        String httpRecordingUri = runtimeSettings.getString("recordings-uri");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!httpRecordingUri.endsWith("/")) {
            httpRecordingUri = httpRecordingUri + "/";
        }
        path = path + this.recordingSid.toString() + ".wav";
        httpRecordingUri = httpRecordingUri + this.recordingSid.toString() + ".wav";
        this.recordingUri = URI.create(path);
        this.publicRecordingUri = URI.create(httpRecordingUri);
        this.recordingCall = true;
        StartRecording message = new StartRecording(this.accountId, this.callInfo.sid(), runtimeSettings, this.storage, this.recordingSid, this.recordingUri);
        target.tell((Object)message, null);
    }

    private void recordCall() {
        this.logger.info("Start recording of the call");
        this.record(this.call);
    }

    private void recordConference() {
        this.logger.info("Start recording of the conference");
        this.record(this.conference);
    }

    private void executeDialAction(Object message, ActorRef outboundCall) {
        String dialCallSid;
        CallResponse callResponse;
        Future future;
        Timeout expires;
        this.logger.info("Proceeding to execute Dial Action attribute");
        this.dialActionExecuted = true;
        List<NameValuePair> parameters = this.parameters();
        Attribute attribute = this.verb.attribute("action");
        if (this.call != null) {
            try {
                this.logger.info("Trying to get outboundCall Info");
                expires = new Timeout(Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
                future = Patterns.ask((ActorRef)this.call, (Object)new GetCallInfo(), (Timeout)expires);
                callResponse = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                this.callInfo = (CallInfo)callResponse.get();
            }
            catch (Exception e) {
                this.logger.error("Timeout waiting for inbound call info: \n" + e);
            }
        }
        if (outboundCall != null) {
            try {
                this.logger.info("Trying to get outboundCall Info");
                expires = new Timeout(Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                future = Patterns.ask((ActorRef)outboundCall, (Object)new GetCallInfo(), (Timeout)expires);
                callResponse = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                this.outboundCallInfo = (CallInfo)callResponse.get();
            }
            catch (Exception e) {
                this.logger.error("Timeout waiting for outbound call info: \n" + e);
            }
        }
        if (message instanceof CallManagerResponse && !((CallManagerResponse)message).succeeded()) {
            parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", null));
            parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", CallStateChanged.State.FAILED.name()));
            parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", "0"));
            parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", null));
            parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", null));
        } else if (message instanceof ReceiveTimeout) {
            if (this.outboundCallInfo != null) {
                dialCallSid = this.outboundCallInfo.sid().toString();
                long dialCallDuration = new Interval((ReadableInstant)this.outboundCallInfo.dateCreated(), (ReadableInstant)DateTime.now()).toDuration().getStandardSeconds();
                String recordingUrl = this.recordingUri == null ? null : this.recordingUri.toString();
                String publicRecordingUrl = this.publicRecordingUri == null ? null : this.publicRecordingUri.toString();
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", dialCallSid));
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", CallStateChanged.State.NO_ANSWER.name()));
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", String.valueOf(dialCallDuration)));
                parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", recordingUrl));
                parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", publicRecordingUrl));
            } else {
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", null));
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", CallStateChanged.State.NO_ANSWER.name()));
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", "0"));
                parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", null));
                parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", null));
            }
        } else if (this.outboundCallInfo != null) {
            dialCallSid = this.outboundCallInfo.sid().toString();
            CallStateChanged.State dialCallStatus = this.outboundCallInfo.state();
            long dialCallDuration = new Interval((ReadableInstant)this.outboundCallInfo.dateCreated(), (ReadableInstant)DateTime.now()).toDuration().getStandardSeconds();
            String recordingUrl = this.recordingUri == null ? null : this.recordingUri.toString();
            String publicRecordingUrl = this.publicRecordingUri == null ? null : this.publicRecordingUri.toString();
            parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", dialCallSid));
            if (this.callInfo.state().equals((Object)CallStateChanged.State.COMPLETED)) {
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", this.callInfo.state().toString()));
            } else {
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", dialCallStatus == null ? null : dialCallStatus.toString()));
            }
            parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", String.valueOf(dialCallDuration)));
            parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", recordingUrl));
            parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", publicRecordingUrl));
        } else {
            parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", null));
            parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", null));
            parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", "0"));
            parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", null));
            parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", null));
        }
        NotificationsDao notifications = this.storage.getNotificationsDao();
        if (attribute != null) {
            this.logger.info("Executing Dial Action attribute.");
            String action = attribute.value();
            if (action != null && !action.isEmpty()) {
                URI target = null;
                try {
                    target = URI.create(action);
                }
                catch (Exception exception) {
                    Notification notification = this.notification(0, 11100, action + " is an invalid URI.");
                    notifications.addNotification(notification);
                    this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.self().tell((Object)stop, this.self());
                    return;
                }
                URI base = this.request.getUri();
                URI uri = UriUtils.resolve((URI)base, (URI)target);
                String method = "POST";
                attribute = this.verb.attribute("method");
                if (attribute != null) {
                    method = attribute.value();
                    if (method != null && !method.isEmpty()) {
                        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                            Notification notification = this.notification(1, 13210, method + " is not a valid HTTP method for <Dial>");
                            notifications.addNotification(notification);
                            method = "POST";
                        }
                    } else {
                        method = "POST";
                    }
                }
                this.logger.info("Dial Action URL: " + uri.toString() + " Method: " + method);
                this.logger.debug("Dial Action parameters: \n" + parameters);
                this.request = new HttpRequestDescriptor(uri, method, parameters);
                this.downloader.tell((Object)this.request, this.self());
                return;
            }
        }
    }

    public void postStop() {
        if (!this.fsm.state().equals((Object)this.uninitialized)) {
            this.logger.info("VoiceIntepreter: " + this.self().path() + "At the postStop() method. Will clean up Voice Interpreter. Keep calls: " + this.liveCallModification);
            if (this.fsm.state().equals((Object)this.bridged) && this.outboundCall != null && !this.liveCallModification) {
                this.logger.info("At postStop(), will clean up outbound call");
                this.outboundCall.tell((Object)new Hangup(), null);
                this.callManager.tell((Object)new DestroyCall(this.outboundCall), null);
                this.outboundCall = null;
            }
            if (this.call != null && !this.liveCallModification) {
                this.logger.info("At postStop(), will clean up call");
                this.callManager.tell((Object)new DestroyCall(this.call), null);
                this.call = null;
            }
            this.getContext().stop(this.self());
            this.postCleanup();
        }
        super.postStop();
    }

    private final class Bridging
    extends AbstractAction {
        public Bridging(ActorRef source) {
            super(source);
        }

        private ActorRef buildSubVoiceInterpreter(Tag child) throws MalformedURLException, URISyntaxException {
            URI url = new URL(child.attribute("url").value()).toURI();
            String method = child.hasAttribute("method") ? child.attribute("method").value().toUpperCase() : "POST";
            SubVoiceInterpreterBuilder builder = new SubVoiceInterpreterBuilder(VoiceInterpreter.this.getContext().system());
            builder.setConfiguration(VoiceInterpreter.this.configuration);
            builder.setStorage(VoiceInterpreter.this.storage);
            builder.setCallManager(this.source);
            builder.setSmsService(VoiceInterpreter.this.smsService);
            builder.setAccount(VoiceInterpreter.this.accountId);
            builder.setVersion(VoiceInterpreter.this.version);
            builder.setUrl(url);
            builder.setMethod(method);
            return builder.build();
        }

        public void execute(Object message) throws Exception {
            VoiceInterpreter.this.logger.info("Joining call from:" + VoiceInterpreter.this.callInfo.from() + " to: " + VoiceInterpreter.this.callInfo.to() + " with outboundCall from: " + VoiceInterpreter.this.outboundCallInfo.from() + " to: " + VoiceInterpreter.this.outboundCallInfo.to());
            Tag child = (Tag)VoiceInterpreter.this.dialChildrenWithAttributes.get(VoiceInterpreter.this.outboundCall);
            if (child != null && child.attribute("url") != null) {
                Timeout expires;
                StartInterpreter start;
                ActorRef interpreter = this.buildSubVoiceInterpreter(child);
                Future future = Patterns.ask((ActorRef)interpreter, (Object)(start = new StartInterpreter(VoiceInterpreter.this.outboundCall)), (Timeout)(expires = new Timeout(Duration.create((long)6000L, (TimeUnit)TimeUnit.SECONDS))));
                Object object = Await.result((Awaitable)future, (Duration)Duration.create((long)6000L, (TimeUnit)TimeUnit.SECONDS));
                if (!End.class.equals(object.getClass())) {
                    VoiceInterpreter.this.fsm.transition(message, VoiceInterpreter.this.hangingUp);
                    return;
                }
                VoiceInterpreter.this.outboundCall.tell((Object)new StopObserving(interpreter), null);
                VoiceInterpreter.this.getContext().stop(interpreter);
            }
            StopMediaGroup stop = new StopMediaGroup();
            VoiceInterpreter.this.call.tell((Object)stop, this.source);
        }
    }

    private final class InitializingBridge
    extends AbstractAction {
        public InitializingBridge(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Observe observe = new Observe(this.source);
            VoiceInterpreter.this.bridge.tell((Object)observe, this.source);
            StartBridge start = new StartBridge();
            VoiceInterpreter.this.bridge.tell((Object)start, this.source);
        }
    }

    private final class CreatingBridge
    extends AbstractAction {
        public CreatingBridge(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            CreateBridge create = new CreateBridge();
            VoiceInterpreter.this.bridgeManager.tell((Object)create, this.source);
        }
    }

    private final class Finished
    extends AbstractAction {
        public Finished(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallStateChanged.class.equals(klass)) {
                CallStateChanged event = (CallStateChanged)message;
                VoiceInterpreter.this.callState = event.state();
                if (VoiceInterpreter.this.callRecord != null) {
                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStatus(VoiceInterpreter.this.callState.toString());
                    DateTime end = DateTime.now();
                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setEndTime(end);
                    int seconds = (int)(end.getMillis() - VoiceInterpreter.this.callRecord.getStartTime().getMillis()) / 1000;
                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setDuration(Integer.valueOf(seconds));
                    CallDetailRecordsDao records = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
                    records.updateCallDetailRecord(VoiceInterpreter.this.callRecord);
                }
                VoiceInterpreter.this.callback();
            }
            if (VoiceInterpreter.this.bridge != null || VoiceInterpreter.this.is(VoiceInterpreter.this.forking) || VoiceInterpreter.this.is(VoiceInterpreter.this.acquiringOutboundCallInfo)) {
                VoiceInterpreter.this.bridge.tell((Object)new StopBridge(), this.source);
                VoiceInterpreter.this.bridge = null;
                if (VoiceInterpreter.this.outboundCall != null && !VoiceInterpreter.this.liveCallModification) {
                    VoiceInterpreter.this.outboundCall.tell((Object)new StopObserving(this.source), null);
                    VoiceInterpreter.this.outboundCall.tell((Object)new Hangup(), null);
                }
            }
            if (VoiceInterpreter.this.conference != null) {
                String value;
                boolean endOnExit = false;
                Tag child = this.conference(VoiceInterpreter.this.verb);
                Attribute attribute = child.attribute("endConferenceOnExit");
                if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                    endOnExit = Boolean.parseBoolean(value);
                }
                VoiceInterpreter.this.conference.tell((Object)new StopObserving(this.source), null);
                if (endOnExit) {
                    StopConference stop = new StopConference();
                    VoiceInterpreter.this.conference.tell((Object)stop, this.source);
                } else {
                    RemoveParticipant removeParticipant = new RemoveParticipant(VoiceInterpreter.this.call);
                    VoiceInterpreter.this.conference.tell((Object)removeParticipant, this.source);
                }
            }
            if (!VoiceInterpreter.this.liveCallModification) {
                VoiceInterpreter.this.callManager.tell((Object)new DestroyCall(VoiceInterpreter.this.call), this.source);
                if (VoiceInterpreter.this.outboundCall != null) {
                    VoiceInterpreter.this.callManager.tell((Object)new DestroyCall(VoiceInterpreter.this.outboundCall), this.source);
                }
            } else {
                VoiceInterpreter.this.call.tell((Object)new StopMediaGroup(), this.source);
            }
            UntypedActorContext context = VoiceInterpreter.this.getContext();
            context.stop(VoiceInterpreter.this.mailer);
            context.stop(VoiceInterpreter.this.downloader);
            context.stop(VoiceInterpreter.this.asrService);
            context.stop(VoiceInterpreter.this.faxService);
            context.stop(VoiceInterpreter.this.cache);
            context.stop(VoiceInterpreter.this.synthesizer);
            VoiceInterpreter.this.postCleanup();
        }
    }

    private final class FinishConferencing
    extends AbstractDialAction {
        public FinishConferencing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String action;
            ConferenceStateChanged confStateChanged;
            if (message instanceof ReceiveTimeout) {
                UntypedActorContext context = VoiceInterpreter.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
                RemoveParticipant remove = new RemoveParticipant(VoiceInterpreter.this.call);
                VoiceInterpreter.this.conference.tell((Object)remove, this.source);
            }
            if (ConferenceStateChanged.class.equals(message) && ConferenceStateChanged.State.COMPLETED.equals((Object)(confStateChanged = (ConferenceStateChanged)message).state())) {
                DestroyConference destroyConference = new DestroyConference(VoiceInterpreter.this.conferenceInfo.name());
                VoiceInterpreter.this.conferenceManager.tell((Object)destroyConference, this.source);
            }
            VoiceInterpreter.this.conference = null;
            NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
            Attribute attribute = VoiceInterpreter.this.verb.attribute("action");
            if (attribute != null && (action = attribute.value()) != null && !action.isEmpty()) {
                URI target = null;
                try {
                    target = URI.create(action);
                }
                catch (Exception exception) {
                    Notification notification = VoiceInterpreter.this.notification(0, 11100, action + " is an invalid URI.");
                    notifications.addNotification(notification);
                    VoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                URI base = VoiceInterpreter.this.request.getUri();
                URI uri = UriUtils.resolve((URI)base, (URI)target);
                String method = "POST";
                attribute = VoiceInterpreter.this.verb.attribute("method");
                if (attribute != null) {
                    method = attribute.value();
                    if (method != null && !method.isEmpty()) {
                        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                            Notification notification = VoiceInterpreter.this.notification(1, 13210, method + " is not a valid HTTP method for <Dial>");
                            notifications.addNotification(notification);
                            method = "POST";
                        }
                    } else {
                        method = "POST";
                    }
                }
                List<NameValuePair> parameters = VoiceInterpreter.this.parameters();
                VoiceInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                VoiceInterpreter.this.downloader.tell((Object)VoiceInterpreter.this.request, this.source);
                return;
            }
            GetNextVerb next = GetNextVerb.instance();
            VoiceInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    private final class Conferencing
    extends AbstractDialAction {
        public Conferencing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Mute mute;
            String value;
            NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
            Tag child = this.conference(VoiceInterpreter.this.verb);
            Attribute attribute = child.attribute("muted");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                VoiceInterpreter.this.muteCall = Boolean.parseBoolean(value);
            }
            if (VoiceInterpreter.this.muteCall) {
                mute = new Mute();
                VoiceInterpreter.this.call.tell((Object)mute, this.source);
            }
            if ((attribute = child.attribute("startConferenceOnEnter")) != null && (value = attribute.value()) != null && !value.isEmpty()) {
                VoiceInterpreter.this.startConferenceOnEnter = Boolean.parseBoolean(value);
            }
            if (!VoiceInterpreter.this.startConferenceOnEnter && VoiceInterpreter.this.conferenceState == ConferenceStateChanged.State.RUNNING_MODERATOR_ABSENT) {
                boolean playBackground;
                if (!VoiceInterpreter.this.muteCall) {
                    mute = new Mute();
                    VoiceInterpreter.this.logger.info("Muting the call as startConferenceOnEnter =" + VoiceInterpreter.this.startConferenceOnEnter + " callMuted = " + VoiceInterpreter.this.muteCall);
                    VoiceInterpreter.this.call.tell((Object)mute, this.source);
                }
                VoiceInterpreter.this.logger.info("Play background music? " + VoiceInterpreter.this.conferenceInfo.participants().size());
                boolean bl = playBackground = VoiceInterpreter.this.conferenceInfo.participants().size() == 1;
                if (playBackground) {
                    Notification notification;
                    String value2;
                    URI waitUrl = new URL("http://127.0.0.1:8080/restcomm/music/rock/nickleus_-_original_guitar_song_200907251723.wav").toURI();
                    attribute = child.attribute("waitUrl");
                    if (attribute != null && (value2 = attribute.value()) != null && !value2.isEmpty()) {
                        try {
                            waitUrl = URI.create(value2);
                        }
                        catch (Exception exception) {
                            notification = VoiceInterpreter.this.notification(0, 13233, VoiceInterpreter.this.method + " is not a valid waitUrl value for <Conference>");
                            notifications.addNotification(notification);
                            VoiceInterpreter.this.sendMail(notification);
                            StopInterpreter stop = new StopInterpreter();
                            this.source.tell((Object)stop, this.source);
                        }
                    }
                    URI base = VoiceInterpreter.this.request.getUri();
                    waitUrl = UriUtils.resolve((URI)base, (URI)waitUrl);
                    String method = "POST";
                    attribute = child.attribute("waitMethod");
                    if (attribute != null) {
                        method = attribute.value();
                        if (method != null && !method.isEmpty()) {
                            if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                                notification = VoiceInterpreter.this.notification(1, 13234, method + " is not a valid waitMethod value for <Conference>");
                                notifications.addNotification(notification);
                                method = "POST";
                            }
                        } else {
                            method = "POST";
                        }
                    }
                    if (waitUrl != null) {
                        VoiceInterpreter.this.conference.tell((Object)new Play(waitUrl, Short.MAX_VALUE), this.source);
                    }
                }
            } else if (VoiceInterpreter.this.conferenceState == ConferenceStateChanged.State.RUNNING_MODERATOR_ABSENT) {
                VoiceInterpreter.this.conference.tell((Object)new ConferenceModeratorPresent(), this.source);
                Attribute record = VoiceInterpreter.this.verb.attribute("record");
                if (record != null && "true".equalsIgnoreCase(record.value())) {
                    VoiceInterpreter.this.recordConference();
                }
            }
            int timeLimit = this.timeLimit(VoiceInterpreter.this.verb);
            UntypedActorContext context = VoiceInterpreter.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)timeLimit, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    private final class JoiningConference
    extends AbstractDialAction {
        public JoiningConference(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String value;
            ConferenceResponse response = (ConferenceResponse)message;
            VoiceInterpreter.this.conferenceInfo = (ConferenceInfo)response.get();
            VoiceInterpreter.this.conferenceState = VoiceInterpreter.this.conferenceInfo.state();
            Tag child = this.conference(VoiceInterpreter.this.verb);
            int max = 40;
            Attribute attribute = child.attribute("maxParticipants");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    max = Integer.parseInt(value);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (VoiceInterpreter.this.conferenceInfo.participants().size() < max) {
                String value2;
                boolean beep = true;
                attribute = child.attribute("beep");
                if (attribute != null && (value2 = attribute.value()) != null && !value2.isEmpty()) {
                    beep = Boolean.parseBoolean(value2);
                }
                if (beep && ConferenceStateChanged.State.RUNNING_MODERATOR_PRESENT.equals((Object)VoiceInterpreter.this.conferenceInfo.state())) {
                    String path = VoiceInterpreter.this.configuration.subset("runtime-settings").getString("prompts-uri");
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    path = path + "beep.wav";
                    URI uri = null;
                    try {
                        uri = URI.create(path);
                    }
                    catch (Exception exception) {
                        Notification notification = VoiceInterpreter.this.notification(0, 12400, exception.getMessage());
                        NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                        notifications.addNotification(notification);
                        VoiceInterpreter.this.sendMail(notification);
                        StopInterpreter stop = new StopInterpreter();
                        this.source.tell((Object)stop, this.source);
                        return;
                    }
                    Play play = new Play(uri, 1);
                    VoiceInterpreter.this.conference.tell((Object)play, this.source);
                }
                AddParticipant request = new AddParticipant(VoiceInterpreter.this.call);
                VoiceInterpreter.this.conference.tell((Object)request, this.source);
            } else {
                GetNextVerb next = GetNextVerb.instance();
                VoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
        }
    }

    private final class AcquiringConferenceInfo
    extends AbstractDialAction {
        public AcquiringConferenceInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            ConferenceCenterResponse response = (ConferenceCenterResponse)message;
            VoiceInterpreter.this.conference = (ActorRef)response.get();
            VoiceInterpreter.this.conference.tell((Object)new Observe(this.source), this.source);
            VoiceInterpreter.this.conference.tell((Object)new GetConferenceInfo(), this.source);
        }
    }

    private final class FinishDialing
    extends AbstractDialAction {
        public FinishDialing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            State state = VoiceInterpreter.this.fsm.state();
            Attribute attribute = VoiceInterpreter.this.verb.attribute("action");
            if (message instanceof ReceiveTimeout || message instanceof CallStateChanged) {
                if (message instanceof ReceiveTimeout) {
                    VoiceInterpreter.this.logger.info("Received timeout, will cancel calls");
                }
                if (message instanceof CallStateChanged) {
                    VoiceInterpreter.this.logger.info("call state changed. New call state: " + ((CallStateChanged)message).state());
                }
                if (VoiceInterpreter.this.forking.equals((Object)state)) {
                    UntypedActorContext context = VoiceInterpreter.this.getContext();
                    context.setReceiveTimeout((Duration)Duration.Undefined());
                    for (ActorRef branch : VoiceInterpreter.this.dialBranches) {
                        if (branch == VoiceInterpreter.this.outboundCall && attribute != null) {
                            VoiceInterpreter.this.executeDialAction(message, VoiceInterpreter.this.outboundCall);
                        }
                        branch.tell((Object)new Cancel(), this.source);
                    }
                    VoiceInterpreter.this.call.tell((Object)new StopMediaGroup(), null);
                    if (attribute == null) {
                        GetNextVerb next = GetNextVerb.instance();
                        VoiceInterpreter.this.parser.tell((Object)next, this.source);
                    }
                    VoiceInterpreter.this.dialChildren = null;
                    VoiceInterpreter.this.outboundCall = null;
                    return;
                }
                if (VoiceInterpreter.this.bridged.equals((Object)state)) {
                    VoiceInterpreter.this.outboundCall.tell((Object)new Hangup(), this.source);
                }
            }
            if (VoiceInterpreter.this.sender == VoiceInterpreter.this.call) {
                if (VoiceInterpreter.this.outboundCall != null) {
                    VoiceInterpreter.this.outboundCall.tell((Object)new Hangup(), VoiceInterpreter.this.self());
                }
            } else {
                VoiceInterpreter.this.call.tell((Object)new Hangup(), VoiceInterpreter.this.self());
            }
            if (VoiceInterpreter.this.recordingCall && VoiceInterpreter.this.sender == VoiceInterpreter.this.call) {
                VoiceInterpreter.this.recordingCall = false;
            }
            StopBridge stopBridge = new StopBridge();
            VoiceInterpreter.this.bridge.tell((Object)stopBridge, this.source);
            VoiceInterpreter.this.bridge = null;
            if (attribute != null) {
                VoiceInterpreter.this.logger.info("Executing Dial Action url");
                if (VoiceInterpreter.this.outboundCall != null) {
                    VoiceInterpreter.this.executeDialAction(message, VoiceInterpreter.this.outboundCall);
                } else {
                    VoiceInterpreter.this.logger.info("Executing Dial Action url");
                    VoiceInterpreter.this.executeDialAction(message, null);
                }
                return;
            }
            VoiceInterpreter.this.logger.info("Action attribute is null.");
            GetNextVerb next = GetNextVerb.instance();
            VoiceInterpreter.this.parser.tell((Object)next, this.source);
            VoiceInterpreter.this.dialChildren = null;
            VoiceInterpreter.this.outboundCall = null;
        }
    }

    private final class Bridged
    extends AbstractDialAction {
        public Bridged(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            int timeLimit = this.timeLimit(VoiceInterpreter.this.verb);
            UntypedActorContext context = VoiceInterpreter.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)timeLimit, (TimeUnit)TimeUnit.SECONDS));
            if (VoiceInterpreter.this.dialRecordAttribute != null && "true".equalsIgnoreCase(VoiceInterpreter.this.dialRecordAttribute.value())) {
                VoiceInterpreter.this.logger.info("Start recording of the bridge");
                VoiceInterpreter.this.record(VoiceInterpreter.this.bridge);
            }
        }
    }

    private final class AcquiringOutboundCallInfo
    extends AbstractDialAction {
        public AcquiringOutboundCallInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (VoiceInterpreter.this.isForking) {
                VoiceInterpreter.this.dialBranches.remove(VoiceInterpreter.this.outboundCall);
                for (ActorRef branch : VoiceInterpreter.this.dialBranches) {
                    branch.tell((Object)new Cancel(), this.source);
                }
                VoiceInterpreter.this.dialBranches = null;
            }
            VoiceInterpreter.this.outboundCall.tell((Object)new GetCallInfo(), this.source);
        }
    }

    private final class Forking
    extends AbstractDialAction {
        public Forking(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallManagerResponse.class.equals(klass)) {
                CallManagerResponse response = (CallManagerResponse)message;
                VoiceInterpreter.this.outboundCall = (ActorRef)response.get();
                VoiceInterpreter.this.outboundCall.tell((Object)new Observe(this.source), this.source);
                VoiceInterpreter.this.outboundCall.tell((Object)new Dial(), this.source);
            } else if (Fork.class.equals(klass)) {
                Observe observe = new Observe(this.source);
                Dial dial = new Dial();
                for (ActorRef branch : VoiceInterpreter.this.dialBranches) {
                    branch.tell((Object)observe, this.source);
                    branch.tell((Object)dial, this.source);
                }
            }
            String path = VoiceInterpreter.this.configuration.subset("runtime-settings").getString("prompts-uri");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + "ringing.wav";
            URI uri = null;
            try {
                uri = URI.create(path);
            }
            catch (Exception exception) {
                Notification notification = VoiceInterpreter.this.notification(0, 12400, exception.getMessage());
                NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                notifications.addNotification(notification);
                VoiceInterpreter.this.sendMail(notification);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            Play play = new Play(uri, Short.MAX_VALUE);
            VoiceInterpreter.this.call.tell((Object)play, this.source);
            UntypedActorContext context = VoiceInterpreter.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)this.timeout(VoiceInterpreter.this.verb), (TimeUnit)TimeUnit.SECONDS));
        }
    }

    private final class ProcessingDialChildren
    extends AbstractDialAction {
        public ProcessingDialChildren(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallManagerResponse.class.equals(klass)) {
                CallManagerResponse response = (CallManagerResponse)message;
                ActorRef branch = (ActorRef)response.get();
                VoiceInterpreter.this.dialBranches.add(branch);
                Tag child = (Tag)VoiceInterpreter.this.dialChildren.get(0);
                if (child.hasAttributes()) {
                    VoiceInterpreter.this.dialChildrenWithAttributes.put(branch, child);
                }
                VoiceInterpreter.this.dialChildren.remove(child);
            }
            if (!VoiceInterpreter.this.dialChildren.isEmpty()) {
                CreateCall create = null;
                Tag child = (Tag)VoiceInterpreter.this.dialChildren.get(0);
                if ("Client".equals(child.name())) {
                    create = new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.CLIENT, VoiceInterpreter.this.accountId);
                } else if ("Number".equals(child.name())) {
                    create = new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.PSTN, VoiceInterpreter.this.accountId);
                } else if ("Uri".equals(child.name())) {
                    create = new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.SIP, VoiceInterpreter.this.accountId);
                } else if ("Sip".equals(child.name())) {
                    String username = null;
                    String password = null;
                    if (child.attribute("username") != null) {
                        username = child.attribute("username").value();
                    }
                    if (child.attribute("password") != null) {
                        password = child.attribute("password").value();
                    }
                    create = new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), username, password, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.SIP, VoiceInterpreter.this.accountId);
                }
                VoiceInterpreter.this.callManager.tell(create, this.source);
            } else {
                Fork fork = Fork.instance();
                this.source.tell((Object)fork, this.source);
                VoiceInterpreter.this.dialChildren = null;
            }
        }
    }

    private final class StartDialing
    extends AbstractDialAction {
        public StartDialing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String text;
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                VoiceInterpreter.this.verb = (Tag)message;
            }
            if ((text = VoiceInterpreter.this.verb.text()) != null && !text.isEmpty()) {
                Tag.Builder builder = Tag.builder();
                if (text.contains("@")) {
                    builder.setName("Sip");
                } else if (text.startsWith("client")) {
                    builder.setName("Client");
                } else {
                    builder.setName("Number");
                }
                builder.setText(text);
                Tag numberTag = builder.build();
                Tag.Builder tagBuilder = Tag.builder();
                tagBuilder.addChild(numberTag);
                tagBuilder.setIterable(VoiceInterpreter.this.verb.isIterable());
                tagBuilder.setName(VoiceInterpreter.this.verb.name());
                tagBuilder.setParent(VoiceInterpreter.this.verb.parent());
                for (Attribute attribute : VoiceInterpreter.this.verb.attributes()) {
                    if (attribute == null) continue;
                    tagBuilder.addAttribute(attribute);
                }
                VoiceInterpreter.this.verb = null;
                VoiceInterpreter.this.verb = tagBuilder.build();
            }
            if (VoiceInterpreter.this.verb.hasChildren()) {
                Tag child = this.conference(VoiceInterpreter.this.verb);
                if (child != null) {
                    String name = child.text();
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(VoiceInterpreter.this.accountId.toString()).append(":").append(name);
                    CreateConference create = new CreateConference(buffer.toString());
                    VoiceInterpreter.this.conferenceManager.tell((Object)create, this.source);
                } else {
                    VoiceInterpreter.this.dialBranches = new ArrayList();
                    VoiceInterpreter.this.dialChildren = new ArrayList<Tag>(VoiceInterpreter.this.verb.children());
                    VoiceInterpreter.this.dialChildrenWithAttributes = new HashMap();
                    VoiceInterpreter.this.isForking = true;
                    StartForking start = StartForking.instance();
                    this.source.tell((Object)start, this.source);
                }
            } else {
                GetNextVerb next = GetNextVerb.instance();
                VoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
        }
    }

    private abstract class AbstractDialAction
    extends AbstractAction {
        public AbstractDialAction(ActorRef source) {
            super(source);
        }

        protected String callerId(Tag container) {
            Attribute attribute;
            String callerId = null;
            boolean useInitialFromAsCallerId = VoiceInterpreter.this.configuration.subset("runtime-settings").getBoolean("from-address-to-proxied-calls");
            if (useInitialFromAsCallerId) {
                callerId = VoiceInterpreter.this.callInfo.from();
            }
            if (callerId == null && (attribute = VoiceInterpreter.this.verb.attribute("callerId")) != null && (callerId = attribute.value()) != null && !callerId.isEmpty() && (callerId = VoiceInterpreter.this.e164(callerId)) == null) {
                callerId = VoiceInterpreter.this.verb.attribute("callerId").value();
                NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                Notification notification = VoiceInterpreter.this.notification(0, 13214, callerId + " is an invalid callerId.");
                notifications.addNotification(notification);
                VoiceInterpreter.this.sendMail(notification);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return null;
            }
            return callerId;
        }

        protected int timeout(Tag container) {
            String value;
            int timeout = 30;
            Attribute attribute = container.attribute("timeout");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    timeout = Integer.parseInt(value);
                }
                catch (NumberFormatException exception) {
                    NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                    Notification notification = VoiceInterpreter.this.notification(1, 13212, value + " is not a valid timeout value for <Dial>");
                    notifications.addNotification(notification);
                }
            }
            return timeout;
        }

        protected int timeLimit(Tag container) {
            String value;
            int timeLimit = 14400;
            Attribute attribute = container.attribute("timeLimit");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    timeLimit = Integer.parseInt(value);
                }
                catch (NumberFormatException exception) {
                    NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                    Notification notification = VoiceInterpreter.this.notification(1, 13216, value + " is not a valid timeLimit value for <Dial>");
                    notifications.addNotification(notification);
                }
            }
            return timeLimit;
        }
    }

    private final class Rejecting
    extends AbstractAction {
        public Rejecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                VoiceInterpreter.this.verb = (Tag)message;
            }
            String reason = "rejected";
            Attribute attribute = VoiceInterpreter.this.verb.attribute("reason");
            if (attribute != null) {
                reason = attribute.value();
                reason = reason != null && !reason.isEmpty() ? ("rejected".equalsIgnoreCase(reason) ? "rejected" : ("busy".equalsIgnoreCase(reason) ? "busy" : "rejected")) : "rejected";
            }
            if ("rejected".equals(reason)) {
                VoiceInterpreter.this.call.tell((Object)new Answer(), this.source);
            } else {
                VoiceInterpreter.this.call.tell((Object)new Reject(), this.source);
            }
        }
    }

    private final class NotFound
    extends AbstractAction {
        public NotFound(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            DownloaderResponse response = (DownloaderResponse)message;
            if (VoiceInterpreter.this.logger.isDebugEnabled()) {
                VoiceInterpreter.this.logger.debug("response succeeded " + response.succeeded() + ", statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
            }
            Notification notification = VoiceInterpreter.this.notification(1, 21402, "URL Not Found : " + ((HttpResponseDescriptor)response.get()).getURI());
            NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
            notifications.addNotification(notification);
            VoiceInterpreter.this.call.tell((Object)new org.mobicents.servlet.restcomm.telephony.NotFound(), this.source);
        }
    }

    private final class Ready
    extends AbstractAction {
        public Ready(ActorRef source) {
            super(source);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void execute(Object message) throws Exception {
            block11: {
                State state;
                UntypedActorContext context;
                block8: {
                    block9: {
                        String type;
                        block10: {
                            context = VoiceInterpreter.this.getContext();
                            state = VoiceInterpreter.this.fsm.state();
                            if (VoiceInterpreter.this.initializingCall.equals((Object)state)) {
                                CallStateChanged event = (CallStateChanged)message;
                                VoiceInterpreter.this.callState = event.state();
                                VoiceInterpreter.this.callback();
                                if (VoiceInterpreter.this.callRecord != null) {
                                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStatus(VoiceInterpreter.this.callState.toString());
                                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStartTime(DateTime.now());
                                    CallDetailRecordsDao records = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
                                    records.updateCallDetailRecord(VoiceInterpreter.this.callRecord);
                                }
                                this.source.tell((Object)VoiceInterpreter.this.verb, this.source);
                                return;
                            }
                            if (!VoiceInterpreter.this.downloadingRcml.equals((Object)state) && !VoiceInterpreter.this.downloadingFallbackRcml.equals((Object)state) && !VoiceInterpreter.this.redirecting.equals((Object)state) && !VoiceInterpreter.this.finishGathering.equals((Object)state) && !VoiceInterpreter.this.finishRecording.equals((Object)state) && !VoiceInterpreter.this.sendingSms.equals((Object)state) && !VoiceInterpreter.this.finishDialing.equals((Object)state) && !VoiceInterpreter.this.finishConferencing.equals((Object)state)) break block8;
                            VoiceInterpreter.this.response = (HttpResponseDescriptor)((DownloaderResponse)message).get();
                            if (VoiceInterpreter.this.parser != null) {
                                context.stop(VoiceInterpreter.this.parser);
                                VoiceInterpreter.this.parser = null;
                            }
                            if ((type = VoiceInterpreter.this.response.getContentType()) == null) break block9;
                            if (!type.contains("text/xml") && !type.contains("application/xml") && !type.contains("text/html")) break block10;
                            VoiceInterpreter.this.parser = VoiceInterpreter.this.parser(VoiceInterpreter.this.response.getContentAsString());
                            break block11;
                        }
                        if (type.contains("audio/wav") || type.contains("audio/wave") || type.contains("audio/x-wav")) {
                            VoiceInterpreter.this.parser = VoiceInterpreter.this.parser("<Play>" + VoiceInterpreter.this.request.getUri() + "</Play>");
                            break block11;
                        } else if (type.contains("text/plain")) {
                            VoiceInterpreter.this.parser = VoiceInterpreter.this.parser("<Say>" + VoiceInterpreter.this.response.getContentAsString() + "</Say>");
                        }
                        break block11;
                    }
                    if (VoiceInterpreter.this.call != null) {
                        VoiceInterpreter.this.call.tell((Object)new Hangup(), null);
                    }
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                if (VoiceInterpreter.this.pausing.equals((Object)state)) {
                    context.setReceiveTimeout((Duration)Duration.Undefined());
                }
            }
            GetNextVerb next = GetNextVerb.instance();
            VoiceInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    private final class DownloadingFallbackRcml
    extends AbstractAction {
        public DownloadingFallbackRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (DownloaderResponse.class.equals(klass)) {
                DownloaderResponse result = (DownloaderResponse)message;
                Throwable cause = result.cause();
                Notification notification = null;
                if (cause instanceof ClientProtocolException) {
                    notification = VoiceInterpreter.this.notification(0, 11206, cause.getMessage());
                } else if (cause instanceof IOException) {
                    notification = VoiceInterpreter.this.notification(0, 11205, cause.getMessage());
                } else if (cause instanceof URISyntaxException) {
                    notification = VoiceInterpreter.this.notification(0, 11100, cause.getMessage());
                }
                if (notification != null) {
                    NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                    notifications.addNotification(notification);
                    VoiceInterpreter.this.sendMail(notification);
                }
            }
            List<NameValuePair> parameters = VoiceInterpreter.this.parameters();
            VoiceInterpreter.this.request = new HttpRequestDescriptor(VoiceInterpreter.this.fallbackUrl, VoiceInterpreter.this.fallbackMethod, parameters);
            VoiceInterpreter.this.downloader.tell((Object)VoiceInterpreter.this.request, this.source);
        }
    }

    private final class DownloadingRcml
    extends AbstractAction {
        public DownloadingRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            CallDetailRecordsDao records = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
            if (CallResponse.class.equals(klass)) {
                CallResponse response = (CallResponse)message;
                VoiceInterpreter.this.callInfo = (CallInfo)response.get();
                VoiceInterpreter.this.callState = VoiceInterpreter.this.callInfo.state();
                if (VoiceInterpreter.this.callInfo.direction().equals("inbound")) {
                    VoiceInterpreter.this.callRecord = records.getCallDetailRecord(VoiceInterpreter.this.callInfo.sid());
                    if (VoiceInterpreter.this.callRecord == null) {
                        CallDetailRecord.Builder builder = CallDetailRecord.builder();
                        builder.setSid(VoiceInterpreter.this.callInfo.sid());
                        builder.setDateCreated(VoiceInterpreter.this.callInfo.dateCreated());
                        builder.setAccountSid(VoiceInterpreter.this.accountId);
                        builder.setTo(VoiceInterpreter.this.callInfo.to());
                        builder.setCallerName(VoiceInterpreter.this.callInfo.fromName());
                        builder.setFrom(VoiceInterpreter.this.callInfo.from());
                        builder.setForwardedFrom(VoiceInterpreter.this.callInfo.forwardedFrom());
                        builder.setPhoneNumberSid(VoiceInterpreter.this.phoneId);
                        builder.setStatus(VoiceInterpreter.this.callState.toString());
                        DateTime now = DateTime.now();
                        builder.setStartTime(now);
                        builder.setDirection(VoiceInterpreter.this.callInfo.direction());
                        builder.setApiVersion(VoiceInterpreter.this.version);
                        builder.setPrice(new BigDecimal("0.00"));
                        builder.setPriceUnit(Currency.getInstance("USD"));
                        StringBuilder buffer = new StringBuilder();
                        buffer.append("/").append(VoiceInterpreter.this.version).append("/Accounts/");
                        buffer.append(VoiceInterpreter.this.accountId.toString()).append("/Calls/");
                        buffer.append(VoiceInterpreter.this.callInfo.sid().toString());
                        URI uri = URI.create(buffer.toString());
                        builder.setUri(uri);
                        builder.setCallPath(VoiceInterpreter.this.call.path().toString());
                        VoiceInterpreter.this.callRecord = builder.build();
                        records.addCallDetailRecord(VoiceInterpreter.this.callRecord);
                    }
                    VoiceInterpreter.this.callback();
                }
            }
            List<NameValuePair> parameters = VoiceInterpreter.this.parameters();
            VoiceInterpreter.this.request = new HttpRequestDescriptor(VoiceInterpreter.this.url, VoiceInterpreter.this.method, parameters);
            VoiceInterpreter.this.downloader.tell((Object)VoiceInterpreter.this.request, this.source);
        }
    }

    private final class InitializingCall
    extends AbstractAction {
        public InitializingCall(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallResponse.class.equals(klass)) {
                CallResponse response = (CallResponse)message;
                VoiceInterpreter.this.callInfo = (CallInfo)response.get();
                VoiceInterpreter.this.callState = VoiceInterpreter.this.callInfo.state();
                if (VoiceInterpreter.this.callState.name().equalsIgnoreCase(CallStateChanged.State.IN_PROGRESS.name())) {
                    CallStateChanged event = new CallStateChanged(CallStateChanged.State.IN_PROGRESS);
                    this.source.tell((Object)event, this.source);
                    return;
                }
                if (VoiceInterpreter.this.callRecord != null) {
                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStatus(VoiceInterpreter.this.callState.toString());
                    CallDetailRecordsDao records = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
                    records.updateCallDetailRecord(VoiceInterpreter.this.callRecord);
                }
                VoiceInterpreter.this.callback();
                VoiceInterpreter.this.call.tell((Object)new Dial(), this.source);
            } else if (Tag.class.equals(klass)) {
                VoiceInterpreter.this.verb = (Tag)message;
                VoiceInterpreter.this.call.tell((Object)new Answer(), this.source);
            }
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }

        protected Tag conference(Tag container) {
            List<Tag> children = container.children();
            for (Tag child : children) {
                if (!"Conference".equals(child.name())) continue;
                return child;
            }
            return null;
        }
    }
}

