/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.NotificationsDao;
import org.mobicents.servlet.restcomm.dao.SmsMessagesDao;
import org.mobicents.servlet.restcomm.entities.Notification;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.entities.SmsMessage;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.http.client.Downloader;
import org.mobicents.servlet.restcomm.http.client.DownloaderResponse;
import org.mobicents.servlet.restcomm.http.client.HttpRequestDescriptor;
import org.mobicents.servlet.restcomm.http.client.HttpResponseDescriptor;
import org.mobicents.servlet.restcomm.interpreter.StartInterpreter;
import org.mobicents.servlet.restcomm.interpreter.StopInterpreter;
import org.mobicents.servlet.restcomm.interpreter.rcml.Attribute;
import org.mobicents.servlet.restcomm.interpreter.rcml.GetNextVerb;
import org.mobicents.servlet.restcomm.interpreter.rcml.Parser;
import org.mobicents.servlet.restcomm.interpreter.rcml.Tag;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.sms.CreateSmsSession;
import org.mobicents.servlet.restcomm.sms.DestroySmsSession;
import org.mobicents.servlet.restcomm.sms.GetLastSmsRequest;
import org.mobicents.servlet.restcomm.sms.SmsServiceResponse;
import org.mobicents.servlet.restcomm.sms.SmsSessionAttribute;
import org.mobicents.servlet.restcomm.sms.SmsSessionInfo;
import org.mobicents.servlet.restcomm.sms.SmsSessionRequest;
import org.mobicents.servlet.restcomm.sms.SmsSessionResponse;

public final class SmsInterpreter
extends UntypedActor {
    private static final int ERROR_NOTIFICATION = 0;
    private static final int WARNING_NOTIFICATION = 1;
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State uninitialized;
    private final State acquiringLastSmsRequest;
    private final State downloadingRcml;
    private final State downloadingFallbackRcml;
    private final State ready;
    private final State redirecting;
    private final State creatingSmsSession;
    private final State sendingSms;
    private final State waitingForSmsResponses;
    private final State finished;
    private final FiniteStateMachine fsm;
    private final ActorRef service;
    private final Map<Sid, ActorRef> sessions;
    private Sid initialSessionSid;
    private ActorRef initialSession;
    private SmsSessionRequest initialSessionRequest;
    private final ActorRef downloader;
    private final DaoManager storage;
    private final Configuration runtime;
    private final Configuration configuration;
    private final Sid accountId;
    private final String version;
    private final URI url;
    private final String method;
    private final URI fallbackUrl;
    private final String fallbackMethod;
    private HttpRequestDescriptor request;
    private HttpResponseDescriptor response;
    private ActorRef parser;
    private Tag verb;
    private boolean normalizeNumber;
    private ConcurrentHashMap<String, String> customHttpHeaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> customRequestHeaderMap;

    public SmsInterpreter(ActorRef service, Configuration configuration, DaoManager storage, Sid accountId, String version, URI url, String method, URI fallbackUrl, String fallbackMethod) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.acquiringLastSmsRequest = new State("acquiring last sms event", (Action)new AcquiringLastSmsEvent(source), null);
        this.downloadingRcml = new State("downloading rcml", (Action)new DownloadingRcml(source), null);
        this.downloadingFallbackRcml = new State("downloading fallback rcml", (Action)new DownloadingFallbackRcml(source), null);
        this.ready = new State("ready", (Action)new Ready(source), null);
        this.redirecting = new State("redirecting", (Action)new Redirecting(source), null);
        this.creatingSmsSession = new State("creating sms session", (Action)new CreatingSmsSession(source), null);
        this.sendingSms = new State("sending sms", (Action)new SendingSms(source), null);
        this.waitingForSmsResponses = new State("waiting for sms responses", (Action)new WaitingForSmsResponses(source), null);
        this.finished = new State("finished", (Action)new Finished(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringLastSmsRequest));
        transitions.add(new Transition(this.acquiringLastSmsRequest, this.downloadingRcml));
        transitions.add(new Transition(this.acquiringLastSmsRequest, this.finished));
        transitions.add(new Transition(this.downloadingRcml, this.ready));
        transitions.add(new Transition(this.downloadingRcml, this.downloadingFallbackRcml));
        transitions.add(new Transition(this.downloadingRcml, this.finished));
        transitions.add(new Transition(this.downloadingFallbackRcml, this.ready));
        transitions.add(new Transition(this.downloadingFallbackRcml, this.finished));
        transitions.add(new Transition(this.ready, this.redirecting));
        transitions.add(new Transition(this.ready, this.creatingSmsSession));
        transitions.add(new Transition(this.ready, this.waitingForSmsResponses));
        transitions.add(new Transition(this.ready, this.finished));
        transitions.add(new Transition(this.redirecting, this.ready));
        transitions.add(new Transition(this.redirecting, this.creatingSmsSession));
        transitions.add(new Transition(this.redirecting, this.finished));
        transitions.add(new Transition(this.redirecting, this.waitingForSmsResponses));
        transitions.add(new Transition(this.creatingSmsSession, this.sendingSms));
        transitions.add(new Transition(this.creatingSmsSession, this.waitingForSmsResponses));
        transitions.add(new Transition(this.creatingSmsSession, this.finished));
        transitions.add(new Transition(this.sendingSms, this.ready));
        transitions.add(new Transition(this.sendingSms, this.redirecting));
        transitions.add(new Transition(this.sendingSms, this.creatingSmsSession));
        transitions.add(new Transition(this.sendingSms, this.waitingForSmsResponses));
        transitions.add(new Transition(this.sendingSms, this.finished));
        transitions.add(new Transition(this.waitingForSmsResponses, this.waitingForSmsResponses));
        transitions.add(new Transition(this.waitingForSmsResponses, this.finished));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.service = service;
        this.downloader = this.downloader();
        this.storage = storage;
        this.runtime = configuration.subset("runtime-settings");
        this.configuration = configuration.subset("sms-aggregator");
        this.accountId = accountId;
        this.version = version;
        this.url = url;
        this.method = method;
        this.fallbackUrl = fallbackUrl;
        this.fallbackMethod = fallbackMethod;
        this.sessions = new HashMap<Sid, ActorRef>();
        this.normalizeNumber = this.runtime.getBoolean("normalize-numbers-for-outbound-calls");
    }

    private ActorRef downloader() {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Downloader();
            }
        }));
    }

    protected String format(String number) {
        if (this.normalizeNumber) {
            PhoneNumberUtil numbersUtil = PhoneNumberUtil.getInstance();
            try {
                Phonenumber.PhoneNumber result = numbersUtil.parse(number, "US");
                return numbersUtil.format(result, PhoneNumberUtil.PhoneNumberFormat.E164);
            }
            catch (NumberParseException ignored) {
                return null;
            }
        }
        return number;
    }

    protected void invalidVerb(Tag verb) {
        ActorRef self = this.self();
        Notification notification = this.notification(1, 14110, "Invalid Verb for SMS Reply");
        NotificationsDao notifications = this.storage.getNotificationsDao();
        notifications.addNotification(notification);
        GetNextVerb next = GetNextVerb.instance();
        this.parser.tell((Object)next, self);
    }

    protected Notification notification(int log, int error, String message) {
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(this.accountId);
        builder.setApiVersion(this.version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.runtime.getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        if (this.request != null) {
            builder.setRequestUrl(this.request.getUri());
            builder.setRequestMethod(this.request.getMethod());
            builder.setRequestVariables(this.request.getParametersAsString());
        }
        if (this.response != null) {
            builder.setResponseHeaders(this.response.getHeadersAsString());
            String type = this.response.getContentType();
            if (type != null && (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html"))) {
                try {
                    builder.setResponseBody(this.response.getContentAsString());
                }
                catch (IOException exception) {
                    this.logger.error("There was an error while reading the contents of the resource located @ " + this.url.toString(), (Object)exception);
                }
            }
        }
        buffer = new StringBuilder();
        buffer.append("/").append(this.version).append("/Accounts/");
        buffer.append(this.accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        if (StartInterpreter.class.equals(klass)) {
            this.fsm.transition(message, this.acquiringLastSmsRequest);
        } else if (SmsSessionRequest.class.equals(klass)) {
            this.customRequestHeaderMap = ((SmsSessionRequest)message).headers();
            this.fsm.transition(message, this.downloadingRcml);
        } else if (DownloaderResponse.class.equals(klass)) {
            DownloaderResponse response = (DownloaderResponse)message;
            if (response.succeeded()) {
                HttpResponseDescriptor descriptor = (HttpResponseDescriptor)response.get();
                if (200 == descriptor.getStatusCode()) {
                    this.fsm.transition(message, this.ready);
                } else if (this.downloadingRcml.equals((Object)state)) {
                    if (this.fallbackUrl != null) {
                        this.fsm.transition(message, this.downloadingFallbackRcml);
                    }
                } else if (this.sessions.size() > 0) {
                    this.fsm.transition(message, this.waitingForSmsResponses);
                } else {
                    this.fsm.transition(message, this.finished);
                }
            } else if (this.downloadingRcml.equals((Object)state)) {
                if (this.fallbackUrl != null) {
                    this.fsm.transition(message, this.downloadingFallbackRcml);
                }
            } else if (this.sessions.size() > 0) {
                this.fsm.transition(message, this.waitingForSmsResponses);
            } else {
                this.fsm.transition(message, this.finished);
            }
        } else if (Tag.class.equals(klass)) {
            Tag verb = (Tag)message;
            if ("Redirect".equals(verb.name())) {
                this.fsm.transition(message, this.redirecting);
            } else if ("Sms".equals(verb.name())) {
                this.fsm.transition(message, this.creatingSmsSession);
            } else {
                this.invalidVerb(verb);
            }
        } else if (SmsServiceResponse.class.equals(klass)) {
            SmsServiceResponse response = (SmsServiceResponse)message;
            if (response.succeeded()) {
                if (this.creatingSmsSession.equals((Object)state)) {
                    this.fsm.transition(message, this.sendingSms);
                }
            } else if (this.sessions.size() > 0) {
                this.fsm.transition(message, this.waitingForSmsResponses);
            } else {
                this.fsm.transition(message, this.finished);
            }
        } else if (SmsSessionResponse.class.equals(klass)) {
            this.response(message);
        } else if (StopInterpreter.class.equals(klass)) {
            if (this.sessions.size() > 0) {
                this.fsm.transition(message, this.waitingForSmsResponses);
            } else {
                this.fsm.transition(message, this.finished);
            }
        }
    }

    protected List<NameValuePair> parameters() {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        String smsSessionSid = this.initialSessionSid.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("SmsSid", smsSessionSid));
        String accountSid = this.accountId.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("AccountSid", accountSid));
        String from = this.format(this.initialSessionRequest.from());
        parameters.add((NameValuePair)new BasicNameValuePair("From", from));
        String to = this.format(this.initialSessionRequest.to());
        parameters.add((NameValuePair)new BasicNameValuePair("To", to));
        String body = this.initialSessionRequest.body();
        parameters.add((NameValuePair)new BasicNameValuePair("Body", body));
        if (this.customRequestHeaderMap != null && !this.customRequestHeaderMap.isEmpty()) {
            for (String headerName : this.customRequestHeaderMap.keySet()) {
                parameters.add((NameValuePair)new BasicNameValuePair("SipHeader_" + headerName, this.customRequestHeaderMap.remove(headerName)));
            }
        }
        return parameters;
    }

    private ActorRef parser(final String xml) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Parser(xml);
            }
        }));
    }

    private void response(Object message) {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        if (SmsSessionResponse.class.equals(klass)) {
            SmsSessionResponse response = (SmsSessionResponse)message;
            SmsSessionInfo info = response.info();
            SmsMessage record = (SmsMessage)info.attributes().get("record");
            if (response.succeeded()) {
                DateTime now = DateTime.now();
                record = record.setDateSent(now);
                record = record.setStatus(SmsMessage.Status.SENT);
            } else {
                record = record.setStatus(SmsMessage.Status.FAILED);
            }
            SmsMessagesDao messages = this.storage.getSmsMessagesDao();
            messages.updateSmsMessage(record);
            Object attribute = info.attributes().get("callback");
            if (attribute != null) {
                URI callback = (URI)attribute;
                List<NameValuePair> parameters = this.parameters();
                this.request = new HttpRequestDescriptor(callback, "POST", parameters);
                this.downloader.tell((Object)this.request, null);
            }
            ActorRef session = this.sessions.remove(record.getSid());
            DestroySmsSession destroy = new DestroySmsSession(session);
            this.service.tell((Object)destroy, self);
            State state = this.fsm.state();
            if (this.waitingForSmsResponses.equals((Object)state)) {
                StopInterpreter stop = new StopInterpreter();
                self.tell((Object)stop, self);
            }
        }
    }

    protected URI resolve(URI base, URI uri) {
        if (base.equals(uri)) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return base.resolve(uri);
        }
        return uri;
    }

    private final class Finished
    extends AbstractAction {
        public Finished(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UntypedActorContext context = SmsInterpreter.this.getContext();
            context.stop(this.source);
        }
    }

    private final class WaitingForSmsResponses
    extends AbstractAction {
        public WaitingForSmsResponses(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            SmsInterpreter.this.response(message);
        }
    }

    private final class SendingSms
    extends AbstractAction {
        public SendingSms(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String action;
            URI uri;
            URI base;
            URI target;
            String callback;
            String body;
            SmsServiceResponse response = (SmsServiceResponse)message;
            ActorRef session = (ActorRef)response.get();
            NotificationsDao notifications = SmsInterpreter.this.storage.getNotificationsDao();
            String from = SmsInterpreter.this.initialSessionRequest.to();
            Attribute attribute = SmsInterpreter.this.verb.attribute("from");
            if (attribute != null) {
                from = attribute.value();
                if (from != null && !from.isEmpty()) {
                    if ((from = SmsInterpreter.this.format(from)) == null) {
                        from = SmsInterpreter.this.verb.attribute("from").value();
                        Notification notification = SmsInterpreter.this.notification(0, 14102, from + " is an invalid 'from' phone number.");
                        notifications.addNotification(notification);
                        SmsInterpreter.this.service.tell((Object)new DestroySmsSession(session), this.source);
                        StopInterpreter stop = new StopInterpreter();
                        this.source.tell((Object)stop, this.source);
                        return;
                    }
                } else {
                    from = SmsInterpreter.this.initialSessionRequest.to();
                }
            }
            String to = SmsInterpreter.this.initialSessionRequest.from();
            attribute = SmsInterpreter.this.verb.attribute("to");
            if (attribute != null && (to = attribute.value()) == null) {
                to = SmsInterpreter.this.initialSessionRequest.from();
            }
            if ((body = SmsInterpreter.this.verb.text()) == null || body.isEmpty()) {
                Notification notification = SmsInterpreter.this.notification(0, 14103, body + " is an invalid SMS body.");
                notifications.addNotification(notification);
                SmsInterpreter.this.service.tell((Object)new DestroySmsSession(session), this.source);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            session.tell((Object)new Observe(this.source), this.source);
            attribute = SmsInterpreter.this.verb.attribute("statusCallback");
            if (attribute != null && (callback = attribute.value()) != null && !callback.isEmpty()) {
                target = null;
                try {
                    target = URI.create(callback);
                }
                catch (Exception exception) {
                    Notification notification = SmsInterpreter.this.notification(0, 14105, callback + " is an invalid URI.");
                    notifications.addNotification(notification);
                    SmsInterpreter.this.service.tell((Object)new DestroySmsSession(session), this.source);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                base = SmsInterpreter.this.request.getUri();
                uri = SmsInterpreter.this.resolve(base, target);
                session.tell((Object)new SmsSessionAttribute("callback", (Object)uri), this.source);
            }
            Sid sid = Sid.generate((Sid.Type)Sid.Type.SMS_MESSAGE);
            SmsMessage.Builder builder = SmsMessage.builder();
            builder.setSid(sid);
            builder.setAccountSid(SmsInterpreter.this.accountId);
            builder.setApiVersion(SmsInterpreter.this.version);
            builder.setRecipient(to);
            builder.setSender(from);
            builder.setBody(body);
            builder.setDirection(SmsMessage.Direction.OUTBOUND_REPLY);
            builder.setStatus(SmsMessage.Status.RECEIVED);
            builder.setPrice(new BigDecimal("0.00"));
            builder.setPriceUnit(Currency.getInstance("USD"));
            StringBuilder buffer = new StringBuilder();
            buffer.append("/").append(SmsInterpreter.this.version).append("/Accounts/");
            buffer.append(SmsInterpreter.this.accountId.toString()).append("/SMS/Messages/");
            buffer.append(sid.toString());
            uri = URI.create(buffer.toString());
            builder.setUri(uri);
            SmsMessage record = builder.build();
            SmsMessagesDao messages = SmsInterpreter.this.storage.getSmsMessagesDao();
            messages.addSmsMessage(record);
            session.tell((Object)new SmsSessionAttribute("record", (Object)record), this.source);
            SmsSessionRequest sms = new SmsSessionRequest(from, to, body, SmsInterpreter.this.customHttpHeaderMap);
            session.tell((Object)sms, this.source);
            SmsInterpreter.this.sessions.put(sid, session);
            attribute = SmsInterpreter.this.verb.attribute("action");
            if (attribute != null && (action = attribute.value()) != null && !action.isEmpty()) {
                target = null;
                try {
                    target = URI.create(action);
                }
                catch (Exception exception) {
                    Notification notification = SmsInterpreter.this.notification(0, 11100, action + " is an invalid URI.");
                    notifications.addNotification(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                base = SmsInterpreter.this.request.getUri();
                uri = SmsInterpreter.this.resolve(base, target);
                String method = "POST";
                attribute = SmsInterpreter.this.verb.attribute("method");
                if (attribute != null) {
                    method = attribute.value();
                    if (method != null && !method.isEmpty()) {
                        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                            Notification notification = SmsInterpreter.this.notification(1, 14104, method + " is not a valid HTTP method for <Sms>");
                            notifications.addNotification(notification);
                            method = "POST";
                        }
                    } else {
                        method = "POST";
                    }
                }
                List<NameValuePair> parameters = SmsInterpreter.this.parameters();
                String status = SmsMessage.Status.SENDING.toString();
                parameters.add((NameValuePair)new BasicNameValuePair("SmsStatus", status));
                SmsInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                SmsInterpreter.this.downloader.tell((Object)SmsInterpreter.this.request, this.source);
                return;
            }
            GetNextVerb next = GetNextVerb.instance();
            SmsInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    private final class CreatingSmsSession
    extends AbstractAction {
        public CreatingSmsSession(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            SmsInterpreter.this.verb = (Tag)message;
            SmsInterpreter.this.service.tell((Object)new CreateSmsSession(), this.source);
        }
    }

    private final class Redirecting
    extends AbstractAction {
        public Redirecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String text;
            SmsInterpreter.this.verb = (Tag)message;
            NotificationsDao notifications = SmsInterpreter.this.storage.getNotificationsDao();
            String method = "POST";
            Attribute attribute = SmsInterpreter.this.verb.attribute("method");
            if (attribute != null) {
                method = attribute.value();
                if (method != null && !method.isEmpty()) {
                    if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                        Notification notification = SmsInterpreter.this.notification(1, 13710, method + " is not a valid HTTP method for <Redirect>");
                        notifications.addNotification(notification);
                        method = "POST";
                    }
                } else {
                    method = "POST";
                }
            }
            if ((text = SmsInterpreter.this.verb.text()) != null && !text.isEmpty()) {
                URI target = null;
                try {
                    target = URI.create(text);
                }
                catch (Exception exception) {
                    Notification notification = SmsInterpreter.this.notification(0, 11100, text + " is an invalid URI.");
                    notifications.addNotification(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                URI base = SmsInterpreter.this.request.getUri();
                URI uri = SmsInterpreter.this.resolve(base, target);
                List<NameValuePair> parameters = SmsInterpreter.this.parameters();
                SmsInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                SmsInterpreter.this.downloader.tell((Object)SmsInterpreter.this.request, this.source);
            } else {
                GetNextVerb next = GetNextVerb.instance();
                SmsInterpreter.this.parser.tell((Object)next, this.source);
            }
        }
    }

    private final class Ready
    extends AbstractAction {
        public Ready(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Header[] headers;
            UntypedActorContext context = SmsInterpreter.this.getContext();
            State state = SmsInterpreter.this.fsm.state();
            if (SmsInterpreter.this.downloadingRcml.equals((Object)state) || SmsInterpreter.this.downloadingFallbackRcml.equals((Object)state) || SmsInterpreter.this.redirecting.equals((Object)state) || SmsInterpreter.this.sendingSms.equals((Object)state)) {
                SmsInterpreter.this.response = (HttpResponseDescriptor)((DownloaderResponse)message).get();
                if (SmsInterpreter.this.parser != null) {
                    context.stop(SmsInterpreter.this.parser);
                    SmsInterpreter.this.parser = null;
                }
                try {
                    String type = SmsInterpreter.this.response.getContentType();
                    String content = SmsInterpreter.this.response.getContentAsString();
                    if (type == null || content == null || !type.contains("text/xml") && !type.contains("application/xml") && !type.contains("text/html")) {
                        SmsInterpreter.this.logger.info("DownloaderResponse getContentType is null: " + SmsInterpreter.this.response);
                        NotificationsDao notifications = SmsInterpreter.this.storage.getNotificationsDao();
                        Notification notification = SmsInterpreter.this.notification(1, 12300, "Invalide content-type.");
                        notifications.addNotification(notification);
                        StopInterpreter stop = new StopInterpreter();
                        this.source.tell((Object)stop, this.source);
                        return;
                    }
                    SmsInterpreter.this.parser = SmsInterpreter.this.parser(content);
                }
                catch (Exception e) {
                    NotificationsDao notifications = SmsInterpreter.this.storage.getNotificationsDao();
                    Notification notification = SmsInterpreter.this.notification(1, 12300, "Invalide content-type.");
                    notifications.addNotification(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
            }
            for (Header header : headers = SmsInterpreter.this.response.getHeaders()) {
                if (!header.getName().startsWith("X-")) continue;
                SmsInterpreter.this.customHttpHeaderMap.put(header.getName(), header.getValue());
            }
            GetNextVerb next = GetNextVerb.instance();
            SmsInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    private final class DownloadingFallbackRcml
    extends AbstractAction {
        public DownloadingFallbackRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (DownloaderResponse.class.equals(klass)) {
                DownloaderResponse result = (DownloaderResponse)message;
                Throwable cause = result.cause();
                Notification notification = null;
                if (cause instanceof ClientProtocolException) {
                    notification = SmsInterpreter.this.notification(0, 11206, cause.getMessage());
                } else if (cause instanceof IOException) {
                    notification = SmsInterpreter.this.notification(0, 11205, cause.getMessage());
                } else if (cause instanceof URISyntaxException) {
                    notification = SmsInterpreter.this.notification(0, 11100, cause.getMessage());
                }
                if (notification != null) {
                    NotificationsDao notifications = SmsInterpreter.this.storage.getNotificationsDao();
                    notifications.addNotification(notification);
                }
            }
            List<NameValuePair> parameters = SmsInterpreter.this.parameters();
            SmsInterpreter.this.request = new HttpRequestDescriptor(SmsInterpreter.this.fallbackUrl, SmsInterpreter.this.fallbackMethod, parameters);
            SmsInterpreter.this.downloader.tell((Object)SmsInterpreter.this.request, this.source);
        }
    }

    private final class DownloadingRcml
    extends AbstractAction {
        public DownloadingRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            SmsInterpreter.this.initialSessionRequest = (SmsSessionRequest)message;
            SmsInterpreter.this.initialSessionSid = Sid.generate((Sid.Type)Sid.Type.SMS_MESSAGE);
            SmsMessage.Builder builder = SmsMessage.builder();
            builder.setSid(SmsInterpreter.this.initialSessionSid);
            builder.setAccountSid(SmsInterpreter.this.accountId);
            builder.setApiVersion(SmsInterpreter.this.version);
            builder.setRecipient(SmsInterpreter.this.initialSessionRequest.to());
            builder.setSender(SmsInterpreter.this.initialSessionRequest.from());
            builder.setBody(SmsInterpreter.this.initialSessionRequest.body());
            builder.setDirection(SmsMessage.Direction.INBOUND);
            builder.setStatus(SmsMessage.Status.RECEIVED);
            builder.setPrice(new BigDecimal("0.00"));
            builder.setPriceUnit(Currency.getInstance("USD"));
            StringBuilder buffer = new StringBuilder();
            buffer.append("/").append(SmsInterpreter.this.version).append("/Accounts/");
            buffer.append(SmsInterpreter.this.accountId.toString()).append("/SMS/Messages/");
            buffer.append(SmsInterpreter.this.initialSessionSid.toString());
            URI uri = URI.create(buffer.toString());
            builder.setUri(uri);
            SmsMessage record = builder.build();
            SmsMessagesDao messages = SmsInterpreter.this.storage.getSmsMessagesDao();
            messages.addSmsMessage(record);
            SmsInterpreter.this.service.tell((Object)new DestroySmsSession(SmsInterpreter.this.initialSession), this.source);
            SmsInterpreter.this.initialSession = null;
            List<NameValuePair> parameters = SmsInterpreter.this.parameters();
            SmsInterpreter.this.request = new HttpRequestDescriptor(SmsInterpreter.this.url, SmsInterpreter.this.method, parameters);
            SmsInterpreter.this.downloader.tell((Object)SmsInterpreter.this.request, this.source);
        }
    }

    private final class AcquiringLastSmsEvent
    extends AbstractAction {
        public AcquiringLastSmsEvent(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            StartInterpreter request = (StartInterpreter)message;
            SmsInterpreter.this.initialSession = request.resource();
            SmsInterpreter.this.initialSession.tell((Object)new Observe(this.source), this.source);
            SmsInterpreter.this.initialSession.tell((Object)new GetLastSmsRequest(), this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

