/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.jsr309;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import javax.media.mscontrol.MsControlFactory;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerControllerFactory;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerInfo;
import org.mobicents.servlet.restcomm.mscontrol.jsr309.Jsr309BridgeController;
import org.mobicents.servlet.restcomm.mscontrol.jsr309.Jsr309CallController;
import org.mobicents.servlet.restcomm.mscontrol.jsr309.Jsr309ConferenceController;

public class Jsr309ControllerFactory
implements MediaServerControllerFactory {
    private final ActorSystem system;
    private final MsControlFactory msControlFactory;
    private final CallControllerFactory callControllerFactory;
    private final ConferenceControllerFactory conferenceControllerFactory;
    private final BridgeControllerFactory bridgeControllerFactory;
    private final MediaServerInfo mediaServerInfo;

    public Jsr309ControllerFactory(ActorSystem system, MediaServerInfo mediaServerInfo, MsControlFactory msControlFactory) {
        this.system = system;
        this.msControlFactory = msControlFactory;
        this.callControllerFactory = new CallControllerFactory();
        this.conferenceControllerFactory = new ConferenceControllerFactory();
        this.bridgeControllerFactory = new BridgeControllerFactory();
        this.mediaServerInfo = mediaServerInfo;
    }

    public ActorRef provideCallController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.callControllerFactory));
    }

    public ActorRef provideConferenceController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.conferenceControllerFactory));
    }

    public ActorRef provideBridgeController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.bridgeControllerFactory));
    }

    private final class BridgeControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = -4095666710038438897L;

        private BridgeControllerFactory() {
        }

        public Actor create() throws Exception {
            if (Jsr309ControllerFactory.this.msControlFactory == null) {
                throw new IllegalStateException("No media server control factory has been set.");
            }
            return new Jsr309BridgeController(Jsr309ControllerFactory.this.msControlFactory, Jsr309ControllerFactory.this.mediaServerInfo);
        }
    }

    private final class ConferenceControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = -4095666710038438897L;

        private ConferenceControllerFactory() {
        }

        public Actor create() throws Exception {
            if (Jsr309ControllerFactory.this.msControlFactory == null) {
                throw new IllegalStateException("No media server control factory has been set.");
            }
            return new Jsr309ConferenceController(Jsr309ControllerFactory.this.msControlFactory, Jsr309ControllerFactory.this.mediaServerInfo);
        }
    }

    private final class CallControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = 8689899689896436910L;

        private CallControllerFactory() {
        }

        public Actor create() throws Exception {
            if (Jsr309ControllerFactory.this.msControlFactory == null) {
                throw new IllegalStateException("No media server control factory has been set.");
            }
            return new Jsr309CallController(Jsr309ControllerFactory.this.msControlFactory, Jsr309ControllerFactory.this.mediaServerInfo);
        }
    }
}

