/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.jsr309;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.media.mscontrol.resource.RTC;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.fsm.TransitionFailedException;
import org.mobicents.servlet.restcomm.fsm.TransitionNotFoundException;
import org.mobicents.servlet.restcomm.fsm.TransitionRollbackException;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerController;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerInfo;
import org.mobicents.servlet.restcomm.mscontrol.exceptions.MediaServerControllerException;
import org.mobicents.servlet.restcomm.mscontrol.messages.CreateMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinCall;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinConference;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupResponse;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerError;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.Play;
import org.mobicents.servlet.restcomm.mscontrol.messages.Stop;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopMediaGroup;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;

public class Jsr309ConferenceController
extends MediaServerController {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State initializing;
    private final State active;
    private final State inactive;
    private final State failed;
    private ActorRef conference;
    private final MsControlFactory msControlFactory;
    private final MediaServerInfo mediaServerInfo;
    private MediaSession mediaSession;
    private MediaGroup mediaGroup;
    private MediaMixer mediaMixer;
    private final PlayerListener playerListener;
    private final MixerAllocationListener mixerAllocationListener;
    private Boolean playing;
    private final List<ActorRef> observers;

    public Jsr309ConferenceController(MsControlFactory msControlFactory, MediaServerInfo mediaServerInfo) {
        ActorRef source = this.self();
        this.msControlFactory = msControlFactory;
        this.mediaServerInfo = mediaServerInfo;
        this.playerListener = new PlayerListener();
        this.mixerAllocationListener = new MixerAllocationListener();
        this.playing = Boolean.FALSE;
        this.uninitialized = new State("uninitialized", null);
        this.initializing = new State("initializing", (Action)new Initializing(source));
        this.active = new State("active", (Action)new Active(source));
        this.inactive = new State("inactive", (Action)new Inactive(source));
        this.failed = new State("failed", (Action)new Failed(source));
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.initializing));
        transitions.add(new Transition(this.initializing, this.failed));
        transitions.add(new Transition(this.initializing, this.active));
        transitions.add(new Transition(this.initializing, this.inactive));
        transitions.add(new Transition(this.active, this.inactive));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.observers = new ArrayList<ActorRef>();
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            List<ActorRef> list = this.observers;
            synchronized (list) {
                for (ActorRef observer : this.observers) {
                    observer.tell(message, self);
                }
            }
        }
    }

    private void stopMediaOperations() throws MsControlException {
        if (this.playing.booleanValue()) {
            this.mediaGroup.getPlayer().stop(true);
            this.playing = Boolean.FALSE;
        }
    }

    private void cleanMediaResources() {
        this.mediaSession.release();
        this.mediaSession = null;
        this.mediaGroup = null;
        this.mediaMixer = null;
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        this.logger.info("********** Conference Controller Current State: \"" + state.toString());
        this.logger.info("********** Conference Controller Processing Message: \"" + klass.getName() + " sender : " + sender.getClass());
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (CreateMediaSession.class.equals(klass)) {
            this.onCreateMediaSession((CreateMediaSession)message, self, sender);
        } else if (Stop.class.equals(klass)) {
            this.onStop((Stop)message, self, sender);
        } else if (StopMediaGroup.class.equals(klass)) {
            this.onStopMediaGroup((StopMediaGroup)message, self, sender);
        } else if (JoinCall.class.equals(klass)) {
            this.onJoinCall((JoinCall)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) throws Exception {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) throws Exception {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        } else {
            this.observers.clear();
        }
    }

    private void onCreateMediaSession(CreateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.conference = sender;
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onStop(Stop message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.initializing) || this.is(this.active)) {
            this.fsm.transition((Object)message, this.inactive);
        }
    }

    private void onStopMediaGroup(StopMediaGroup message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            try {
                if (this.playing.booleanValue()) {
                    this.mediaGroup.getPlayer().stop(true);
                    this.playing = Boolean.FALSE;
                }
            }
            catch (MsControlException e) {
                this.conference.tell((Object)new MediaServerControllerError((Throwable)e), self);
            }
        }
    }

    private void onJoinCall(JoinCall message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            JoinConference join = new JoinConference((Object)this.mediaMixer, message.getConnectionMode());
            message.getCall().tell((Object)join, sender);
        }
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            try {
                List uris = message.uris();
                Parameters params = this.mediaGroup.createParameters();
                int repeatCount = message.iterations() <= 0 ? -1 : message.iterations() - 1;
                params.put((Object)Player.REPEAT_COUNT, (Object)repeatCount);
                this.playerListener.setRemote(sender);
                this.mediaGroup.getPlayer().play(uris.toArray(new URI[uris.size()]), RTC.NO_RTC, params);
                this.playing = Boolean.TRUE;
            }
            catch (MsControlException e) {
                this.logger.error("Play failed: " + e.getMessage());
                this.playing = Boolean.FALSE;
                MediaGroupResponse response = new MediaGroupResponse((Throwable)e);
                this.broadcast(response);
            }
        }
    }

    private final class Failed
    extends MediaServerController.AbstractAction {
        public Failed(ActorRef source) {
            super((MediaServerController)Jsr309ConferenceController.this, source);
        }

        public void execute(Object message) throws Exception {
            Jsr309ConferenceController.this.cleanMediaResources();
            Jsr309ConferenceController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.FAILED));
            Jsr309ConferenceController.this.observers.clear();
            Jsr309ConferenceController.this.getContext().stop(this.source);
        }
    }

    private final class Inactive
    extends MediaServerController.AbstractAction {
        public Inactive(ActorRef source) {
            super((MediaServerController)Jsr309ConferenceController.this, source);
        }

        public void execute(Object message) throws Exception {
            try {
                Jsr309ConferenceController.this.stopMediaOperations();
            }
            catch (MsControlException e) {
                Jsr309ConferenceController.this.logger.error((Throwable)e, "Could not stop ongoing media operations in an elegant manner");
            }
            Jsr309ConferenceController.this.cleanMediaResources();
            Jsr309ConferenceController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.INACTIVE));
            Jsr309ConferenceController.this.observers.clear();
            Jsr309ConferenceController.this.getContext().stop(this.source);
        }
    }

    private final class Active
    extends MediaServerController.AbstractAction {
        public Active(ActorRef source) {
            super((MediaServerController)Jsr309ConferenceController.this, source);
        }

        public void execute(Object message) throws Exception {
            Jsr309ConferenceController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.ACTIVE));
        }
    }

    private final class Initializing
    extends MediaServerController.AbstractAction {
        public Initializing(ActorRef source) {
            super((MediaServerController)Jsr309ConferenceController.this, source);
        }

        public void execute(Object message) throws Exception {
            try {
                Jsr309ConferenceController.this.mediaSession = Jsr309ConferenceController.this.msControlFactory.createMediaSession();
                Jsr309ConferenceController.this.mediaGroup = Jsr309ConferenceController.this.mediaSession.createMediaGroup(MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR);
                Parameters mixerParams = Jsr309ConferenceController.this.mediaSession.createParameters();
                mixerParams.put((Object)MediaMixer.MAX_PORTS, (Object)10);
                Jsr309ConferenceController.this.mediaMixer = Jsr309ConferenceController.this.mediaSession.createMediaMixer(MediaMixer.AUDIO_VIDEO, mixerParams);
                Jsr309ConferenceController.this.mediaMixer.addListener((AllocationEventListener)Jsr309ConferenceController.this.mixerAllocationListener);
                Jsr309ConferenceController.this.mediaMixer.confirm();
            }
            catch (MsControlException e) {
                Jsr309ConferenceController.this.fsm.transition((Object)e, Jsr309ConferenceController.this.failed);
            }
        }
    }

    private class MixerAllocationListener
    implements AllocationEventListener,
    Serializable {
        private static final long serialVersionUID = 6579306945384115627L;

        private MixerAllocationListener() {
        }

        public void onEvent(AllocationEvent event) {
            block6: {
                EventType eventType = event.getEventType();
                Jsr309ConferenceController.this.logger.info("********** Conference Controller Current State: \"" + Jsr309ConferenceController.this.fsm.state().toString() + "\"");
                Jsr309ConferenceController.this.logger.info("********** Conference Controller Processing Event: \"AllocationEventListener - Mixer\" (type = " + eventType + ")");
                try {
                    if (AllocationEvent.ALLOCATION_CONFIRMED.equals(eventType)) {
                        Jsr309ConferenceController.this.mediaMixer.removeListener((AllocationEventListener)this);
                        try {
                            Jsr309ConferenceController.this.mediaGroup.join(Joinable.Direction.DUPLEX, (Joinable)Jsr309ConferenceController.this.mediaMixer);
                        }
                        catch (MsControlException e) {
                            Jsr309ConferenceController.this.fsm.transition((Object)e, Jsr309ConferenceController.this.failed);
                        }
                        Jsr309ConferenceController.this.fsm.transition((Object)event, Jsr309ConferenceController.this.active);
                        break block6;
                    }
                    if (AllocationEvent.IRRECOVERABLE_FAILURE.equals(eventType)) {
                        Jsr309ConferenceController.this.fsm.transition((Object)event, Jsr309ConferenceController.this.failed);
                    }
                }
                catch (TransitionFailedException | TransitionNotFoundException | TransitionRollbackException e) {
                    Jsr309ConferenceController.this.logger.error(e.getMessage(), (Object)e);
                }
            }
        }
    }

    private final class PlayerListener
    extends MediaListener<PlayerEvent> {
        private static final long serialVersionUID = 391225908543565230L;

        private PlayerListener() {
        }

        public void onEvent(PlayerEvent event) {
            EventType eventType = event.getEventType();
            Jsr309ConferenceController.this.logger.info("********** Conference Controller Current State: \"" + Jsr309ConferenceController.this.fsm.state().toString() + "\"");
            Jsr309ConferenceController.this.logger.info("********** Conference Controller Processing Event: \"PlayerEvent\" (type = " + eventType + ")");
            if (PlayerEvent.PLAY_COMPLETED.equals(eventType)) {
                MediaGroupResponse response;
                if (event.isSuccessful()) {
                    response = new MediaGroupResponse((Object)eventType.toString());
                } else {
                    String reason = event.getErrorText();
                    MediaServerControllerException error = new MediaServerControllerException(reason);
                    response = new MediaGroupResponse((Throwable)error, reason);
                }
                Jsr309ConferenceController.this.playing = Boolean.FALSE;
                this.remote.tell((Object)response, Jsr309ConferenceController.this.self());
            }
        }
    }

    private abstract class MediaListener<T extends MediaEvent<?>>
    implements MediaEventListener<T>,
    Serializable {
        private static final long serialVersionUID = 4712964810787577487L;
        protected ActorRef remote;

        private MediaListener() {
        }

        public void setRemote(ActorRef sender) {
            this.remote = sender;
        }
    }
}

