/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.jsr309;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.mediagroup.SpeechDetectorConstants;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.resource.RTC;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.RecordingsDao;
import org.mobicents.servlet.restcomm.entities.Recording;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerController;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerInfo;
import org.mobicents.servlet.restcomm.mscontrol.exceptions.MediaServerControllerException;
import org.mobicents.servlet.restcomm.mscontrol.messages.CloseMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.Collect;
import org.mobicents.servlet.restcomm.mscontrol.messages.CreateMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinBridge;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinComplete;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinConference;
import org.mobicents.servlet.restcomm.mscontrol.messages.Leave;
import org.mobicents.servlet.restcomm.mscontrol.messages.Left;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupResponse;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerError;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaSessionInfo;
import org.mobicents.servlet.restcomm.mscontrol.messages.Mute;
import org.mobicents.servlet.restcomm.mscontrol.messages.Play;
import org.mobicents.servlet.restcomm.mscontrol.messages.Record;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.Stop;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.Unmute;
import org.mobicents.servlet.restcomm.mscontrol.messages.UpdateMediaSession;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import org.mobicents.servlet.restcomm.util.WavUtils;

public class Jsr309CallController
extends MediaServerController {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State initializing;
    private final State active;
    private final State pending;
    private final State updatingMediaSession;
    private final State inactive;
    private final State failed;
    private final MsControlFactory msControlFactory;
    private final MediaServerInfo mediaServerInfo;
    private MediaSession mediaSession;
    private NetworkConnection networkConnection;
    private MediaGroup mediaGroup;
    private MediaMixer mediaMixer;
    private final SdpListener sdpListener;
    private final PlayerListener playerListener;
    private final DtmfListener dtmfListener;
    private final RecorderListener recorderListener;
    private ActorRef call;
    private Sid callId;
    private String localSdp;
    private String remoteSdp;
    private String connectionMode;
    private boolean callOutbound;
    private ActorRef bridge;
    private Sid accountId;
    private Sid recordingSid;
    private URI recordingUri;
    private Boolean recording;
    private Boolean playing;
    private Boolean collecting;
    private DateTime recordStarted;
    private DaoManager daoManager;
    private Configuration runtimeSettings;
    private final List<ActorRef> observers;

    public Jsr309CallController(MsControlFactory msControlFactory, MediaServerInfo mediaServerInfo) {
        ActorRef source = this.self();
        this.msControlFactory = msControlFactory;
        this.mediaServerInfo = mediaServerInfo;
        this.sdpListener = new SdpListener();
        this.playerListener = new PlayerListener();
        this.dtmfListener = new DtmfListener();
        this.recorderListener = new RecorderListener();
        this.uninitialized = new State("uninitialized", null, null);
        this.initializing = new State("initializing", (Action)new Initializing(source), null);
        this.active = new State("active", (Action)new Active(source), null);
        this.pending = new State("pending", (Action)new Pending(source), null);
        this.updatingMediaSession = new State("updating media session", (Action)new UpdatingMediaSession(source), null);
        this.inactive = new State("inactive", (Action)new Inactive(source), null);
        this.failed = new State("failed", (Action)new Failed(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.initializing));
        transitions.add(new Transition(this.uninitialized, this.failed));
        transitions.add(new Transition(this.initializing, this.failed));
        transitions.add(new Transition(this.initializing, this.active));
        transitions.add(new Transition(this.initializing, this.pending));
        transitions.add(new Transition(this.initializing, this.inactive));
        transitions.add(new Transition(this.pending, this.updatingMediaSession));
        transitions.add(new Transition(this.pending, this.inactive));
        transitions.add(new Transition(this.pending, this.failed));
        transitions.add(new Transition(this.active, this.updatingMediaSession));
        transitions.add(new Transition(this.active, this.inactive));
        transitions.add(new Transition(this.active, this.failed));
        transitions.add(new Transition(this.updatingMediaSession, this.active));
        transitions.add(new Transition(this.updatingMediaSession, this.inactive));
        transitions.add(new Transition(this.updatingMediaSession, this.failed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.observers = new ArrayList<ActorRef>(2);
        this.localSdp = "";
        this.remoteSdp = "";
        this.callOutbound = false;
        this.connectionMode = "inactive";
        this.recording = Boolean.FALSE;
        this.playing = Boolean.FALSE;
        this.collecting = Boolean.FALSE;
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private void notifyObservers(Object message, ActorRef self) {
        for (ActorRef observer : this.observers) {
            observer.tell(message, self);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        this.logger.info("********** Call Controller Current State: \"" + state.toString());
        this.logger.info("********** Call Controller Processing Message: \"" + klass.getName() + " sender : " + sender.getClass());
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (CreateMediaSession.class.equals(klass)) {
            this.onCreateMediaSession((CreateMediaSession)message, self, sender);
        } else if (CloseMediaSession.class.equals(klass)) {
            this.onCloseMediaSession((CloseMediaSession)message, self, sender);
        } else if (UpdateMediaSession.class.equals(klass)) {
            this.onUpdateMediaSession((UpdateMediaSession)message, self, sender);
        } else if (StopMediaGroup.class.equals(klass)) {
            this.onStopMediaGroup((StopMediaGroup)message, self, sender);
        } else if (Mute.class.equals(klass)) {
            this.onMute((Mute)message, self, sender);
        } else if (Unmute.class.equals(klass)) {
            this.onUnmute((Unmute)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecordingCall((StartRecording)message, self, sender);
        } else if (StopRecording.class.equals(klass)) {
            this.onStopRecordingCall((StopRecording)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        } else if (Collect.class.equals(klass)) {
            this.onCollect((Collect)message, self, sender);
        } else if (Record.class.equals(klass)) {
            this.onRecord((Record)message, self, sender);
        } else if (JoinBridge.class.equals(klass)) {
            this.onJoinBridge((JoinBridge)message, self, sender);
        } else if (JoinConference.class.equals(klass)) {
            this.onJoinConference((JoinConference)message, self, sender);
        } else if (Stop.class.equals(klass)) {
            this.onStop((Stop)message, self, sender);
        } else if (Leave.class.equals(klass)) {
            this.onLeave((Leave)message, self, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) throws Exception {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) throws Exception {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        } else {
            this.observers.clear();
        }
    }

    private void onCreateMediaSession(CreateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.call = sender;
            this.callOutbound = message.isOutbound();
            this.connectionMode = message.getConnectionMode();
            this.remoteSdp = message.getSessionDescription();
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onCloseMediaSession(CloseMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) || this.is(this.initializing) || this.is(this.updatingMediaSession)) {
            this.fsm.transition((Object)message, this.inactive);
        }
    }

    private void onUpdateMediaSession(UpdateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.pending) || this.is(this.active)) {
            this.remoteSdp = message.getSessionDescription();
            this.fsm.transition((Object)message, this.updatingMediaSession);
        }
    }

    private void onStopMediaGroup(StopMediaGroup message, ActorRef self, ActorRef sender) throws Exception {
        try {
            if (this.mediaGroup != null) {
                if (this.playing.booleanValue()) {
                    this.mediaGroup.getPlayer().stop(true);
                    this.playing = Boolean.FALSE;
                }
                if (this.recording.booleanValue()) {
                    this.mediaGroup.getRecorder().stop();
                    this.recording = Boolean.FALSE;
                }
                if (this.collecting.booleanValue()) {
                    this.mediaGroup.getSignalDetector().stop();
                    this.collecting = Boolean.FALSE;
                }
            }
        }
        catch (MsControlException e) {
            this.fsm.transition((Object)e, this.failed);
        }
    }

    private void onMute(Mute message, ActorRef self, ActorRef sender) {
        if (this.is(this.active) && this.mediaMixer != null) {
            try {
                this.networkConnection.join(Joinable.Direction.RECV, (Joinable)this.mediaMixer);
            }
            catch (MsControlException e) {
                this.logger.error("Could not mute call: " + e.getMessage(), (Object)e);
            }
        }
    }

    private void onUnmute(Unmute message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) && this.mediaMixer != null) {
            try {
                this.networkConnection.join(Joinable.Direction.DUPLEX, (Joinable)this.mediaMixer);
            }
            catch (MsControlException e) {
                this.logger.error("Could not unmute call: " + e.getMessage(), (Object)e);
            }
        }
    }

    private void onStartRecordingCall(StartRecording message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            if (this.runtimeSettings == null) {
                this.runtimeSettings = message.getRuntimeSetting();
            }
            if (this.daoManager == null) {
                this.daoManager = message.getDaoManager();
            }
            if (this.accountId == null) {
                this.accountId = message.getAccountId();
            }
            this.callId = message.getCallId();
            this.recordingSid = message.getRecordingSid();
            this.recordingUri = message.getRecordingUri();
            this.recording = true;
            this.logger.info("Start recording call");
            this.recordStarted = DateTime.now();
            Record record = new Record(this.recordingUri, 5, 3600, "1234567890*#");
            this.onRecord(record, self, sender);
        }
    }

    private void onStopRecordingCall(StopRecording message, ActorRef self, ActorRef sender) {
        if (this.is(this.active) && this.recording.booleanValue()) {
            if (this.runtimeSettings == null) {
                this.runtimeSettings = message.getRuntimeSetting();
            }
            if (this.daoManager == null) {
                this.daoManager = message.getDaoManager();
            }
            if (this.accountId == null) {
                this.accountId = message.getAccountId();
            }
            this.logger.info("Stop recording call");
            this.onStop(new Stop(false), self, sender);
        }
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            try {
                List uris = message.uris();
                Parameters params = this.mediaGroup.createParameters();
                int repeatCount = message.iterations() <= 0 ? -1 : message.iterations() - 1;
                params.put((Object)Player.REPEAT_COUNT, (Object)repeatCount);
                this.playerListener.setRemote(sender);
                this.mediaGroup.getPlayer().play(uris.toArray(new URI[uris.size()]), RTC.NO_RTC, params);
                this.playing = Boolean.TRUE;
            }
            catch (MsControlException e) {
                this.logger.error("Play failed: " + e.getMessage());
                MediaGroupResponse response = new MediaGroupResponse((Throwable)e);
                this.notifyObservers(response, self);
            }
        }
    }

    private void onCollect(Collect message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            try {
                Parameters optargs = this.mediaGroup.createParameters();
                ArrayList<Parameter> patterns = new ArrayList<Parameter>(2);
                if (message.hasEndInputKey()) {
                    optargs.put((Object)SignalDetector.PATTERN[0], (Object)message.endInputKey());
                    patterns.add(SignalDetector.PATTERN[0]);
                }
                if (message.hasPattern()) {
                    optargs.put((Object)SignalDetector.PATTERN[1], (Object)message.pattern());
                    patterns.add(SignalDetector.PATTERN[1]);
                }
                Parameter[] patternArray = null;
                if (!patterns.isEmpty()) {
                    patternArray = patterns.toArray(new Parameter[patterns.size()]);
                }
                EventType[] enabledEvents = new EventType[]{SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED};
                optargs.put((Object)SignalDetector.ENABLED_EVENTS, (Object)enabledEvents);
                if (message.hasPrompts()) {
                    List prompts = message.prompts();
                    optargs.put((Object)SignalDetector.PROMPT, (Object)prompts.toArray(new URI[prompts.size()]));
                }
                int timeout = message.timeout();
                optargs.put((Object)SignalDetector.INITIAL_TIMEOUT, (Object)timeout);
                optargs.put((Object)SignalDetector.INTER_SIG_TIMEOUT, (Object)timeout);
                optargs.put((Object)SignalDetector.BUFFERING, (Object)false);
                this.dtmfListener.setRemote(sender);
                this.mediaGroup.getSignalDetector().flushBuffer();
                this.mediaGroup.getSignalDetector().receiveSignals(message.numberOfDigits(), patternArray, RTC.NO_RTC, optargs);
                this.collecting = Boolean.TRUE;
            }
            catch (MsControlException e) {
                this.logger.error("DTMF recognition failed: " + e.getMessage());
                MediaGroupResponse response = new MediaGroupResponse((Throwable)e);
                this.notifyObservers(response, self);
            }
        }
    }

    private void onRecord(Record message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            try {
                RTC[] rtcs;
                Parameters params = this.mediaGroup.createParameters();
                if (message.hasPrompts()) {
                    List prompts = message.prompts();
                    params.put((Object)Recorder.PROMPT, prompts.get(0));
                }
                if (message.hasEndInputKey()) {
                    params.put((Object)SignalDetector.PATTERN[0], (Object)message.endInputKey());
                    params.put((Object)SignalDetector.INTER_SIG_TIMEOUT, (Object)new Integer(10000));
                    rtcs = new RTC[]{MediaGroup.SIGDET_STOPPLAY};
                } else {
                    rtcs = RTC.NO_RTC;
                }
                params.put((Object)Recorder.MAX_DURATION, (Object)(message.length() * 1000));
                int timeout = message.timeout();
                params.put((Object)SpeechDetectorConstants.INITIAL_TIMEOUT, (Object)timeout);
                params.put((Object)SpeechDetectorConstants.FINAL_TIMEOUT, (Object)timeout);
                params.put((Object)Recorder.APPEND, (Object)Boolean.FALSE);
                params.put((Object)Recorder.START_BEEP, (Object)Boolean.FALSE);
                this.recorderListener.setEndOnKey(message.endInputKey());
                this.recorderListener.setRemote(sender);
                this.mediaGroup.getRecorder().record(message.destination(), rtcs, params);
                this.recording = Boolean.TRUE;
            }
            catch (MsControlException e) {
                this.logger.error("Recording failed: " + e.getMessage());
                MediaGroupResponse response = new MediaGroupResponse((Throwable)e);
                this.notifyObservers(response, self);
            }
        }
    }

    private void onJoinBridge(JoinBridge message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active)) {
            try {
                this.bridge = sender;
                this.mediaMixer = (MediaMixer)message.getEndpoint();
                this.networkConnection.join(Joinable.Direction.DUPLEX, (Joinable)this.mediaMixer);
                this.call.tell((Object)new JoinComplete(), self);
            }
            catch (MsControlException e) {
                this.logger.error("Call bridging failed: " + e.getMessage());
                this.fsm.transition((Object)e, this.failed);
            }
        }
    }

    private void onJoinConference(JoinConference message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active)) {
            try {
                this.bridge = sender;
                this.mediaMixer = (MediaMixer)message.getEndpoint();
                this.networkConnection.join(Joinable.Direction.DUPLEX, (Joinable)this.mediaMixer);
                this.call.tell((Object)new JoinComplete(), self);
            }
            catch (MsControlException e) {
                this.logger.error("Call bridging failed: " + e.getMessage());
                this.fsm.transition((Object)e, this.failed);
            }
        }
    }

    private void onStop(Stop message, ActorRef self, ActorRef sender) {
        try {
            if (this.playing.booleanValue()) {
                this.mediaGroup.getPlayer().stop(true);
                this.playing = Boolean.FALSE;
            }
            if (this.recording.booleanValue()) {
                this.mediaGroup.getRecorder().stop();
                this.recording = Boolean.FALSE;
                if (message.createRecord() && this.recordingUri != null) {
                    Double duration;
                    try {
                        duration = WavUtils.getAudioDuration((URI)this.recordingUri);
                    }
                    catch (IOException | UnsupportedAudioFileException e) {
                        this.logger.error("Could not measure recording duration: " + e.getMessage(), (Object)e);
                        duration = 0.0;
                    }
                    if (duration.equals(0.0)) {
                        this.logger.info("Call wraping up recording. File doesn't exist since duration is 0");
                        DateTime end = DateTime.now();
                        duration = new Double((end.getMillis() - this.recordStarted.getMillis()) / 1000L);
                    } else {
                        this.logger.info("Call wraping up recording. File already exists, length: " + new File(this.recordingUri).length());
                    }
                    Recording.Builder builder = Recording.builder();
                    builder.setSid(this.recordingSid);
                    builder.setAccountSid(this.accountId);
                    builder.setCallSid(this.callId);
                    builder.setDuration(duration.doubleValue());
                    builder.setApiVersion(this.runtimeSettings.getString("api-version"));
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("/").append(this.runtimeSettings.getString("api-version")).append("/Accounts/").append(this.accountId.toString());
                    buffer.append("/Recordings/").append(this.recordingSid.toString());
                    builder.setUri(URI.create(buffer.toString()));
                    Recording recording = builder.build();
                    RecordingsDao recordsDao = this.daoManager.getRecordingsDao();
                    recordsDao.addRecording(recording);
                }
            }
            if (this.collecting.booleanValue()) {
                this.mediaGroup.getSignalDetector().stop();
                this.collecting = Boolean.FALSE;
            }
        }
        catch (MsControlException e) {
            this.call.tell((Object)new MediaServerControllerError((Throwable)e), self);
        }
    }

    private void onLeave(Leave message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) && this.mediaMixer != null) {
            try {
                this.networkConnection.unjoin((Joinable)this.mediaMixer);
                this.mediaMixer = null;
                this.bridge = null;
                this.networkConnection.join(Joinable.Direction.DUPLEX, (Joinable)this.mediaGroup);
                this.call.tell((Object)new Left(), self);
            }
            catch (MsControlException e) {
                this.logger.error((Throwable)e, "Call could not leave Bridge. Failing...");
                this.fsm.transition((Object)e, this.failed);
            }
        }
    }

    private final class Failed
    extends FinalState {
        public Failed(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.FAILED);
        }
    }

    private final class Inactive
    extends FinalState {
        public Inactive(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.INACTIVE);
        }
    }

    private abstract class FinalState
    extends MediaServerController.AbstractAction {
        protected final MediaServerControllerStateChanged.MediaServerControllerState state;

        public FinalState(ActorRef source, MediaServerControllerStateChanged.MediaServerControllerState state) {
            super((MediaServerController)Jsr309CallController.this, source);
            this.state = state;
        }

        public void execute(Object message) throws Exception {
            this.cleanMediaResources();
            Jsr309CallController.this.notifyObservers(new MediaServerControllerStateChanged(this.state), this.source);
        }

        private void cleanMediaResources() {
            Jsr309CallController.this.mediaSession.release();
            Jsr309CallController.this.mediaSession = null;
            Jsr309CallController.this.mediaGroup = null;
            Jsr309CallController.this.mediaMixer = null;
        }
    }

    private final class Active
    extends MediaServerController.AbstractAction {
        public Active(ActorRef source) {
            super((MediaServerController)Jsr309CallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MediaSessionInfo info = new MediaSessionInfo(true, Jsr309CallController.this.mediaServerInfo.getAddress(), Jsr309CallController.this.localSdp, Jsr309CallController.this.remoteSdp);
            Jsr309CallController.this.call.tell((Object)new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.ACTIVE, info), this.source);
        }
    }

    private final class Pending
    extends MediaServerController.AbstractAction {
        public Pending(ActorRef source) {
            super((MediaServerController)Jsr309CallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MediaSessionInfo info = new MediaSessionInfo(true, Jsr309CallController.this.mediaServerInfo.getAddress(), Jsr309CallController.this.localSdp, Jsr309CallController.this.remoteSdp);
            Jsr309CallController.this.call.tell((Object)new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.PENDING, info), this.source);
        }
    }

    private final class UpdatingMediaSession
    extends MediaServerController.AbstractAction {
        public UpdatingMediaSession(ActorRef source) {
            super((MediaServerController)Jsr309CallController.this, source);
        }

        public void execute(Object message) throws Exception {
            try {
                Jsr309CallController.this.networkConnection.getSdpPortManager().addListener((MediaEventListener)Jsr309CallController.this.sdpListener);
                Jsr309CallController.this.networkConnection.getSdpPortManager().processSdpAnswer(Jsr309CallController.this.remoteSdp.getBytes());
            }
            catch (MsControlException e) {
                Jsr309CallController.this.fsm.transition((Object)e, Jsr309CallController.this.failed);
            }
        }
    }

    private final class Initializing
    extends MediaServerController.AbstractAction {
        public Initializing(ActorRef source) {
            super((MediaServerController)Jsr309CallController.this, source);
        }

        public void execute(Object message) throws Exception {
            try {
                Jsr309CallController.this.mediaSession = Jsr309CallController.this.msControlFactory.createMediaSession();
                Jsr309CallController.this.mediaGroup = Jsr309CallController.this.mediaSession.createMediaGroup(MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR);
                Jsr309CallController.this.mediaGroup.getPlayer().addListener((MediaEventListener)Jsr309CallController.this.playerListener);
                Jsr309CallController.this.mediaGroup.getSignalDetector().addListener((MediaEventListener)Jsr309CallController.this.dtmfListener);
                Jsr309CallController.this.mediaGroup.getRecorder().addListener((MediaEventListener)Jsr309CallController.this.recorderListener);
                Jsr309CallController.this.networkConnection = Jsr309CallController.this.mediaSession.createNetworkConnection(NetworkConnection.BASIC);
                Jsr309CallController.this.networkConnection.getSdpPortManager().addListener((MediaEventListener)Jsr309CallController.this.sdpListener);
                if (Jsr309CallController.this.callOutbound) {
                    Jsr309CallController.this.networkConnection.getSdpPortManager().generateSdpOffer();
                } else {
                    Jsr309CallController.this.networkConnection.getSdpPortManager().processSdpOffer(Jsr309CallController.this.remoteSdp.getBytes());
                }
            }
            catch (MsControlException e) {
                Jsr309CallController.this.fsm.transition((Object)e, Jsr309CallController.this.failed);
            }
        }
    }

    private final class RecorderListener
    extends MediaListener<RecorderEvent> {
        private static final long serialVersionUID = -8952464412809110917L;
        private String endOnKey;

        private RecorderListener() {
            this.endOnKey = "";
        }

        public void setEndOnKey(String endOnKey) {
            this.endOnKey = endOnKey;
        }

        public void onEvent(RecorderEvent event) {
            EventType eventType = event.getEventType();
            Jsr309CallController.this.logger.info("********** Call Controller Current State: \"" + Jsr309CallController.this.fsm.state().toString() + "\"");
            Jsr309CallController.this.logger.info("********** Call Controller Processing Event: \"RecorderEvent\" (type = " + eventType + ")");
            if (RecorderEvent.RECORD_COMPLETED.equals(eventType)) {
                MediaGroupResponse response = null;
                if (event.isSuccessful()) {
                    String digits = "";
                    if (RecorderEvent.STOPPED.equals(event.getQualifier())) {
                        digits = this.endOnKey;
                    }
                    response = new MediaGroupResponse((Object)digits);
                } else {
                    String reason = event.getErrorText();
                    MediaServerControllerException error = new MediaServerControllerException(reason);
                    Jsr309CallController.this.logger.error("Recording event failed: " + reason);
                    response = new MediaGroupResponse((Throwable)error, reason);
                }
                Jsr309CallController.this.recording = Boolean.FALSE;
                this.originator.tell((Object)response, Jsr309CallController.this.self());
            }
        }
    }

    private final class DtmfListener
    extends MediaListener<SignalDetectorEvent> {
        private static final long serialVersionUID = -96652040901361098L;

        private DtmfListener() {
        }

        public void onEvent(SignalDetectorEvent event) {
            EventType eventType = event.getEventType();
            Jsr309CallController.this.logger.info("********** Call Controller Current State: \"" + Jsr309CallController.this.fsm.state().toString() + "\"");
            Jsr309CallController.this.logger.info("********** Call Controller Processing Event: \"SignalDetectorEvent\" (type = " + eventType + ")");
            if (SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED.equals(eventType)) {
                MediaGroupResponse response;
                if (event.isSuccessful()) {
                    response = new MediaGroupResponse((Object)event.getSignalString());
                } else {
                    String reason = event.getErrorText();
                    MediaServerControllerException error = new MediaServerControllerException(reason);
                    response = new MediaGroupResponse((Throwable)error, reason);
                }
                Jsr309CallController.this.collecting = Boolean.FALSE;
                this.originator.tell((Object)response, Jsr309CallController.this.self());
            }
        }
    }

    private final class PlayerListener
    extends MediaListener<PlayerEvent> {
        private static final long serialVersionUID = -1814168664061905439L;

        private PlayerListener() {
        }

        public void onEvent(PlayerEvent event) {
            EventType eventType = event.getEventType();
            Jsr309CallController.this.logger.info("********** Call Controller Current State: \"" + Jsr309CallController.this.fsm.state().toString() + "\"");
            Jsr309CallController.this.logger.info("********** Call Controller Processing Event: \"PlayerEvent\" (type = " + eventType + ")");
            if (PlayerEvent.PLAY_COMPLETED.equals(eventType)) {
                MediaGroupResponse response;
                if (event.isSuccessful()) {
                    response = new MediaGroupResponse((Object)eventType.toString());
                } else {
                    String reason = event.getErrorText();
                    MediaServerControllerException error = new MediaServerControllerException(reason);
                    response = new MediaGroupResponse((Throwable)error, reason);
                }
                Jsr309CallController.this.playing = Boolean.FALSE;
                this.originator.tell((Object)response, Jsr309CallController.this.self());
            }
        }
    }

    private final class SdpListener
    extends MediaListener<SdpPortManagerEvent> {
        private static final long serialVersionUID = 1578203803932778931L;

        private SdpListener() {
        }

        public void onEvent(SdpPortManagerEvent event) {
            EventType eventType = event.getEventType();
            Jsr309CallController.this.logger.info("********** Call Controller Current State: \"" + Jsr309CallController.this.fsm.state().toString() + "\"");
            Jsr309CallController.this.logger.info("********** Call Controller Processing Event: \"SdpPortManagerEvent\" (type = " + eventType + ")");
            try {
                if (event.isSuccessful()) {
                    if (Jsr309CallController.this.is(Jsr309CallController.this.initializing) || Jsr309CallController.this.is(Jsr309CallController.this.updatingMediaSession)) {
                        Jsr309CallController.this.networkConnection.getSdpPortManager().removeListener((MediaEventListener)this);
                        if (SdpPortManagerEvent.ANSWER_GENERATED.equals(eventType)) {
                            if (Jsr309CallController.this.is(Jsr309CallController.this.initializing)) {
                                Jsr309CallController.this.localSdp = new String(event.getMediaServerSdp());
                                Jsr309CallController.this.networkConnection.join(Joinable.Direction.DUPLEX, (Joinable)Jsr309CallController.this.mediaGroup);
                                Jsr309CallController.this.fsm.transition((Object)event, Jsr309CallController.this.active);
                            }
                        } else if (SdpPortManagerEvent.OFFER_GENERATED.equals(eventType)) {
                            if (Jsr309CallController.this.is(Jsr309CallController.this.initializing)) {
                                Jsr309CallController.this.localSdp = new String(event.getMediaServerSdp());
                                Jsr309CallController.this.fsm.transition((Object)event, Jsr309CallController.this.pending);
                            }
                        } else if (SdpPortManagerEvent.ANSWER_PROCESSED.equals(eventType)) {
                            if (Jsr309CallController.this.is(Jsr309CallController.this.updatingMediaSession)) {
                                if (Jsr309CallController.this.mediaGroup.getJoinees().length == 0) {
                                    Jsr309CallController.this.networkConnection.join(Joinable.Direction.DUPLEX, (Joinable)Jsr309CallController.this.mediaGroup);
                                }
                                Jsr309CallController.this.fsm.transition((Object)event, Jsr309CallController.this.active);
                            }
                        } else if (SdpPortManagerEvent.NETWORK_STREAM_FAILURE.equals(eventType)) {
                            Jsr309CallController.this.fsm.transition((Object)event, Jsr309CallController.this.failed);
                        }
                    }
                } else {
                    Jsr309CallController.this.fsm.transition((Object)event, Jsr309CallController.this.failed);
                }
            }
            catch (Exception e) {
                Jsr309CallController.this.logger.error((Throwable)e, "Could not set up the network connection");
            }
        }
    }

    private abstract class MediaListener<T extends MediaEvent<?>>
    implements MediaEventListener<T>,
    Serializable {
        private static final long serialVersionUID = 7103112381914312776L;
        protected ActorRef originator;

        private MediaListener() {
        }

        public void setRemote(ActorRef sender) {
            this.originator = sender;
        }
    }
}

