/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mscontrol.jsr309;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.mediagroup.SpeechDetectorConstants;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.media.mscontrol.resource.RTC;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.RecordingsDao;
import org.mobicents.servlet.restcomm.entities.Recording;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.fsm.TransitionFailedException;
import org.mobicents.servlet.restcomm.fsm.TransitionNotFoundException;
import org.mobicents.servlet.restcomm.fsm.TransitionRollbackException;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerController;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerInfo;
import org.mobicents.servlet.restcomm.mscontrol.exceptions.MediaServerControllerException;
import org.mobicents.servlet.restcomm.mscontrol.messages.CreateMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinBridge;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinCall;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupResponse;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerError;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.Stop;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import org.mobicents.servlet.restcomm.util.WavUtils;

public class Jsr309BridgeController
extends MediaServerController {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State initializing;
    private final State active;
    private final State inactive;
    private final State failed;
    private ActorRef bridge;
    private final MsControlFactory msControlFactory;
    private final MediaServerInfo mediaServerInfo;
    private MediaSession mediaSession;
    private MediaGroup mediaGroup;
    private MediaMixer mediaMixer;
    private final RecorderListener recorderListener;
    private final MixerAllocationListener mixerAllocationListener;
    private Boolean recording;
    private DateTime recordingStarted;
    private StartRecording recordingRequest;
    private final List<ActorRef> observers;

    public Jsr309BridgeController(MsControlFactory msControlFactory, MediaServerInfo mediaServerInfo) {
        ActorRef source = this.self();
        this.msControlFactory = msControlFactory;
        this.mediaServerInfo = mediaServerInfo;
        this.recorderListener = new RecorderListener();
        this.mixerAllocationListener = new MixerAllocationListener();
        this.recording = Boolean.FALSE;
        this.uninitialized = new State("uninitialized", null);
        this.initializing = new State("initializing", (Action)new Initializing(source));
        this.active = new State("active", (Action)new Active(source));
        this.inactive = new State("inactive", (Action)new Inactive(source));
        this.failed = new State("failed", (Action)new Failed(source));
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.initializing));
        transitions.add(new Transition(this.initializing, this.failed));
        transitions.add(new Transition(this.initializing, this.active));
        transitions.add(new Transition(this.initializing, this.inactive));
        transitions.add(new Transition(this.active, this.inactive));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.observers = new ArrayList<ActorRef>(1);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            List<ActorRef> list = this.observers;
            synchronized (list) {
                for (ActorRef observer : this.observers) {
                    observer.tell(message, self);
                }
            }
        }
    }

    private void stopMediaOperations() throws MsControlException {
        if (this.recording.booleanValue()) {
            this.mediaGroup.getRecorder().stop();
        }
    }

    private void cleanMediaResources() {
        this.mediaSession.release();
        this.mediaSession = null;
        this.mediaGroup = null;
        this.mediaMixer = null;
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        this.logger.info("********** Bridge Controller " + this.self().path() + " State: \"" + state.toString());
        this.logger.info("********** Bridge Controller " + this.self().path() + " Processing: \"" + klass.getName() + " Sender: " + sender.getClass());
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (CreateMediaSession.class.equals(klass)) {
            this.onCreateMediaSession((CreateMediaSession)message, self, sender);
        } else if (JoinCall.class.equals(klass)) {
            this.onJoinCall((JoinCall)message, self, sender);
        } else if (Stop.class.equals(klass)) {
            this.onStop((Stop)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecording((StartRecording)message, self, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onCreateMediaSession(CreateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.bridge = sender;
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onJoinCall(JoinCall message, ActorRef self, ActorRef sender) {
        JoinBridge join = new JoinBridge((Object)this.mediaMixer, message.getConnectionMode());
        message.getCall().tell((Object)join, sender);
    }

    private void onStop(Stop message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.initializing) || this.is(this.active)) {
            this.fsm.transition((Object)message, this.inactive);
        }
    }

    private void onStartRecording(StartRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active)) {
            try {
                this.logger.info("Start recording bridged call");
                Parameters params = this.mediaGroup.createParameters();
                String endOnKey = "1234567890*#";
                params.put((Object)SignalDetector.PATTERN[0], (Object)endOnKey);
                params.put((Object)SignalDetector.INTER_SIG_TIMEOUT, (Object)new Integer(10000));
                RTC[] rtcs = new RTC[]{MediaGroup.SIGDET_STOPPLAY};
                params.put((Object)Recorder.MAX_DURATION, (Object)3600000);
                int timeout = 5;
                params.put((Object)SpeechDetectorConstants.INITIAL_TIMEOUT, (Object)timeout);
                params.put((Object)SpeechDetectorConstants.FINAL_TIMEOUT, (Object)timeout);
                params.put((Object)Recorder.APPEND, (Object)Boolean.FALSE);
                params.put((Object)Recorder.START_BEEP, (Object)Boolean.FALSE);
                this.recorderListener.setEndOnKey(endOnKey);
                this.recorderListener.setRemote(sender);
                this.mediaGroup.getRecorder().record(message.getRecordingUri(), rtcs, params);
                this.recording = Boolean.TRUE;
                this.recordingStarted = DateTime.now();
                this.recordingRequest = message;
            }
            catch (MsControlException e) {
                this.logger.error("Recording failed: " + e.getMessage());
                MediaServerControllerError error = new MediaServerControllerError((Throwable)e);
                this.bridge.tell((Object)error, self);
            }
        }
    }

    private final class Failed
    extends MediaServerController.AbstractAction {
        public Failed(ActorRef source) {
            super((MediaServerController)Jsr309BridgeController.this, source);
        }

        public void execute(Object message) throws Exception {
            Jsr309BridgeController.this.cleanMediaResources();
            Jsr309BridgeController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.FAILED));
            Jsr309BridgeController.this.observers.clear();
            Jsr309BridgeController.this.getContext().stop(this.source);
        }
    }

    private final class Inactive
    extends MediaServerController.AbstractAction {
        public Inactive(ActorRef source) {
            super((MediaServerController)Jsr309BridgeController.this, source);
        }

        public void execute(Object message) throws Exception {
            try {
                Jsr309BridgeController.this.stopMediaOperations();
            }
            catch (MsControlException e) {
                Jsr309BridgeController.this.logger.error((Throwable)e, "Could not stop ongoing media operations in an elegant manner");
            }
            Jsr309BridgeController.this.cleanMediaResources();
            Jsr309BridgeController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.INACTIVE));
            Jsr309BridgeController.this.observers.clear();
            Jsr309BridgeController.this.getContext().stop(this.source);
        }
    }

    private final class Active
    extends MediaServerController.AbstractAction {
        public Active(ActorRef source) {
            super((MediaServerController)Jsr309BridgeController.this, source);
        }

        public void execute(Object message) throws Exception {
            Jsr309BridgeController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.ACTIVE));
        }
    }

    private final class Initializing
    extends MediaServerController.AbstractAction {
        public Initializing(ActorRef source) {
            super((MediaServerController)Jsr309BridgeController.this, source);
        }

        public void execute(Object message) throws Exception {
            try {
                Jsr309BridgeController.this.mediaSession = Jsr309BridgeController.this.msControlFactory.createMediaSession();
                Jsr309BridgeController.this.mediaGroup = Jsr309BridgeController.this.mediaSession.createMediaGroup(MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR);
                Jsr309BridgeController.this.mediaGroup.getRecorder().addListener((MediaEventListener)Jsr309BridgeController.this.recorderListener);
                Parameters mixerParams = Jsr309BridgeController.this.mediaSession.createParameters();
                mixerParams.put((Object)MediaMixer.MAX_PORTS, (Object)3);
                Jsr309BridgeController.this.mediaMixer = Jsr309BridgeController.this.mediaSession.createMediaMixer(MediaMixer.AUDIO, mixerParams);
                Jsr309BridgeController.this.mediaMixer.addListener((AllocationEventListener)Jsr309BridgeController.this.mixerAllocationListener);
                Jsr309BridgeController.this.mediaMixer.confirm();
            }
            catch (MsControlException e) {
                Jsr309BridgeController.this.fsm.transition((Object)e, Jsr309BridgeController.this.failed);
            }
        }
    }

    private class MixerAllocationListener
    implements AllocationEventListener,
    Serializable {
        private static final long serialVersionUID = -8450656267936666492L;

        private MixerAllocationListener() {
        }

        public void onEvent(AllocationEvent event) {
            block6: {
                EventType eventType = event.getEventType();
                Jsr309BridgeController.this.logger.info("********** Bridge Controller Current State: \"" + Jsr309BridgeController.this.fsm.state().toString() + "\"");
                Jsr309BridgeController.this.logger.info("********** Bridge Controller Processing Event: \"AllocationEventListener - Mixer\" (type = " + eventType + ")");
                try {
                    if (AllocationEvent.ALLOCATION_CONFIRMED.equals(eventType)) {
                        Jsr309BridgeController.this.mediaMixer.removeListener((AllocationEventListener)this);
                        try {
                            Jsr309BridgeController.this.mediaGroup.join(Joinable.Direction.DUPLEX, (Joinable)Jsr309BridgeController.this.mediaMixer);
                        }
                        catch (MsControlException e) {
                            Jsr309BridgeController.this.fsm.transition((Object)e, Jsr309BridgeController.this.failed);
                        }
                        Jsr309BridgeController.this.fsm.transition((Object)event, Jsr309BridgeController.this.active);
                        break block6;
                    }
                    if (AllocationEvent.IRRECOVERABLE_FAILURE.equals(eventType)) {
                        Jsr309BridgeController.this.fsm.transition((Object)event, Jsr309BridgeController.this.failed);
                    }
                }
                catch (TransitionFailedException | TransitionNotFoundException | TransitionRollbackException e) {
                    Jsr309BridgeController.this.logger.error(e.getMessage(), (Object)e);
                }
            }
        }
    }

    private final class RecorderListener
    extends MediaListener<RecorderEvent> {
        private static final long serialVersionUID = 2145317407008648018L;
        private String endOnKey;

        private RecorderListener() {
            this.endOnKey = "";
        }

        public void setEndOnKey(String endOnKey) {
            this.endOnKey = endOnKey;
        }

        public void onEvent(RecorderEvent event) {
            EventType eventType = event.getEventType();
            Jsr309BridgeController.this.logger.info("********** Bridge Controller Current State: \"" + Jsr309BridgeController.this.fsm.state().toString() + "\"");
            Jsr309BridgeController.this.logger.info("********** Bridge Controller Processing Event: \"RecorderEvent\" (type = " + eventType + ")");
            if (RecorderEvent.RECORD_COMPLETED.equals(eventType)) {
                MediaGroupResponse response = null;
                if (event.isSuccessful()) {
                    String digits = "";
                    if (RecorderEvent.STOPPED.equals(event.getQualifier())) {
                        digits = this.endOnKey;
                    }
                    this.saveRecording();
                    response = new MediaGroupResponse((Object)digits);
                } else {
                    String reason = event.getErrorText();
                    MediaServerControllerException error = new MediaServerControllerException(reason);
                    Jsr309BridgeController.this.logger.error("Recording event failed: " + reason);
                    response = new MediaGroupResponse((Throwable)error, reason);
                }
                Jsr309BridgeController.this.recording = Boolean.FALSE;
                Jsr309BridgeController.this.recordingStarted = null;
                Jsr309BridgeController.this.recordingRequest = null;
                this.remote.tell((Object)response, Jsr309BridgeController.this.self());
            }
        }

        private void saveRecording() {
            Double duration;
            Sid accountId = Jsr309BridgeController.this.recordingRequest.getAccountId();
            Sid callId = Jsr309BridgeController.this.recordingRequest.getCallId();
            DaoManager daoManager = Jsr309BridgeController.this.recordingRequest.getDaoManager();
            Sid recordingSid = Jsr309BridgeController.this.recordingRequest.getRecordingSid();
            URI recordingUri = Jsr309BridgeController.this.recordingRequest.getRecordingUri();
            Configuration runtimeSettings = Jsr309BridgeController.this.recordingRequest.getRuntimeSetting();
            try {
                duration = WavUtils.getAudioDuration((URI)recordingUri);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                Jsr309BridgeController.this.logger.error("Could not measure recording duration: " + e.getMessage(), (Object)e);
                duration = 0.0;
            }
            if (duration.equals(0.0)) {
                Jsr309BridgeController.this.logger.info("Call wraping up recording. File doesn't exist since duration is 0");
                DateTime end = DateTime.now();
                duration = new Double((end.getMillis() - Jsr309BridgeController.this.recordingStarted.getMillis()) / 1000L);
            } else {
                Jsr309BridgeController.this.logger.info("Call wraping up recording. File already exists, length: " + new File(recordingUri).length());
            }
            Recording.Builder builder = Recording.builder();
            builder.setSid(recordingSid);
            builder.setAccountSid(accountId);
            builder.setCallSid(callId);
            builder.setDuration(duration.doubleValue());
            builder.setApiVersion(runtimeSettings.getString("api-version"));
            StringBuilder buffer = new StringBuilder();
            buffer.append("/").append(runtimeSettings.getString("api-version")).append("/Accounts/").append(accountId.toString());
            buffer.append("/Recordings/").append(recordingSid.toString());
            builder.setUri(URI.create(buffer.toString()));
            Recording recording = builder.build();
            RecordingsDao recordsDao = daoManager.getRecordingsDao();
            recordsDao.addRecording(recording);
        }
    }

    private abstract class MediaListener<T extends MediaEvent<?>>
    implements MediaEventListener<T>,
    Serializable {
        private static final long serialVersionUID = 4712964810787577487L;
        protected ActorRef remote;

        private MediaListener() {
        }

        public void setRemote(ActorRef sender) {
            this.remote = sender;
        }
    }
}

