/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.audio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.AudioOutput;
import org.mobicents.media.server.component.oob.OOBOutput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.resource.audio.RecorderEventImpl;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.dtmf.DtmfTonesData;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.Listener;
import org.mobicents.media.server.spi.listener.Listeners;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.recorder.Recorder;
import org.mobicents.media.server.spi.recorder.RecorderListener;

public class AudioRecorderImpl
extends AbstractSink
implements Recorder {
    private static final AudioFormat LINEAR = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private static final Formats formats = new Formats();
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * LINEAR.getSampleRate() / 1000 * LINEAR.getSampleSize() / 8;
    private static final int SILENCE_LEVEL = 10;
    private String recordDir;
    private FileOutputStream fout;
    private File file;
    private File temp;
    private long postSpeechTimer = -1L;
    private long preSpeechTimer = -1L;
    private ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8192);
    private ByteBuffer headerBuffer = ByteBuffer.allocateDirect(44);
    private byte[] data;
    private int offset;
    private int len;
    private KillRecording killRecording;
    private Heartbeat heartbeat;
    private long lastPacketData = 0L;
    private long startTime = 0L;
    private Scheduler scheduler;
    private long maxRecordTime = -1L;
    private Listeners<RecorderListener> listeners = new Listeners();
    private RecorderEventImpl recorderStarted;
    private RecorderEventImpl recorderStopped;
    private RecorderEventImpl recorderFailed;
    private EventSender eventSender;
    private int qualifier;
    private boolean speechDetected = false;
    private AudioOutput output;
    private OOBOutput oobOutput;
    private OOBRecorder oobRecorder;
    private static final Logger logger;

    public AudioRecorderImpl(Scheduler scheduler) {
        super("recorder");
        this.scheduler = scheduler;
        this.killRecording = new KillRecording();
        this.recorderStarted = new RecorderEventImpl(1, this);
        this.recorderStopped = new RecorderEventImpl(2, this);
        this.recorderFailed = new RecorderEventImpl(3, this);
        this.eventSender = new EventSender();
        this.heartbeat = new Heartbeat();
        this.output = new AudioOutput(scheduler, ComponentType.RECORDER.getType());
        this.output.join((AbstractSink)this);
        this.oobOutput = new OOBOutput(scheduler, ComponentType.RECORDER.getType());
        this.oobRecorder = new OOBRecorder();
        this.oobOutput.join((AbstractSink)this.oobRecorder);
    }

    public AudioOutput getAudioOutput() {
        return this.output;
    }

    public OOBOutput getOOBOutput() {
        return this.oobOutput;
    }

    public void activate() {
        this.lastPacketData = this.scheduler.getClock().getTime();
        this.startTime = this.scheduler.getClock().getTime();
        this.output.start();
        this.oobOutput.start();
        if (this.postSpeechTimer > 0L || this.preSpeechTimer > 0L || this.maxRecordTime > 0L) {
            this.scheduler.submitHeatbeat((Task)this.heartbeat);
        }
        this.fireEvent(this.recorderStarted);
    }

    public void deactivate() {
        if (!this.isStarted()) {
            return;
        }
        this.output.stop();
        this.oobOutput.stop();
        this.maxRecordTime = -1L;
        this.lastPacketData = 0L;
        this.startTime = 0L;
        this.heartbeat.cancel();
        try {
            this.writeToWaveFile();
        }
        catch (IOException e) {
            if (this.getEndpoint() == null) {
                logger.error((Object)e);
            }
            logger.error((Object)("(" + this.getEndpoint().getLocalName() + ")"), (Throwable)e);
        }
        this.recorderStopped.setQualifier(this.qualifier);
        this.fireEvent(this.recorderStopped);
        this.qualifier = 0;
        this.maxRecordTime = -1L;
        this.postSpeechTimer = -1L;
        this.preSpeechTimer = -1L;
        this.speechDetected = false;
    }

    public void setPreSpeechTimer(long value) {
        this.preSpeechTimer = value;
    }

    public void setPostSpeechTimer(long value) {
        this.postSpeechTimer = value;
    }

    public void setMaxRecordTime(long maxRecordTime) {
        this.maxRecordTime = maxRecordTime;
    }

    private void fireEvent(RecorderEventImpl event) {
        this.eventSender.event = event;
        this.scheduler.submit((Task)this.eventSender, Scheduler.INPUT_QUEUE);
    }

    public void onMediaTransfer(Frame frame) throws IOException {
        this.data = frame.getData();
        this.offset = frame.getOffset();
        this.len = frame.getLength();
        this.byteBuffer.clear();
        this.byteBuffer.limit(this.len - this.offset);
        this.byteBuffer.put(this.data, this.offset, this.len - this.offset);
        this.byteBuffer.rewind();
        this.fout.getChannel().write(this.byteBuffer);
        if (this.postSpeechTimer > 0L || this.preSpeechTimer > 0L) {
            if (!this.checkForSilence(this.data, this.offset, this.len)) {
                this.lastPacketData = this.scheduler.getClock().getTime();
                this.speechDetected = true;
            }
        } else {
            this.lastPacketData = this.scheduler.getClock().getTime();
        }
    }

    public void setRecordDir(String recordDir) {
        this.recordDir = recordDir;
    }

    public void setRecordFile(String uri, boolean append) throws IOException {
        String path = uri.startsWith("file:") ? uri.replaceAll("file://", "") : this.recordDir + "/" + uri;
        this.file = new File(path);
        this.temp = new File(path + "~");
        this.fout = new FileOutputStream(this.temp);
        if (append && this.file.exists()) {
            if (this.getEndpoint() == null) {
                logger.info((Object)("..............>>>>>Copying samples from " + this.file));
            } else {
                logger.info((Object)("(" + this.getEndpoint().getLocalName() + ") ..............>>>>>Copying samples from " + this.file));
            }
            this.copySamples(this.file, this.fout);
        }
    }

    private void writeToWaveFile() throws IOException {
        if (this.getEndpoint() == null) {
            logger.info((Object)"!!!!!!!!!! Writting to file......................");
        } else {
            logger.info((Object)("(" + this.getEndpoint().getLocalName() + ") !!!!!!!!!! Writting to file......................"));
        }
        if (this.fout == null) {
            return;
        }
        this.fout.flush();
        this.fout.close();
        FileInputStream fin = new FileInputStream(this.temp);
        this.fout = new FileOutputStream(this.file);
        int size = fin.available();
        if (this.getEndpoint() == null) {
            logger.info((Object)("!!!!!!!!!! Size=" + size));
        } else {
            logger.info((Object)("(" + this.getEndpoint().getLocalName() + ") !!!!!!!!!! Size=" + size));
        }
        this.headerBuffer.clear();
        this.headerBuffer.put((byte)82);
        this.headerBuffer.put((byte)73);
        this.headerBuffer.put((byte)70);
        this.headerBuffer.put((byte)70);
        int length = size + 36;
        this.headerBuffer.put((byte)length);
        this.headerBuffer.put((byte)(length >> 8));
        this.headerBuffer.put((byte)(length >> 16));
        this.headerBuffer.put((byte)(length >> 24));
        this.headerBuffer.put((byte)87);
        this.headerBuffer.put((byte)65);
        this.headerBuffer.put((byte)86);
        this.headerBuffer.put((byte)69);
        this.headerBuffer.put((byte)102);
        this.headerBuffer.put((byte)109);
        this.headerBuffer.put((byte)116);
        this.headerBuffer.put((byte)32);
        this.headerBuffer.put((byte)16);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)1);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)1);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)64);
        this.headerBuffer.put((byte)31);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)-128);
        this.headerBuffer.put((byte)62);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)2);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)16);
        this.headerBuffer.put((byte)0);
        this.headerBuffer.put((byte)100);
        this.headerBuffer.put((byte)97);
        this.headerBuffer.put((byte)116);
        this.headerBuffer.put((byte)97);
        this.headerBuffer.put((byte)size);
        this.headerBuffer.put((byte)(size >> 8));
        this.headerBuffer.put((byte)(size >> 16));
        this.headerBuffer.put((byte)(size >> 24));
        this.headerBuffer.rewind();
        FileChannel outChannel = this.fout.getChannel();
        outChannel.write(this.headerBuffer);
        outChannel.force(true);
        FileChannel inChannel = fin.getChannel();
        outChannel.transferFrom(fin.getChannel(), 44L, inChannel.size());
        if (this.getEndpoint() == null) {
            logger.info((Object)("Was copied " + inChannel.size() + " bytes"));
        } else {
            logger.info((Object)("(" + this.getEndpoint().getLocalName() + ") Was copied " + inChannel.size() + " bytes"));
        }
        this.fout.flush();
        this.fout.close();
        fin.close();
        this.temp.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySamples(File src, FileOutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        try {
            this.copyData(inChannel, 44, outChannel);
        }
        finally {
            in.close();
        }
    }

    private void copyData(FileChannel inChannel, int offset, FileChannel outChannel) throws IOException {
        long count = inChannel.size() - (long)offset;
        inChannel.transferTo(offset, count, outChannel);
        if (this.getEndpoint() == null) {
            logger.info((Object)("Was copied " + count + " bytes"));
        } else {
            logger.info((Object)("(" + this.getEndpoint().getLocalName() + ") Was copied " + count + " bytes"));
        }
    }

    private boolean checkForSilence(byte[] data, int offset, int len) {
        for (int i = offset; i < len - 1; i += 2) {
            int s = data[i] & 0xFF | data[i + 1] << 8;
            if (s <= 10) continue;
            return false;
        }
        return true;
    }

    public void addListener(RecorderListener listener) throws TooManyListenersException {
        this.listeners.add((Listener)listener);
    }

    public void removeListener(RecorderListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void clearAllListeners() {
        this.listeners.clear();
    }

    static {
        formats.add((Format)LINEAR);
        logger = Logger.getLogger(AudioRecorderImpl.class);
    }

    private class OOBRecorder
    extends AbstractSink {
        private byte currTone;
        private long latestSeq;
        private boolean hasEndOfEvent;
        private long endSeq;
        private ByteBuffer toneBuffer;
        byte[] data;

        public OOBRecorder() {
            super("oob recorder");
            this.currTone = (byte)-1;
            this.latestSeq = 0L;
            this.hasEndOfEvent = false;
            this.endSeq = 0L;
            this.toneBuffer = ByteBuffer.allocateDirect(1600);
            this.data = new byte[4];
        }

        public void onMediaTransfer(Frame buffer) throws IOException {
            byte[] data = buffer.getData();
            if (data.length != 4) {
                return;
            }
            boolean endOfEvent = false;
            boolean bl = endOfEvent = (data[1] & 0x80) != 0;
            if (endOfEvent) {
                this.hasEndOfEvent = true;
                this.endSeq = buffer.getSequenceNumber();
                return;
            }
            if (this.currTone == data[0]) {
                if (this.hasEndOfEvent) {
                    if (buffer.getSequenceNumber() <= this.endSeq && buffer.getSequenceNumber() > this.endSeq - 8L) {
                        return;
                    }
                } else if (buffer.getSequenceNumber() < this.latestSeq + 8L && buffer.getSequenceNumber() > this.latestSeq - 8L) {
                    if (buffer.getSequenceNumber() > this.latestSeq) {
                        this.latestSeq = buffer.getSequenceNumber();
                    }
                    return;
                }
            }
            this.hasEndOfEvent = false;
            this.endSeq = 0L;
            this.latestSeq = buffer.getSequenceNumber();
            this.currTone = data[0];
            this.toneBuffer.clear();
            this.toneBuffer.limit(DtmfTonesData.buffer[data[0]].length);
            this.toneBuffer.put(DtmfTonesData.buffer[data[0]]);
            this.toneBuffer.rewind();
            AudioRecorderImpl.this.fout.getChannel().write(this.toneBuffer);
        }

        public void activate() {
        }

        public void deactivate() {
        }
    }

    private class Heartbeat
    extends Task {
        public long perform() {
            long currTime = AudioRecorderImpl.this.scheduler.getClock().getTime();
            if (AudioRecorderImpl.this.preSpeechTimer > 0L && !AudioRecorderImpl.this.speechDetected && currTime - AudioRecorderImpl.this.lastPacketData > AudioRecorderImpl.this.preSpeechTimer) {
                AudioRecorderImpl.this.qualifier = 2;
                Scheduler scheduler = AudioRecorderImpl.this.scheduler;
                KillRecording killRecording = AudioRecorderImpl.this.killRecording;
                AudioRecorderImpl.this.scheduler;
                scheduler.submit((Task)killRecording, Scheduler.INPUT_QUEUE);
                return 0L;
            }
            if (AudioRecorderImpl.this.postSpeechTimer > 0L && AudioRecorderImpl.this.speechDetected && currTime - AudioRecorderImpl.this.lastPacketData > AudioRecorderImpl.this.postSpeechTimer) {
                AudioRecorderImpl.this.qualifier = 2;
                Scheduler scheduler = AudioRecorderImpl.this.scheduler;
                KillRecording killRecording = AudioRecorderImpl.this.killRecording;
                AudioRecorderImpl.this.scheduler;
                scheduler.submit((Task)killRecording, Scheduler.INPUT_QUEUE);
                return 0L;
            }
            if (AudioRecorderImpl.this.maxRecordTime > 0L && currTime - AudioRecorderImpl.this.startTime >= AudioRecorderImpl.this.maxRecordTime) {
                AudioRecorderImpl.this.qualifier = 1;
                Scheduler scheduler = AudioRecorderImpl.this.scheduler;
                KillRecording killRecording = AudioRecorderImpl.this.killRecording;
                AudioRecorderImpl.this.scheduler;
                scheduler.submit((Task)killRecording, Scheduler.INPUT_QUEUE);
                return 0L;
            }
            AudioRecorderImpl.this.scheduler.submitHeatbeat((Task)this);
            return 0L;
        }

        public int getQueueNumber() {
            AudioRecorderImpl.this.scheduler;
            return Scheduler.HEARTBEAT_QUEUE;
        }
    }

    private class EventSender
    extends Task {
        protected RecorderEventImpl event;

        public long perform() {
            AudioRecorderImpl.this.listeners.dispatch((Event)this.event);
            return 0L;
        }

        public int getQueueNumber() {
            AudioRecorderImpl.this.scheduler;
            return Scheduler.INPUT_QUEUE;
        }
    }

    private class KillRecording
    extends Task {
        public long perform() {
            AudioRecorderImpl.this.deactivate();
            return 0L;
        }

        public int getQueueNumber() {
            AudioRecorderImpl.this.scheduler;
            return Scheduler.INPUT_QUEUE;
        }
    }
}

