/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.ice.harvest;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.CandidateType;
import org.mobicents.media.io.ice.FoundationsRegistry;
import org.mobicents.media.io.ice.HostCandidate;
import org.mobicents.media.io.ice.IceComponent;
import org.mobicents.media.io.ice.IceMediaStream;
import org.mobicents.media.io.ice.LocalCandidateWrapper;
import org.mobicents.media.io.ice.harvest.CandidateHarvester;
import org.mobicents.media.io.ice.harvest.HarvestException;
import org.mobicents.media.server.io.network.PortManager;

public class HostCandidateHarvester
implements CandidateHarvester {
    Logger logger = Logger.getLogger(HostCandidateHarvester.class);
    private final FoundationsRegistry foundations;

    public HostCandidateHarvester(FoundationsRegistry foundationsRegistry) {
        this.foundations = foundationsRegistry;
    }

    private Enumeration<NetworkInterface> getNetworkInterfaces() throws HarvestException {
        try {
            return NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new HarvestException("Could not retrieve list of available Network Interfaces.", e);
        }
    }

    private boolean useNetworkInterface(NetworkInterface networkInterface) throws HarvestException {
        try {
            return !networkInterface.isLoopback() && networkInterface.isUp();
        }
        catch (SocketException e) {
            throw new HarvestException("Could not evaluate whether network interface is loopback.", e);
        }
    }

    private List<InetAddress> findAddresses() throws HarvestException {
        ArrayList<InetAddress> found = new ArrayList<InetAddress>(3);
        Enumeration<NetworkInterface> interfaces = this.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            if (!this.useNetworkInterface(iface)) continue;
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                found.add(address);
            }
        }
        return found;
    }

    private DatagramChannel openUdpChannel(InetAddress localAddress, int port, Selector selector) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        channel.register(selector, 5);
        channel.bind(new InetSocketAddress(localAddress, port));
        return channel;
    }

    @Override
    public void harvest(PortManager portManager, IceMediaStream mediaStream, Selector selector) throws HarvestException {
        List<InetAddress> addresses = this.findAddresses();
        for (InetAddress address : addresses) {
            IceComponent rtcpComponent;
            IceComponent rtpComponent = mediaStream.getRtpComponent();
            boolean gathered = this.gatherCandidate(rtpComponent, address, portManager.next(), portManager, selector);
            if (!gathered) {
                this.logCandidateNotFound(address.toString(), portManager.getLowestPort(), portManager.getHighestPort());
            }
            if (!gathered || !mediaStream.supportsRtcp() || mediaStream.isRtcpMux() || (gathered = this.gatherCandidate(rtcpComponent = mediaStream.getRtcpComponent(), address, portManager.current() + 1, portManager, selector))) continue;
            this.logCandidateNotFound(address.toString(), portManager.getLowestPort(), portManager.getHighestPort());
        }
    }

    private void logCandidateNotFound(String address, int lowPort, int highPort) {
        this.logger.warn((Object)String.format("Could not find RTP candidate for address %s between ports %d and %d", address, lowPort, highPort));
    }

    private boolean gatherCandidate(IceComponent component, InetAddress address, int startingPort, PortManager portManager, Selector selector) {
        if (startingPort == portManager.peek()) {
            return false;
        }
        try {
            int port = portManager.current();
            DatagramChannel channel = this.openUdpChannel(address, port, selector);
            HostCandidate candidate = new HostCandidate(component, address, port);
            this.foundations.assignFoundation(candidate);
            component.addLocalCandidate(new LocalCandidateWrapper(candidate, channel));
            return true;
        }
        catch (IOException e) {
            portManager.next();
            return this.gatherCandidate(component, address, startingPort, portManager, selector);
        }
    }

    private void gatherRtcpMuxCandidate(IceComponent rtpComponent, IceComponent rtcpComponent) {
        LocalCandidateWrapper rtpCandidate = rtpComponent.getDefaultLocalCandidate();
        int port = rtpCandidate.getCandidate().getPort();
        InetAddress address = rtpCandidate.getCandidate().getAddress();
        HostCandidate hostCandidate = new HostCandidate(rtcpComponent, address.toString(), port);
        rtcpComponent.addLocalCandidate(new LocalCandidateWrapper(hostCandidate, rtpCandidate.getChannel()));
    }

    @Override
    public CandidateType getCandidateType() {
        return CandidateType.HOST;
    }
}

