/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.ice.harvest;

import java.net.InetAddress;
import java.nio.channels.Selector;
import java.util.List;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.CandidateType;
import org.mobicents.media.io.ice.FoundationsRegistry;
import org.mobicents.media.io.ice.HostCandidate;
import org.mobicents.media.io.ice.IceComponent;
import org.mobicents.media.io.ice.IceMediaStream;
import org.mobicents.media.io.ice.LocalCandidateWrapper;
import org.mobicents.media.io.ice.ServerReflexiveCandidate;
import org.mobicents.media.io.ice.harvest.CandidateHarvester;
import org.mobicents.media.io.ice.harvest.HarvestException;
import org.mobicents.media.server.io.network.PortManager;

public class ExternalCandidateHarvester
implements CandidateHarvester {
    Logger logger = Logger.getLogger(ExternalCandidateHarvester.class);
    private final FoundationsRegistry foundations;
    private final InetAddress externalAddress;

    public ExternalCandidateHarvester(FoundationsRegistry foundations, InetAddress externalAddress) {
        this.foundations = foundations;
        this.externalAddress = externalAddress;
    }

    @Override
    public void harvest(PortManager portManager, IceMediaStream mediaStream, Selector selector) throws HarvestException {
        this.harvest(mediaStream.getRtpComponent());
        if (mediaStream.supportsRtcp() && !mediaStream.isRtcpMux()) {
            this.harvest(mediaStream.getRtcpComponent());
        }
    }

    private void harvest(IceComponent component) {
        List<LocalCandidateWrapper> rtpCandidates = component.getLocalCandidates();
        for (LocalCandidateWrapper candidateWrapper : rtpCandidates) {
            if (!(candidateWrapper.getCandidate() instanceof HostCandidate)) continue;
            HostCandidate hostCandidate = (HostCandidate)candidateWrapper.getCandidate();
            ServerReflexiveCandidate srflxCandidate = new ServerReflexiveCandidate(component, this.externalAddress, hostCandidate.getPort(), hostCandidate);
            this.foundations.assignFoundation(srflxCandidate);
            component.addLocalCandidate(new LocalCandidateWrapper(srflxCandidate, candidateWrapper.getChannel()));
        }
    }

    @Override
    public CandidateType getCandidateType() {
        return CandidateType.SRFLX;
    }
}

