/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.ice;

import org.mobicents.media.io.ice.IceComponent;

public class IceMediaStream {
    private final String name;
    private IceComponent rtpComponent;
    private IceComponent rtcpComponent;
    private String remoteUfrag;
    private String remotePassword;
    private boolean rtcpMux;

    public IceMediaStream(String name) {
        this(name, true);
    }

    public IceMediaStream(String name, boolean rtcp) {
        this(name, rtcp, false);
    }

    public IceMediaStream(String name, boolean rtcp, boolean rtcpMux) {
        this.validateName(name);
        this.name = name.toLowerCase();
        this.rtpComponent = new IceComponent(1);
        if (rtcp) {
            this.rtcpComponent = new IceComponent(2);
        }
        this.rtcpMux = rtcp ? rtcpMux : false;
    }

    private void validateName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The media stream name cannot be null or empty.");
        }
    }

    public String getName() {
        return this.name;
    }

    public IceComponent getRtpComponent() {
        return this.rtpComponent;
    }

    public boolean hasLocalRtpCandidates() {
        return !this.rtpComponent.getLocalCandidates().isEmpty();
    }

    public IceComponent getRtcpComponent() {
        return this.rtcpComponent;
    }

    public boolean hasLocalRtcpCandidates() {
        if (this.supportsRtcp()) {
            return !this.rtcpComponent.getLocalCandidates().isEmpty();
        }
        return false;
    }

    public boolean supportsRtcp() {
        return this.rtcpComponent != null;
    }

    public boolean isRtcpMux() {
        return this.rtcpMux;
    }

    public String getRemoteUfrag() {
        return this.remoteUfrag;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void selectLocalDefaultCandidates() {
        this.rtpComponent.selectDefaultLocalCandidate();
        if (this.supportsRtcp()) {
            this.rtcpComponent.selectDefaultLocalCandidate();
        }
    }
}

