/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.ice;

import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mobicents.media.io.ice.CandidatePair;
import org.mobicents.media.io.ice.IceCandidate;
import org.mobicents.media.io.ice.LocalCandidateWrapper;

public class IceComponent {
    public static final short RTP_ID = 1;
    public static final short RTCP_ID = 2;
    private short componentId;
    private final List<LocalCandidateWrapper> localCandidates;
    private LocalCandidateWrapper defaultLocalCandidate;
    private CandidatePair candidatePair;

    public IceComponent(short componentId) {
        this.setComponentId(componentId);
        this.localCandidates = new ArrayList<LocalCandidateWrapper>(5);
    }

    private boolean isValidComponentId(int componentId) {
        return componentId == 1 || componentId == 2;
    }

    public short getComponentId() {
        return this.componentId;
    }

    public void setComponentId(short componentId) {
        if (!this.isValidComponentId(componentId)) {
            throw new IllegalArgumentException("Invalid Component ID: " + componentId);
        }
        this.componentId = componentId;
    }

    public void addLocalCandidates(List<LocalCandidateWrapper> candidatesWrapper) {
        for (LocalCandidateWrapper candidateWrapper : candidatesWrapper) {
            this.addLocalCandidate(candidateWrapper, false);
        }
        this.sortCandidates();
    }

    public void addLocalCandidate(LocalCandidateWrapper candidateWrapper) {
        this.addLocalCandidate(candidateWrapper, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocalCandidate(LocalCandidateWrapper candidateWrapper, boolean sort) {
        IceCandidate candidate = candidateWrapper.getCandidate();
        candidate.setPriority(this.calculatePriority(candidate));
        List<LocalCandidateWrapper> list = this.localCandidates;
        synchronized (list) {
            if (!this.localCandidates.contains(candidateWrapper)) {
                this.localCandidates.add(candidateWrapper);
                this.sortCandidates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortCandidates() {
        List<LocalCandidateWrapper> list = this.localCandidates;
        synchronized (list) {
            Collections.sort(this.localCandidates);
        }
    }

    private long calculatePriority(IceCandidate candidate) {
        return (long)(candidate.getType().getPreference() << 24) + (long)(candidate.getAddressPrecedence() << 8) + (long)(256 - this.getComponentId());
    }

    public LocalCandidateWrapper selectDefaultLocalCandidate() {
        this.defaultLocalCandidate = this.localCandidates.get(0);
        return this.defaultLocalCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalCandidateWrapper> getLocalCandidates() {
        ArrayList<LocalCandidateWrapper> copy;
        List<LocalCandidateWrapper> list = this.localCandidates;
        synchronized (list) {
            copy = new ArrayList<LocalCandidateWrapper>(this.localCandidates);
        }
        return copy;
    }

    public LocalCandidateWrapper getDefaultLocalCandidate() {
        return this.defaultLocalCandidate;
    }

    public boolean isDefaultLocalCandidateSelected() {
        return this.defaultLocalCandidate != null;
    }

    public CandidatePair getSelectedCandidates() {
        return this.candidatePair;
    }

    public CandidatePair setCandidatePair(DatagramChannel channel) {
        for (LocalCandidateWrapper localCandidate : this.getLocalCandidates()) {
            if (!channel.equals(localCandidate.getChannel())) continue;
            this.candidatePair = new CandidatePair(this.componentId, channel);
            return this.candidatePair;
        }
        return null;
    }
}

