/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.io.ice;

import java.net.InetAddress;
import org.mobicents.media.io.ice.CandidateType;
import org.mobicents.media.io.ice.IceComponent;
import org.mobicents.media.server.io.network.TransportAddress;

public class IceCandidate
extends TransportAddress
implements Comparable<IceCandidate>,
Cloneable {
    private static final long serialVersionUID = 2306608901365110071L;
    public static final int IP4_PRECEDENCE = 65535;
    private final IceComponent component;
    private final int addressPrecedence;
    private final CandidateType type;
    private String foundation;
    private long priority;
    protected IceCandidate base;

    public IceCandidate(IceComponent component, InetAddress address, int port, CandidateType type) {
        super(address, port, TransportAddress.TransportProtocol.UDP);
        this.component = component;
        this.type = type;
        this.addressPrecedence = this.calculateAddressPrecedence();
        this.priority = 0L;
    }

    protected IceCandidate(IceComponent component, String hostname, int port, CandidateType type) {
        super(hostname, port, TransportAddress.TransportProtocol.UDP);
        this.component = component;
        this.type = type;
        this.addressPrecedence = this.calculateAddressPrecedence();
        this.priority = 0L;
    }

    public CandidateType getType() {
        return this.type;
    }

    public String getFoundation() {
        return this.foundation;
    }

    public void setFoundation(String foundation) {
        this.foundation = foundation;
    }

    public int getAddressPrecedence() {
        return this.addressPrecedence;
    }

    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    public IceCandidate getBase() {
        return this.base;
    }

    private int calculateAddressPrecedence() {
        if (this.isIPv6()) {
            throw new UnsupportedOperationException("IPv6 addresses are not supported.");
        }
        return 65535;
    }

    @Override
    public int compareTo(IceCandidate o) {
        if (o == null) {
            return 1;
        }
        return (int)(this.priority - o.priority);
    }

    public IceCandidate clone() throws CloneNotSupportedException {
        return (IceCandidate)super.clone();
    }

    public short getComponentId() {
        return this.component.getComponentId();
    }
}

