/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.PropertyDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedMethod;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class PropertyMetaData
extends AbstractConstraintMetaData {
    private final Set<Member> cascadingMembers;

    private PropertyMetaData(String propertyName, Class<?> type, Set<MetaConstraint<?>> constraints, Set<Member> cascadingMembers) {
        super(propertyName, type, constraints, ConstraintMetaData.ConstraintMetaDataKind.PROPERTY, !cascadingMembers.isEmpty(), !cascadingMembers.isEmpty() || !constraints.isEmpty());
        this.cascadingMembers = Collections.unmodifiableSet(cascadingMembers);
    }

    public Set<Member> getCascadingMembers() {
        return this.cascadingMembers;
    }

    @Override
    public PropertyDescriptorImpl asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new PropertyDescriptorImpl(this.getType(), this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    @Override
    public String toString() {
        StringBuilder cascadingMembers = new StringBuilder();
        for (Member oneCascadingMember : this.cascadingMembers) {
            cascadingMembers.append(oneCascadingMember.getName());
            cascadingMembers.append(", ");
        }
        if (cascadingMembers.length() > 0) {
            cascadingMembers.subSequence(0, cascadingMembers.length() - 2);
        }
        return "PropertyMetaData [type=" + this.getType().getSimpleName() + ", propertyName=" + this.getName() + ", cascadingMembers=[" + cascadingMembers + "]]";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public static class Builder
    extends MetaDataBuilder {
        private static final EnumSet<ConstrainedElement.ConstrainedElementKind> SUPPORTED_ELEMENT_KINDS = EnumSet.of(ConstrainedElement.ConstrainedElementKind.TYPE, ConstrainedElement.ConstrainedElementKind.FIELD, ConstrainedElement.ConstrainedElementKind.METHOD);
        private final Class<?> beanClass;
        private final String propertyName;
        private final Class<?> propertyType;
        private final Set<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
        private final Set<Member> cascadingMembers = CollectionHelper.newHashSet();

        public Builder(ConstrainedField constrainedField, ConstraintHelper constraintHelper) {
            super(constraintHelper);
            this.beanClass = constrainedField.getLocation().getBeanClass();
            this.propertyName = ReflectionHelper.getPropertyName(constrainedField.getLocation().getMember());
            this.propertyType = ((Field)constrainedField.getLocation().getMember()).getType();
            this.add(constrainedField);
        }

        public Builder(ConstrainedType constrainedType, ConstraintHelper constraintHelper) {
            super(constraintHelper);
            this.beanClass = constrainedType.getLocation().getBeanClass();
            this.propertyName = null;
            this.propertyType = null;
            this.add(constrainedType);
        }

        public Builder(ConstrainedMethod constrainedMethod, ConstraintHelper constraintHelper) {
            super(constraintHelper);
            this.beanClass = constrainedMethod.getLocation().getBeanClass();
            this.propertyName = ReflectionHelper.getPropertyName(constrainedMethod.getLocation().getMember());
            this.propertyType = constrainedMethod.getLocation().getMember().getReturnType();
            this.add(constrainedMethod);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (!SUPPORTED_ELEMENT_KINDS.contains((Object)constrainedElement.getKind())) {
                return false;
            }
            if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD && !((ConstrainedMethod)constrainedElement).isGetterMethod()) {
                return false;
            }
            return this.equals(ReflectionHelper.getPropertyName(constrainedElement.getLocation().getMember()), this.propertyName);
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            this.constraints.addAll(constrainedElement.getConstraints());
            if (constrainedElement.isCascading()) {
                this.cascadingMembers.add(constrainedElement.getLocation().getMember());
            }
        }

        @Override
        public PropertyMetaData build() {
            return new PropertyMetaData(this.propertyName, this.propertyType, this.adaptOriginsAndImplicitGroups(this.beanClass, this.constraints), this.cascadingMembers);
        }

        private boolean equals(String s1, String s2) {
            return s1 != null && s1.equals(s2) || s1 == null && s2 == null;
        }
    }
}

