/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.web.WebMessages;
import org.jboss.dmr.ModelNode;

public class WriteEnableWelcomeRoot
implements OperationStepHandler {
    static final WriteEnableWelcomeRoot INSTANCE = new WriteEnableWelcomeRoot();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode virtualHost = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        boolean enable = Boolean.parseBoolean(operation.get("value").toString());
        if (enable && virtualHost.hasDefined("default-web-module")) {
            throw new OperationFailedException(WebMessages.MESSAGES.noWelcomeWebappWithDefaultWebModule());
        }
        virtualHost.get("enable-welcome-root").set(enable);
        if (context.isNormalServer()) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (context.isNormalServer()) {
                    context.revertReloadRequired();
                }
            }
        });
    }
}

