/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQUnsupportedPacketException;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.IOCompletion;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.LoaderCallback;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.TransactionFailureCallback;
import org.hornetq.core.journal.impl.JournalBase;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecord;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecord;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;

public final class FileWrapperJournal
extends JournalBase {
    private final ReentrantLock lockAppend = new ReentrantLock();
    private final ConcurrentMap<Long, AtomicInteger> transactions = new ConcurrentHashMap<Long, AtomicInteger>();
    private final JournalImpl journal;
    protected volatile JournalFile currentFile;

    public FileWrapperJournal(Journal journal) throws Exception {
        super(journal.getFileFactory().isSupportsCallbacks(), journal.getFileSize());
        this.journal = (JournalImpl)journal;
        this.currentFile = this.journal.setUpCurrentFile(16);
    }

    public void start() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void stop() throws Exception {
        if (this.currentFile.getFile().isOpen()) {
            this.currentFile.getFile().close();
        }
    }

    public boolean isStarted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion callback) throws Exception {
        JournalAddRecord addRecord = new JournalAddRecord(true, id, recordType, record);
        this.writeRecord(addRecord, sync, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecord(JournalInternalRecord encoder, boolean sync, IOCompletion callback) throws Exception {
        this.lockAppend.lock();
        try {
            if (callback != null) {
                callback.storeLineUp();
            }
            this.currentFile = this.journal.switchFileIfNecessary(encoder.getEncodeSize());
            encoder.setFileID(this.currentFile.getRecordID());
            if (callback != null) {
                this.currentFile.getFile().write(encoder, sync, (IOAsyncTask)callback);
            } else {
                this.currentFile.getFile().write(encoder, sync);
            }
        }
        finally {
            this.lockAppend.unlock();
        }
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion callback) throws Exception {
        JournalDeleteRecord deleteRecord = new JournalDeleteRecord(id);
        this.writeRecord(deleteRecord, sync, callback);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        this.count(txID);
        JournalDeleteRecordTX deleteRecordTX = new JournalDeleteRecordTX(txID, id, record);
        this.writeRecord(deleteRecordTX, false, null);
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.count(txID);
        JournalAddRecordTX addRecord = new JournalAddRecordTX(true, txID, id, recordType, record);
        this.writeRecord(addRecord, false, null);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion callback) throws Exception {
        JournalAddRecord updateRecord = new JournalAddRecord(false, id, recordType, record);
        this.writeRecord(updateRecord, sync, callback);
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.count(txID);
        JournalAddRecordTX updateRecordTX = new JournalAddRecordTX(false, txID, id, recordType, record);
        this.writeRecord(updateRecordTX, false, null);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        JournalCompleteRecordTX commitRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.COMMIT, txID, null);
        AtomicInteger value = (AtomicInteger)this.transactions.remove(txID);
        if (value != null) {
            ((JournalInternalRecord)commitRecord).setNumberOfRecords(value.get());
        }
        this.writeRecord(commitRecord, true, callback);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        JournalCompleteRecordTX prepareRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.PREPARE, txID, transactionData);
        AtomicInteger value = (AtomicInteger)this.transactions.get(txID);
        if (value != null) {
            ((JournalInternalRecord)prepareRecord).setNumberOfRecords(value.get());
        }
        this.writeRecord(prepareRecord, sync, callback);
    }

    private int count(long txID) throws HornetQException {
        AtomicInteger defaultValue = new AtomicInteger(1);
        AtomicInteger count = this.transactions.putIfAbsent(txID, defaultValue);
        if (count != null) {
            return count.incrementAndGet();
        }
        return defaultValue.get();
    }

    public String toString() {
        return FileWrapperJournal.class.getName() + "(currentFile=[" + this.currentFile + "], hash=" + super.toString() + ")";
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        throw new HornetQUnsupportedPacketException();
    }

    @Override
    public JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
        throw new HornetQUnsupportedPacketException();
    }

    @Override
    public JournalLoadInformation loadInternalOnly() throws Exception {
        throw new HornetQUnsupportedPacketException();
    }

    @Override
    public void lineUpContex(IOCompletion callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        throw new HornetQUnsupportedPacketException();
    }

    @Override
    public int getAlignment() throws Exception {
        throw new HornetQUnsupportedPacketException();
    }

    @Override
    public int getNumberOfRecords() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUserVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void perfBlast(int pages) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void runDirectJournalBlast() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizationLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizationUnlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceMoveNextFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JournalFile[] getDataFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    void scheduleReclaim() {
    }

    @Override
    public SequentialFileFactory getFileFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scheduleCompactAndBlock(int timeout) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replicationSyncPreserveOldFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replicationSyncFinished() {
        throw new UnsupportedOperationException();
    }
}

