/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mgcp;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;

@Immutable
public final class PlayRecord {
    private final List<URI> initialPrompts;
    private final boolean clearDigitBuffer;
    private final long preSpeechTimer;
    private final long postSpeechTimer;
    private final long recordingLength;
    private final String endInputKey;
    private final URI recordingId;

    private PlayRecord(List<URI> initialPrompts, boolean clearDigitBuffer, long preSpeechTimer, long postSpeechTimer, long recordingLength, String endInputKey, URI recordingId) {
        this.initialPrompts = initialPrompts;
        this.clearDigitBuffer = clearDigitBuffer;
        this.preSpeechTimer = preSpeechTimer;
        this.postSpeechTimer = postSpeechTimer;
        this.recordingLength = recordingLength;
        this.endInputKey = endInputKey;
        this.recordingId = recordingId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<URI> initialPrompts() {
        return this.initialPrompts;
    }

    public boolean clearDigitBuffer() {
        return this.clearDigitBuffer;
    }

    public long preSpeechTimer() {
        return this.preSpeechTimer;
    }

    public long postSpeechTimer() {
        return this.postSpeechTimer;
    }

    public long recordingLength() {
        return this.recordingLength;
    }

    public String endInputKey() {
        return this.endInputKey;
    }

    public URI recordingId() {
        return this.recordingId;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.initialPrompts.isEmpty()) {
            buffer.append("ip=");
            for (int index = 0; index < this.initialPrompts.size(); ++index) {
                buffer.append(this.initialPrompts.get(index));
                if (index >= this.initialPrompts.size() - 1) continue;
                buffer.append(";");
            }
        }
        if (this.recordingId != null) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("ri=").append(this.recordingId);
        }
        if (this.clearDigitBuffer) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("cb=").append("true");
        }
        if (this.preSpeechTimer > 0L) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("prt=").append(this.preSpeechTimer * 10L);
        }
        if (this.postSpeechTimer > 0L) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("pst=").append(this.postSpeechTimer * 10L);
        }
        if (this.recordingLength > 0L) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("rlt=").append(this.recordingLength * 1000L);
        }
        if (this.endInputKey != null) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("eik=").append(this.endInputKey).append(" ");
            buffer.append("mn=").append(this.endInputKey.length()).append(" ");
            buffer.append("mx=").append(this.endInputKey.length());
        }
        return buffer.toString();
    }

    public static final class Builder {
        private List<URI> initialPrompts = new ArrayList<URI>();
        private boolean clearDigitBuffer = false;
        private long preSpeechTimer = -1L;
        private long postSpeechTimer = -1L;
        private long recordingLength = -1L;
        private String endInputKey = null;
        private URI recordingId = null;

        private Builder() {
        }

        public PlayRecord build() {
            return new PlayRecord(this.initialPrompts, this.clearDigitBuffer, this.preSpeechTimer, this.postSpeechTimer, this.recordingLength, this.endInputKey, this.recordingId);
        }

        public void addPrompt(URI prompt) {
            this.initialPrompts.add(prompt);
        }

        public void setClearDigitBuffer(boolean clearDigitBuffer) {
            this.clearDigitBuffer = clearDigitBuffer;
        }

        public void setPreSpeechTimer(long preSpeechTimer) {
            this.preSpeechTimer = preSpeechTimer;
        }

        public void setPostSpeechTimer(long postSpeechTimer) {
            this.postSpeechTimer = postSpeechTimer;
        }

        public void setRecordingLength(long recordingLength) {
            this.recordingLength = recordingLength;
        }

        public void setEndInputKey(String endInputKey) {
            this.endInputKey = endInputKey;
        }

        public void setRecordingId(URI recordingId) {
            this.recordingId = recordingId;
        }
    }
}

