/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mgcp;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;

@Immutable
public final class PlayCollect {
    private final List<URI> initialPrompts;
    private final boolean clearDigitBuffer;
    private final int maxNumberOfDigits;
    private final int minNumberOfDigits;
    private final String digitPattern;
    private final long firstDigitTimer;
    private final long interDigitTimer;
    private final String endInputKey;

    private PlayCollect(List<URI> initialPrompts, boolean clearDigitBuffer, int maxNumberOfDigits, int minNumberOfDigits, String digitPattern, long firstDigitTimer, long interDigitTimer, String endInputKey) {
        this.initialPrompts = initialPrompts;
        this.clearDigitBuffer = clearDigitBuffer;
        this.maxNumberOfDigits = maxNumberOfDigits;
        this.minNumberOfDigits = minNumberOfDigits;
        this.digitPattern = digitPattern;
        this.firstDigitTimer = firstDigitTimer;
        this.interDigitTimer = interDigitTimer;
        this.endInputKey = endInputKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<URI> initialPrompts() {
        return this.initialPrompts;
    }

    public boolean clearDigitBuffer() {
        return this.clearDigitBuffer;
    }

    public int maxNumberOfDigits() {
        return this.maxNumberOfDigits;
    }

    public int minNumberOfDigits() {
        return this.minNumberOfDigits;
    }

    public String digitPattern() {
        return this.digitPattern;
    }

    public long firstDigitTimer() {
        return this.firstDigitTimer;
    }

    public long interDigitTimer() {
        return this.interDigitTimer;
    }

    public String endInputKey() {
        return this.endInputKey;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.initialPrompts.isEmpty()) {
            buffer.append("ip=");
            for (int index = 0; index < this.initialPrompts.size(); ++index) {
                buffer.append(this.initialPrompts.get(index));
                if (index >= this.initialPrompts.size() - 1) continue;
                buffer.append(";");
            }
        }
        if (this.clearDigitBuffer) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("cb=").append("true");
        }
        if (this.maxNumberOfDigits > 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("mx=").append(this.maxNumberOfDigits);
        }
        if (this.minNumberOfDigits > 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("mn=").append(this.minNumberOfDigits);
        }
        if (this.digitPattern != null) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("dp=").append(this.digitPattern);
        }
        if (this.firstDigitTimer > 0L) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("fdt=").append(this.firstDigitTimer * 10L);
        }
        if (this.interDigitTimer > 0L) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("idt=").append(this.interDigitTimer * 10L);
        }
        if (this.endInputKey != null) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append("eik=").append(this.endInputKey);
        }
        return buffer.toString();
    }

    public static final class Builder {
        private List<URI> initialPrompts = new ArrayList<URI>();
        private boolean clearDigitBuffer = false;
        private int maxNumberOfDigits = -1;
        private int minNumberOfDigits = -1;
        private String digitPattern = null;
        private long firstDigitTimer = -1L;
        private long interDigitTimer = -1L;
        private String endInputKey = null;

        private Builder() {
        }

        public PlayCollect build() {
            return new PlayCollect(this.initialPrompts, this.clearDigitBuffer, this.maxNumberOfDigits, this.minNumberOfDigits, this.digitPattern, this.firstDigitTimer, this.interDigitTimer, this.endInputKey);
        }

        public void addPrompt(URI prompt) {
            this.initialPrompts.add(prompt);
        }

        public void setClearDigitBuffer(boolean clearDigitBuffer) {
            this.clearDigitBuffer = clearDigitBuffer;
        }

        public void setMaxNumberOfDigits(int maxNumberOfDigits) {
            this.maxNumberOfDigits = maxNumberOfDigits;
        }

        public void setMinNumberOfDigits(int minNumberOfDigits) {
            this.minNumberOfDigits = minNumberOfDigits;
        }

        public void setDigitPattern(String digitPattern) {
            this.digitPattern = digitPattern;
        }

        public void setFirstDigitTimer(long firstDigitTimer) {
            this.firstDigitTimer = firstDigitTimer;
        }

        public void setInterDigitTimer(long interDigitTimer) {
            this.interDigitTimer = interDigitTimer;
        }

        public void setEndInputKey(String endInputKey) {
            this.endInputKey = endInputKey;
        }
    }
}

