/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mgcp;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;

@Immutable
public final class Play {
    private final List<URI> announcements;
    private final int iterations;

    public Play(List<URI> announcements, int iterations) {
        this.announcements = announcements;
        this.iterations = iterations;
    }

    public Play(URI announcement, int iterations) {
        this.announcements = new ArrayList<URI>();
        this.announcements.add(announcement);
        this.iterations = iterations;
    }

    public List<URI> announcements() {
        return this.announcements;
    }

    public int iterations() {
        return this.iterations;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.announcements.isEmpty()) {
            buffer.append("an=");
            for (int index = 0; index < this.announcements.size(); ++index) {
                buffer.append(this.announcements.get(index));
                if (index >= this.announcements.size() - 1) continue;
                buffer.append(";");
            }
            if (this.iterations > 0) {
                buffer.append(" ");
                buffer.append("it=").append(this.iterations);
            }
        }
        return buffer.toString();
    }
}

