/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mgcp;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import java.net.InetAddress;
import org.mobicents.protocols.mgcp.jain.pkg.AUMgcpEvent;
import org.mobicents.protocols.mgcp.jain.pkg.AUPackage;
import org.mobicents.servlet.restcomm.mgcp.BridgeEndpoint;
import org.mobicents.servlet.restcomm.mgcp.ConferenceEndpoint;
import org.mobicents.servlet.restcomm.mgcp.Connection;
import org.mobicents.servlet.restcomm.mgcp.CreateBridgeEndpoint;
import org.mobicents.servlet.restcomm.mgcp.CreateConferenceEndpoint;
import org.mobicents.servlet.restcomm.mgcp.CreateConnection;
import org.mobicents.servlet.restcomm.mgcp.CreateIvrEndpoint;
import org.mobicents.servlet.restcomm.mgcp.CreateLink;
import org.mobicents.servlet.restcomm.mgcp.CreateMediaSession;
import org.mobicents.servlet.restcomm.mgcp.CreatePacketRelayEndpoint;
import org.mobicents.servlet.restcomm.mgcp.DestroyConnection;
import org.mobicents.servlet.restcomm.mgcp.DestroyEndpoint;
import org.mobicents.servlet.restcomm.mgcp.DestroyLink;
import org.mobicents.servlet.restcomm.mgcp.GetMediaGatewayInfo;
import org.mobicents.servlet.restcomm.mgcp.IvrEndpoint;
import org.mobicents.servlet.restcomm.mgcp.Link;
import org.mobicents.servlet.restcomm.mgcp.MediaGatewayInfo;
import org.mobicents.servlet.restcomm.mgcp.MediaGatewayResponse;
import org.mobicents.servlet.restcomm.mgcp.MediaSession;
import org.mobicents.servlet.restcomm.mgcp.PacketRelayEndpoint;
import org.mobicents.servlet.restcomm.mgcp.PowerOffMediaGateway;
import org.mobicents.servlet.restcomm.mgcp.PowerOnMediaGateway;
import org.mobicents.servlet.restcomm.util.RevolvingCounter;

public final class MockMediaGateway
extends UntypedActor {
    private static final String sdp = "v=0\no=- 1362546170756 1 IN IP4 192.168.1.100\ns=Mobicents Media Server\nc=IN IP4 192.168.1.100\nt=0 0\nm=audio 63044 RTP/AVP 97 8 0 101\na=rtpmap:97 l16/8000\na=rtpmap:8 pcma/8000\na=rtpmap:0 pcmu/8000\na=rtpmap:101 telephone-event/8000\na=fmtp:101 0-15\n";
    private String name;
    private InetAddress localIp;
    private int localPort;
    private InetAddress remoteIp;
    private int remotePort;
    private boolean useNat;
    private InetAddress externalIp;
    private long timeout;
    private NotifiedEntity agent;
    private String domain;
    private RevolvingCounter requestIdPool;
    private RevolvingCounter sessionIdPool;
    private RevolvingCounter transactionIdPool;
    private RevolvingCounter connectionIdPool;
    private RevolvingCounter endpointIdPool;

    private ActorRef getConnection(Object message) {
        CreateConnection request = (CreateConnection)message;
        final MediaSession session = request.session();
        final ActorRef gateway = this.self();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Connection(gateway, session, MockMediaGateway.this.agent, MockMediaGateway.this.timeout);
            }
        }));
    }

    private ActorRef getBridgeEndpoint(Object message) {
        CreateBridgeEndpoint request = (CreateBridgeEndpoint)message;
        final ActorRef gateway = this.self();
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new BridgeEndpoint(gateway, session, MockMediaGateway.this.agent, MockMediaGateway.this.domain);
            }
        }));
    }

    private ActorRef getConferenceEndpoint(Object message) {
        final ActorRef gateway = this.self();
        CreateConferenceEndpoint request = (CreateConferenceEndpoint)message;
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new ConferenceEndpoint(gateway, session, MockMediaGateway.this.agent, MockMediaGateway.this.domain);
            }
        }));
    }

    private MediaGatewayInfo getInfo(Object message) {
        return new MediaGatewayInfo(this.name, this.remoteIp, this.remotePort, this.useNat, this.externalIp);
    }

    private ActorRef getIvrEndpoint(Object message) {
        final ActorRef gateway = this.self();
        CreateIvrEndpoint request = (CreateIvrEndpoint)message;
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new IvrEndpoint(gateway, session, MockMediaGateway.this.agent, MockMediaGateway.this.domain);
            }
        }));
    }

    private ActorRef getLink(Object message) {
        CreateLink request = (CreateLink)message;
        final ActorRef gateway = this.self();
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Link(gateway, session, MockMediaGateway.this.agent, MockMediaGateway.this.timeout);
            }
        }));
    }

    private ActorRef getPacketRelayEndpoint(Object message) {
        final ActorRef gateway = this.self();
        CreatePacketRelayEndpoint request = (CreatePacketRelayEndpoint)message;
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new PacketRelayEndpoint(gateway, session, MockMediaGateway.this.agent, MockMediaGateway.this.domain);
            }
        }));
    }

    private MediaSession getSession() {
        return new MediaSession((int)this.sessionIdPool.get());
    }

    private void powerOff(Object message) {
        this.name = null;
        this.localIp = null;
        this.localPort = 0;
        this.remoteIp = null;
        this.remotePort = 0;
        this.useNat = false;
        this.externalIp = null;
        this.timeout = 0L;
        this.agent = null;
        this.domain = null;
        this.requestIdPool = null;
        this.sessionIdPool = null;
        this.transactionIdPool = null;
    }

    private void powerOn(Object message) {
        PowerOnMediaGateway request = (PowerOnMediaGateway)message;
        this.name = request.getName();
        this.localIp = request.getLocalIp();
        this.localPort = request.getLocalPort();
        this.remoteIp = request.getRemoteIp();
        this.remotePort = request.getRemotePort();
        this.useNat = request.useNat();
        this.externalIp = request.getExternalIp();
        this.timeout = request.getTimeout();
        this.agent = new NotifiedEntity("restcomm", this.localIp.getHostAddress(), this.localPort);
        this.domain = this.remoteIp.getHostAddress() + ":" + this.remotePort;
        this.connectionIdPool = new RevolvingCounter(1L, Integer.MAX_VALUE);
        this.endpointIdPool = new RevolvingCounter(1L, Integer.MAX_VALUE);
        this.requestIdPool = new RevolvingCounter(1L, Integer.MAX_VALUE);
        this.sessionIdPool = new RevolvingCounter(1L, Integer.MAX_VALUE);
        this.transactionIdPool = new RevolvingCounter(1L, Integer.MAX_VALUE);
    }

    public void onReceive(Object message) throws Exception {
        UntypedActorContext context = this.getContext();
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (PowerOnMediaGateway.class.equals(klass)) {
            this.powerOn(message);
        } else if (PowerOffMediaGateway.class.equals(klass)) {
            this.powerOff(message);
        } else if (GetMediaGatewayInfo.class.equals(klass)) {
            sender.tell(new MediaGatewayResponse<MediaGatewayInfo>(this.getInfo(message)), sender);
        } else if (CreateConnection.class.equals(klass)) {
            sender.tell(new MediaGatewayResponse<ActorRef>(this.getConnection(message)), self);
        } else if (CreateLink.class.equals(klass)) {
            sender.tell(new MediaGatewayResponse<ActorRef>(this.getLink(message)), self);
        } else if (CreateMediaSession.class.equals(klass)) {
            sender.tell(new MediaGatewayResponse<MediaSession>(this.getSession()), self);
        } else if (CreateBridgeEndpoint.class.equals(klass)) {
            ActorRef endpoint = this.getBridgeEndpoint(message);
            sender.tell(new MediaGatewayResponse<ActorRef>(endpoint), self);
        } else if (CreatePacketRelayEndpoint.class.equals(klass)) {
            ActorRef endpoint = this.getPacketRelayEndpoint(message);
            sender.tell(new MediaGatewayResponse<ActorRef>(endpoint), self);
        } else if (CreateIvrEndpoint.class.equals(klass)) {
            ActorRef endpoint = this.getIvrEndpoint(message);
            sender.tell(new MediaGatewayResponse<ActorRef>(endpoint), self);
        } else if (CreateConferenceEndpoint.class.equals(klass)) {
            ActorRef endpoint = this.getConferenceEndpoint(message);
            sender.tell(new MediaGatewayResponse<ActorRef>(endpoint), self);
        } else if (DestroyConnection.class.equals(klass)) {
            DestroyConnection request = (DestroyConnection)message;
            context.stop(request.connection());
        } else if (DestroyLink.class.equals(klass)) {
            DestroyLink request = (DestroyLink)message;
            context.stop(request.link());
        } else if (DestroyEndpoint.class.equals(klass)) {
            DestroyEndpoint request = (DestroyEndpoint)message;
            context.stop(request.endpoint());
        } else if (message instanceof JainMgcpCommandEvent) {
            this.send(message, sender);
        } else if (message instanceof JainMgcpResponseEvent) {
            this.send(message);
        }
    }

    private void createConnection(Object message, ActorRef sender) {
        ActorRef self = this.self();
        jain.protocol.ip.mgcp.message.CreateConnection crcx = (jain.protocol.ip.mgcp.message.CreateConnection)message;
        System.out.println(crcx.toString());
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.connectionIdPool.get());
        ConnectionIdentifier connId = new ConnectionIdentifier(buffer.toString());
        ReturnCode code = ReturnCode.Transaction_Executed_Normally;
        CreateConnectionResponse response = new CreateConnectionResponse((Object)self, code, connId);
        EndpointIdentifier endpointId = crcx.getEndpointIdentifier();
        String endpointName = endpointId.getLocalEndpointName();
        if (endpointName.endsWith("$")) {
            String[] tokens = endpointName.split("/");
            String type = tokens[1];
            buffer = new StringBuilder();
            buffer.append("mobicents/").append(type).append("/");
            buffer.append(this.endpointIdPool.get());
            endpointId = new EndpointIdentifier(buffer.toString(), this.domain);
        }
        response.setSpecificEndpointIdentifier(endpointId);
        EndpointIdentifier secondaryEndpointId = crcx.getSecondEndpointIdentifier();
        if (secondaryEndpointId != null) {
            buffer = new StringBuilder();
            buffer.append(this.connectionIdPool.get());
            connId = new ConnectionIdentifier(buffer.toString());
            response.setSecondConnectionIdentifier(connId);
            endpointName = secondaryEndpointId.getLocalEndpointName();
            if (endpointName.endsWith("$")) {
                String[] tokens = endpointName.split("/");
                String type = tokens[1];
                buffer = new StringBuilder();
                buffer.append("mobicents/").append(type).append("/");
                buffer.append(this.endpointIdPool.get());
                secondaryEndpointId = new EndpointIdentifier(buffer.toString(), this.domain);
            }
            response.setSecondEndpointIdentifier(secondaryEndpointId);
        }
        ConnectionDescriptor descriptor = new ConnectionDescriptor(sdp);
        response.setLocalConnectionDescriptor(descriptor);
        int transaction = crcx.getTransactionHandle();
        response.setTransactionHandle(transaction);
        System.out.println(response.toString());
        sender.tell((Object)response, self);
    }

    private void modifyConnection(Object message, ActorRef sender) {
        ActorRef self = this.self();
        ModifyConnection mdcx = (ModifyConnection)message;
        System.out.println(mdcx.toString());
        ReturnCode code = ReturnCode.Transaction_Executed_Normally;
        ModifyConnectionResponse response = new ModifyConnectionResponse((Object)self, code);
        ConnectionDescriptor descriptor = new ConnectionDescriptor(sdp);
        response.setLocalConnectionDescriptor(descriptor);
        int transaction = mdcx.getTransactionHandle();
        response.setTransactionHandle(transaction);
        System.out.println(response.toString());
        sender.tell((Object)response, self);
    }

    private void deleteConnection(Object message, ActorRef sender) {
        ActorRef self = this.self();
        DeleteConnection dlcx = (DeleteConnection)message;
        System.out.println(dlcx.toString());
        ReturnCode code = ReturnCode.Transaction_Executed_Normally;
        DeleteConnectionResponse response = new DeleteConnectionResponse((Object)self, code);
        int transaction = dlcx.getTransactionHandle();
        response.setTransactionHandle(transaction);
        System.out.println(response.toString());
        sender.tell((Object)response, self);
    }

    private void notificationResponse(Object message, ActorRef sender) {
        ActorRef self = this.self();
        NotificationRequest rqnt = (NotificationRequest)message;
        System.out.println(rqnt.toString());
        ReturnCode code = ReturnCode.Transaction_Executed_Normally;
        NotificationRequestResponse response = new NotificationRequestResponse((Object)self, code);
        int transaction = rqnt.getTransactionHandle();
        response.setTransactionHandle(transaction);
        System.out.println(response.toString());
        sender.tell((Object)response, self);
    }

    private void notify(Object message, ActorRef sender) {
        ActorRef self = this.self();
        NotificationRequest request = (NotificationRequest)message;
        MgcpEvent event = AUMgcpEvent.auoc.withParm("rc=100 dc=1");
        EventName[] events = new EventName[]{new EventName(AUPackage.AU, event)};
        Notify notify = new Notify((Object)this, request.getEndpointIdentifier(), request.getRequestIdentifier(), events);
        notify.setTransactionHandle((int)this.transactionIdPool.get());
        System.out.println(notify.toString());
        sender.tell((Object)notify, self);
    }

    private void respond(Object message, ActorRef sender) {
        Class<?> klass = message.getClass();
        if (jain.protocol.ip.mgcp.message.CreateConnection.class.equals(klass)) {
            this.createConnection(message, sender);
        } else if (ModifyConnection.class.equals(klass)) {
            this.modifyConnection(message, sender);
        } else if (DeleteConnection.class.equals(klass)) {
            this.deleteConnection(message, sender);
        } else if (NotificationRequest.class.equals(klass)) {
            this.notificationResponse(message, sender);
        }
    }

    private void send(Object message, ActorRef sender) {
        JainMgcpCommandEvent command = (JainMgcpCommandEvent)message;
        int transactionId = (int)this.transactionIdPool.get();
        command.setTransactionHandle(transactionId);
        this.respond(message, sender);
        if (NotificationRequest.class.equals(command.getClass())) {
            NotificationRequest request = (NotificationRequest)command;
            String id = Long.toString(this.requestIdPool.get());
            request.getRequestIdentifier().setRequestIdentifier(id);
            this.notify(message, sender);
        }
    }

    private void send(Object message) {
        JainMgcpResponseEvent response = (JainMgcpResponseEvent)message;
        System.out.println(response.toString());
    }
}

