/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mgcp;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import java.net.InetAddress;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.concurrent.ConcurrentHashMap;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.servlet.restcomm.mgcp.BridgeEndpoint;
import org.mobicents.servlet.restcomm.mgcp.ConferenceEndpoint;
import org.mobicents.servlet.restcomm.mgcp.Connection;
import org.mobicents.servlet.restcomm.mgcp.CreateBridgeEndpoint;
import org.mobicents.servlet.restcomm.mgcp.CreateConferenceEndpoint;
import org.mobicents.servlet.restcomm.mgcp.CreateConnection;
import org.mobicents.servlet.restcomm.mgcp.CreateIvrEndpoint;
import org.mobicents.servlet.restcomm.mgcp.CreateLink;
import org.mobicents.servlet.restcomm.mgcp.CreateMediaSession;
import org.mobicents.servlet.restcomm.mgcp.CreatePacketRelayEndpoint;
import org.mobicents.servlet.restcomm.mgcp.DestroyConnection;
import org.mobicents.servlet.restcomm.mgcp.DestroyEndpoint;
import org.mobicents.servlet.restcomm.mgcp.DestroyLink;
import org.mobicents.servlet.restcomm.mgcp.GetMediaGatewayInfo;
import org.mobicents.servlet.restcomm.mgcp.IvrEndpoint;
import org.mobicents.servlet.restcomm.mgcp.Link;
import org.mobicents.servlet.restcomm.mgcp.MediaGatewayInfo;
import org.mobicents.servlet.restcomm.mgcp.MediaGatewayResponse;
import org.mobicents.servlet.restcomm.mgcp.MediaSession;
import org.mobicents.servlet.restcomm.mgcp.PacketRelayEndpoint;
import org.mobicents.servlet.restcomm.mgcp.PowerOffMediaGateway;
import org.mobicents.servlet.restcomm.mgcp.PowerOnMediaGateway;
import org.mobicents.servlet.restcomm.util.RevolvingCounter;

public final class MediaGateway
extends UntypedActor
implements JainMgcpListener {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private String name;
    private InetAddress localIp;
    private int localPort;
    private InetAddress remoteIp;
    private int remotePort;
    private boolean useNat;
    private InetAddress externalIp;
    private long timeout;
    private JainMgcpProvider provider;
    private JainMgcpStack stack;
    private NotifiedEntity agent;
    private String domain;
    private Map<String, ActorRef> notificationListeners = new ConcurrentHashMap<String, ActorRef>();
    private Map<Integer, ActorRef> responseListeners = new ConcurrentHashMap<Integer, ActorRef>();
    private RevolvingCounter requestIdPool;
    private RevolvingCounter sessionIdPool;
    private RevolvingCounter transactionIdPool;

    private ActorRef getConnection(Object message) {
        CreateConnection request = (CreateConnection)message;
        final MediaSession session = request.session();
        final ActorRef gateway = this.self();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Connection(gateway, session, MediaGateway.this.agent, MediaGateway.this.timeout);
            }
        }));
    }

    private ActorRef getBridgeEndpoint(Object message) {
        CreateBridgeEndpoint request = (CreateBridgeEndpoint)message;
        final ActorRef gateway = this.self();
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new BridgeEndpoint(gateway, session, MediaGateway.this.agent, MediaGateway.this.domain);
            }
        }));
    }

    private ActorRef getConferenceEndpoint(Object message) {
        final ActorRef gateway = this.self();
        CreateConferenceEndpoint request = (CreateConferenceEndpoint)message;
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new ConferenceEndpoint(gateway, session, MediaGateway.this.agent, MediaGateway.this.domain);
            }
        }));
    }

    private MediaGatewayInfo getInfo(Object message) {
        return new MediaGatewayInfo(this.name, this.remoteIp, this.remotePort, this.useNat, this.externalIp);
    }

    private ActorRef getIvrEndpoint(Object message) {
        final ActorRef gateway = this.self();
        CreateIvrEndpoint request = (CreateIvrEndpoint)message;
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new IvrEndpoint(gateway, session, MediaGateway.this.agent, MediaGateway.this.domain);
            }
        }));
    }

    private ActorRef getLink(Object message) {
        CreateLink request = (CreateLink)message;
        final ActorRef gateway = this.self();
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Link(gateway, session, MediaGateway.this.agent, MediaGateway.this.timeout);
            }
        }));
    }

    private ActorRef getPacketRelayEndpoint(Object message) {
        final ActorRef gateway = this.self();
        CreatePacketRelayEndpoint request = (CreatePacketRelayEndpoint)message;
        final MediaSession session = request.session();
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new PacketRelayEndpoint(gateway, session, MediaGateway.this.agent, MediaGateway.this.domain);
            }
        }));
    }

    private MediaSession getSession() {
        return new MediaSession((int)this.sessionIdPool.get());
    }

    private void powerOff(Object message) {
        try {
            this.provider.removeJainMgcpListener((JainMgcpListener)this);
            this.stack.deleteProvider(this.provider);
        }
        catch (DeleteProviderException exception) {
            this.logger.error((Throwable)exception, "Could not clean up the JAIN MGCP provider.");
        }
        this.name = null;
        this.localIp = null;
        this.localPort = 0;
        this.remoteIp = null;
        this.remotePort = 0;
        this.useNat = false;
        this.externalIp = null;
        this.timeout = 0L;
        this.provider = null;
        this.stack = null;
        this.agent = null;
        this.domain = null;
        this.responseListeners.clear();
        this.responseListeners = null;
        this.requestIdPool = null;
        this.sessionIdPool = null;
        this.transactionIdPool = null;
    }

    private void powerOn(Object message) {
        PowerOnMediaGateway request = (PowerOnMediaGateway)message;
        this.name = request.getName();
        this.localIp = request.getLocalIp();
        this.localPort = request.getLocalPort();
        this.remoteIp = request.getRemoteIp();
        this.remotePort = request.getRemotePort();
        this.useNat = request.useNat();
        this.externalIp = request.getExternalIp();
        this.timeout = request.getTimeout();
        this.stack = new JainMgcpStackImpl(this.localIp, this.localPort);
        try {
            this.provider = this.stack.createProvider();
            this.provider.addJainMgcpListener((JainMgcpListener)this);
        }
        catch (TooManyListenersException ignored) {
        }
        catch (CreateProviderException exception) {
            this.logger.error((Throwable)exception, "Could not create a JAIN MGCP provider.");
        }
        this.agent = new NotifiedEntity("restcomm", this.localIp.getHostAddress(), this.localPort);
        this.domain = this.remoteIp.getHostAddress() + ":" + this.remotePort;
        this.notificationListeners.clear();
        this.responseListeners.clear();
        this.requestIdPool = new RevolvingCounter(1L, Integer.MAX_VALUE);
        this.sessionIdPool = new RevolvingCounter(1L, Integer.MAX_VALUE);
        this.transactionIdPool = new RevolvingCounter(1L, Integer.MAX_VALUE);
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
        int value = event.getObjectIdentifier();
        switch (value) {
            case 108: {
                Notify notify = (Notify)event;
                String id = notify.getRequestIdentifier().toString();
                ActorRef listener = this.notificationListeners.remove(id);
                if (listener == null) break;
                listener.tell((Object)notify, this.self());
            }
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent event) {
        int id = event.getTransactionHandle();
        ActorRef listener = this.responseListeners.remove(id);
        if (listener != null) {
            listener.tell((Object)event, this.self());
        }
    }

    public void onReceive(Object message) throws Exception {
        UntypedActorContext context = this.getContext();
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (PowerOnMediaGateway.class.equals(klass)) {
            this.powerOn(message);
        } else if (PowerOffMediaGateway.class.equals(klass)) {
            this.powerOff(message);
        } else if (GetMediaGatewayInfo.class.equals(klass)) {
            sender.tell(new MediaGatewayResponse<MediaGatewayInfo>(this.getInfo(message)), sender);
        } else if (CreateConnection.class.equals(klass)) {
            sender.tell(new MediaGatewayResponse<ActorRef>(this.getConnection(message)), self);
        } else if (CreateLink.class.equals(klass)) {
            sender.tell(new MediaGatewayResponse<ActorRef>(this.getLink(message)), self);
        } else if (CreateMediaSession.class.equals(klass)) {
            sender.tell(new MediaGatewayResponse<MediaSession>(this.getSession()), self);
        } else if (CreateBridgeEndpoint.class.equals(klass)) {
            ActorRef endpoint = this.getBridgeEndpoint(message);
            sender.tell(new MediaGatewayResponse<ActorRef>(endpoint), self);
        } else if (CreatePacketRelayEndpoint.class.equals(klass)) {
            ActorRef endpoint = this.getPacketRelayEndpoint(message);
            sender.tell(new MediaGatewayResponse<ActorRef>(endpoint), self);
        } else if (CreateIvrEndpoint.class.equals(klass)) {
            ActorRef endpoint = this.getIvrEndpoint(message);
            sender.tell(new MediaGatewayResponse<ActorRef>(endpoint), self);
        } else if (CreateConferenceEndpoint.class.equals(klass)) {
            ActorRef endpoint = this.getConferenceEndpoint(message);
            sender.tell(new MediaGatewayResponse<ActorRef>(endpoint), self);
        } else if (DestroyConnection.class.equals(klass)) {
            DestroyConnection request = (DestroyConnection)message;
            if (request.connection() != null) {
                context.stop(request.connection());
            }
        } else if (DestroyLink.class.equals(klass)) {
            DestroyLink request = (DestroyLink)message;
            context.stop(request.link());
        } else if (DestroyEndpoint.class.equals(klass)) {
            DestroyEndpoint request = (DestroyEndpoint)message;
            this.logger.info("Gateway: " + this.self().path() + " about to stop endpoint path: " + request.endpoint().path() + " isTerminated: " + request.endpoint().isTerminated() + " sender: " + this.sender().path());
            context.stop(request.endpoint());
        } else if (message instanceof JainMgcpCommandEvent) {
            this.send(message, sender);
        } else if (message instanceof JainMgcpResponseEvent) {
            this.send(message);
        }
    }

    private void send(Object message, ActorRef sender) {
        JainMgcpCommandEvent command = (JainMgcpCommandEvent)message;
        int transactionId = (int)this.transactionIdPool.get();
        command.setTransactionHandle(transactionId);
        this.responseListeners.put(transactionId, sender);
        if (NotificationRequest.class.equals(command.getClass())) {
            NotificationRequest request = (NotificationRequest)command;
            String id = Long.toString(this.requestIdPool.get());
            request.getRequestIdentifier().setRequestIdentifier(id);
            this.notificationListeners.put(id, sender);
        }
        this.provider.sendMgcpEvents(new JainMgcpEvent[]{command});
    }

    private void send(Object message) {
        JainMgcpResponseEvent response = (JainMgcpResponseEvent)message;
        this.provider.sendMgcpEvents(new JainMgcpEvent[]{response});
    }
}

