/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mgcp;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.mgcp.CloseLink;
import org.mobicents.servlet.restcomm.mgcp.EndpointCredentials;
import org.mobicents.servlet.restcomm.mgcp.InitializeLink;
import org.mobicents.servlet.restcomm.mgcp.InviteEndpoint;
import org.mobicents.servlet.restcomm.mgcp.LinkStateChanged;
import org.mobicents.servlet.restcomm.mgcp.MediaSession;
import org.mobicents.servlet.restcomm.mgcp.OpenLink;
import org.mobicents.servlet.restcomm.mgcp.UpdateEndpointId;
import org.mobicents.servlet.restcomm.mgcp.UpdateLink;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import scala.concurrent.duration.Duration;

public final class Link
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State uninitialized;
    private final State closed;
    private final State open;
    private final State initializingPrimary;
    private final State initializingSecondary;
    private final State closingPrimary;
    private final State closingSecondary;
    private final State opening;
    private final State modifying;
    private final FiniteStateMachine fsm;
    private final ActorRef gateway;
    private final MediaSession session;
    private final NotifiedEntity agent;
    private final long timeout;
    private final List<ActorRef> observers;
    private ActorRef primaryEndpoint;
    private ActorRef secondaryEndpoint;
    private EndpointIdentifier primaryEndpointId;
    private EndpointIdentifier secondaryEndpointId;
    private ConnectionIdentifier primaryConnId;
    private ConnectionIdentifier secondaryConnId;

    public Link(ActorRef gateway, MediaSession session, NotifiedEntity agent, long timeout) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.closed = new State("closed", (Action)new ClosedAction(source), null);
        this.open = new State("open", (Action)new OpenAction(source), null);
        this.initializingPrimary = new State("initializing primary", (Action)new InitializingPrimary(source), null);
        this.initializingSecondary = new State("initializing secondary", (Action)new EnteringInitializingSecondary(source), (Action)new ExitingInitializingSecondary(source));
        this.closingPrimary = new State("closing primary", (Action)new ClosingPrimary(source), null);
        this.closingSecondary = new State("closing secondary", (Action)new ClosingSecondary(source), null);
        this.opening = new State("opening", (Action)new Opening(source), null);
        this.modifying = new State("modifying", (Action)new Modifying(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.initializingPrimary));
        transitions.add(new Transition(this.uninitialized, this.closed));
        transitions.add(new Transition(this.closed, this.opening));
        transitions.add(new Transition(this.open, this.closingPrimary));
        transitions.add(new Transition(this.open, this.modifying));
        transitions.add(new Transition(this.open, this.closed));
        transitions.add(new Transition(this.initializingPrimary, this.initializingSecondary));
        transitions.add(new Transition(this.initializingPrimary, this.closingPrimary));
        transitions.add(new Transition(this.initializingSecondary, this.closed));
        transitions.add(new Transition(this.closingPrimary, this.closingSecondary));
        transitions.add(new Transition(this.closingSecondary, this.closed));
        transitions.add(new Transition(this.opening, this.closed));
        transitions.add(new Transition(this.opening, this.open));
        transitions.add(new Transition(this.modifying, this.open));
        transitions.add(new Transition(this.modifying, this.closingPrimary));
        transitions.add(new Transition(this.closingPrimary, this.closed));
        transitions.add(new Transition(this.modifying, this.closed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.gateway = gateway;
        this.session = session;
        this.agent = agent;
        this.timeout = timeout;
        this.observers = new ArrayList<ActorRef>();
        this.primaryConnId = null;
        this.secondaryConnId = null;
    }

    private void observe(Object message) {
        ActorRef self = this.self();
        Observe request = (Observe)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        if (Observe.class.equals(klass)) {
            this.observe(message);
        } else if (StopObserving.class.equals(klass)) {
            this.stopObserving(message);
        } else if (InitializeLink.class.equals(klass)) {
            this.logger.info("Link: " + this.self().path() + " ,received InitializeLink message from sender: " + this.sender().path());
            this.fsm.transition(message, this.initializingPrimary);
        } else if (EndpointCredentials.class.equals(klass)) {
            if (this.initializingPrimary.equals((Object)state)) {
                this.fsm.transition(message, this.initializingSecondary);
            } else if (this.initializingSecondary.equals((Object)state)) {
                this.fsm.transition(message, this.closed);
            }
        } else if (OpenLink.class.equals(klass)) {
            this.fsm.transition(message, this.opening);
        } else if (UpdateLink.class.equals(klass)) {
            this.fsm.transition(message, this.modifying);
        } else if (CloseLink.class.equals(klass)) {
            if (!this.closingPrimary.equals((Object)state)) {
                this.fsm.transition(message, this.closingPrimary);
            }
        } else if (message instanceof JainMgcpResponseEvent) {
            JainMgcpResponseEvent response = (JainMgcpResponseEvent)message;
            int code = response.getReturnCode().getValue();
            if (code == 100) {
                return;
            }
            if (code == 200) {
                if (this.opening.equals((Object)state)) {
                    this.fsm.transition(message, this.open);
                } else if (this.closingPrimary.equals((Object)state)) {
                    this.fsm.transition(message, this.closingSecondary);
                } else if (this.closingSecondary.equals((Object)state)) {
                    this.fsm.transition(message, this.closed);
                } else if (this.modifying.equals((Object)state)) {
                    this.fsm.transition(message, this.open);
                }
            } else if (this.modifying.equals((Object)state)) {
                this.fsm.transition(message, this.closingPrimary);
            } else {
                this.fsm.transition(message, this.closed);
            }
        } else if (message instanceof ReceiveTimeout) {
            this.fsm.transition(message, this.closed);
        }
    }

    private void stopObserving(Object message) {
        StopObserving request = (StopObserving)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private final class Opening
    extends AbstractAction {
        public Opening(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            OpenLink request = (OpenLink)message;
            String sessionId = Integer.toString(Link.this.session.id());
            CallIdentifier callId = new CallIdentifier(sessionId);
            CreateConnection crcx = new CreateConnection((Object)this.source, callId, Link.this.primaryEndpointId, request.mode());
            crcx.setNotifiedEntity(Link.this.agent);
            crcx.setSecondEndpointIdentifier(Link.this.secondaryEndpointId);
            Link.this.gateway.tell((Object)crcx, this.source);
            Link.this.getContext().setReceiveTimeout((Duration)Duration.create((long)Link.this.timeout, (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    private final class Modifying
    extends AbstractAction {
        public Modifying(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UpdateLink request = (UpdateLink)message;
            String sessionId = Integer.toString(Link.this.session.id());
            CallIdentifier callId = new CallIdentifier(sessionId);
            ModifyConnection mdcx = null;
            switch (request.type()) {
                case PRIMARY: {
                    mdcx = new ModifyConnection((Object)this.source, callId, Link.this.primaryEndpointId, Link.this.primaryConnId);
                }
                case SECONDARY: {
                    mdcx = new ModifyConnection((Object)this.source, callId, Link.this.secondaryEndpointId, Link.this.secondaryConnId);
                }
            }
            ConnectionMode mode = request.mode();
            if (mode != null) {
                mdcx.setMode(mode);
            }
            Link.this.gateway.tell(mdcx, this.source);
            Link.this.getContext().setReceiveTimeout((Duration)Duration.create((long)Link.this.timeout, (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    private final class ClosingSecondary
    extends AbstractAction {
        public ClosingSecondary(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UntypedActorContext context = Link.this.getContext();
            context.setReceiveTimeout((Duration)Duration.Undefined());
            String sessionId = Integer.toString(Link.this.session.id());
            CallIdentifier callId = new CallIdentifier(sessionId);
            DeleteConnection dlcx = new DeleteConnection((Object)this.source, callId, Link.this.secondaryEndpointId, Link.this.secondaryConnId);
            Link.this.gateway.tell((Object)dlcx, this.source);
            Link.this.getContext().setReceiveTimeout((Duration)Duration.create((long)Link.this.timeout, (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    private final class ClosingPrimary
    extends AbstractAction {
        public ClosingPrimary(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String sessionId = Integer.toString(Link.this.session.id());
            CallIdentifier callId = new CallIdentifier(sessionId);
            DeleteConnection dlcx = new DeleteConnection((Object)this.source, callId, Link.this.primaryEndpointId, Link.this.primaryConnId);
            Link.this.gateway.tell((Object)dlcx, this.source);
            Link.this.getContext().setReceiveTimeout((Duration)Duration.create((long)Link.this.timeout, (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    private final class ExitingInitializingSecondary
    extends AbstractAction {
        public ExitingInitializingSecondary(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            EndpointCredentials response = (EndpointCredentials)message;
            Link.this.secondaryEndpointId = response.endpointId();
        }
    }

    private final class EnteringInitializingSecondary
    extends AbstractAction {
        public EnteringInitializingSecondary(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            EndpointCredentials response = (EndpointCredentials)message;
            Link.this.primaryEndpointId = response.endpointId();
            if (Link.this.secondaryEndpoint != null) {
                Link.this.secondaryEndpoint.tell((Object)new InviteEndpoint(), this.source);
            }
            Link.this.logger.info("Link: " + Link.this.self().path() + " ,state: " + Link.this.fsm.state() + " ,primaryEndpointId: " + Link.this.primaryEndpointId + " ,secondaryEndpoint: " + Link.this.secondaryEndpoint.path() + " secondaryEndpoint isTerminated: " + Link.this.secondaryEndpoint.isTerminated());
        }
    }

    private final class InitializingPrimary
    extends AbstractAction {
        public InitializingPrimary(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            InitializeLink request = (InitializeLink)message;
            Link.this.primaryEndpoint = request.primaryEndpoint();
            Link.this.secondaryEndpoint = request.secondaryEndpoint();
            Link.this.logger.info("Link: " + Link.this.self().path() + " ,state: " + Link.this.fsm.state() + " ,primaryEndpoint: " + Link.this.primaryEndpoint.path() + " ,secondaryEndpoint: " + Link.this.secondaryEndpoint.path());
            if (Link.this.primaryEndpoint != null && !Link.this.primaryEndpoint.isTerminated()) {
                Link.this.primaryEndpoint.tell((Object)new InviteEndpoint(), this.source);
                Link.this.logger.info("Link: " + Link.this.self().path() + " ,state: " + Link.this.fsm.state() + " InviteEndpoint sent to primaryEndpoint: " + Link.this.primaryEndpoint.path());
            } else {
                Link.this.logger.info("Link: " + Link.this.self().path() + " ,state: " + Link.this.fsm.state() + " InviteEndpoint DIDN'T sent to primaryEndpoint: " + Link.this.primaryEndpoint.path() + " primaryEndpoint is Terminated: " + Link.this.primaryEndpoint.isTerminated());
            }
        }
    }

    private final class OpenAction
    extends AbstractAction {
        public OpenAction(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UntypedActorContext context = Link.this.getContext();
            context.setReceiveTimeout((Duration)Duration.Undefined());
            Class<?> klass = message.getClass();
            if (CreateConnectionResponse.class.equals(klass)) {
                CreateConnectionResponse response = (CreateConnectionResponse)message;
                if (Link.this.primaryConnId == null) {
                    Link.this.primaryConnId = response.getConnectionIdentifier();
                }
                if (Link.this.primaryEndpointId.getLocalEndpointName().endsWith("$")) {
                    Link.this.primaryEndpointId = response.getSpecificEndpointIdentifier();
                    Link.this.primaryEndpoint.tell((Object)new UpdateEndpointId(Link.this.primaryEndpointId), this.source);
                }
                if (Link.this.secondaryConnId == null) {
                    Link.this.secondaryConnId = response.getSecondConnectionIdentifier();
                }
                if (Link.this.secondaryEndpointId.getLocalEndpointName().endsWith("$")) {
                    Link.this.secondaryEndpointId = response.getSecondEndpointIdentifier();
                    Link.this.secondaryEndpoint.tell((Object)new UpdateEndpointId(Link.this.secondaryEndpointId), this.source);
                }
            }
            LinkStateChanged event = new LinkStateChanged(LinkStateChanged.State.OPEN);
            for (ActorRef observer : Link.this.observers) {
                observer.tell((Object)event, this.source);
            }
            this.log(LinkStateChanged.State.CLOSED);
        }
    }

    private final class ClosedAction
    extends AbstractAction {
        public ClosedAction(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UntypedActorContext context = Link.this.getContext();
            context.setReceiveTimeout((Duration)Duration.Undefined());
            LinkStateChanged event = new LinkStateChanged(LinkStateChanged.State.CLOSED);
            for (ActorRef observer : Link.this.observers) {
                observer.tell((Object)event, this.source);
            }
            this.log(LinkStateChanged.State.CLOSED);
            if (message instanceof ReceiveTimeout) {
                Link.this.logger.error("The media gateway failed to respond in the requested timout period.");
            }
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }

        protected void log(LinkStateChanged.State state) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n");
            switch (state) {
                case CLOSED: {
                    buffer.append("Closed a link");
                }
                case OPEN: {
                    buffer.append("Opened a link");
                }
            }
            if (Link.this.primaryConnId != null && Link.this.primaryEndpointId != null && Link.this.secondaryConnId != null && Link.this.secondaryEndpointId != null) {
                buffer.append(" with primary connection ID of ").append(Link.this.primaryConnId.toString());
                buffer.append(" secondary connection ID of ").append(Link.this.secondaryConnId.toString());
                buffer.append(" A primary endpoint ID of ").append(Link.this.primaryEndpointId.toString());
                buffer.append(" and a secondary endpoint ID of ").append(Link.this.secondaryEndpointId.toString());
            }
            Link.this.logger.debug(buffer.toString());
        }
    }
}

