/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mgcp;

import akka.actor.ActorRef;
import jain.protocol.ip.mgcp.JainIPMgcpException;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mobicents.protocols.mgcp.jain.pkg.AUMgcpEvent;
import org.mobicents.protocols.mgcp.jain.pkg.AUPackage;
import org.mobicents.servlet.restcomm.mgcp.EndpointCredentials;
import org.mobicents.servlet.restcomm.mgcp.GenericEndpoint;
import org.mobicents.servlet.restcomm.mgcp.InviteEndpoint;
import org.mobicents.servlet.restcomm.mgcp.IvrEndpointResponse;
import org.mobicents.servlet.restcomm.mgcp.MediaSession;
import org.mobicents.servlet.restcomm.mgcp.Play;
import org.mobicents.servlet.restcomm.mgcp.PlayCollect;
import org.mobicents.servlet.restcomm.mgcp.PlayRecord;
import org.mobicents.servlet.restcomm.mgcp.StopEndpoint;
import org.mobicents.servlet.restcomm.mgcp.UpdateEndpointId;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;

public final class IvrEndpoint
extends GenericEndpoint {
    private static final PackageName PACKAGE_NAME = AUPackage.AU;
    private static final RequestedEvent[] REQUESTED_EVENTS = new RequestedEvent[2];
    private static final String EMPTY_STRING;
    private static final String DEFAULT_REQUEST_ID = "0";
    private final NotifiedEntity agent;
    private final List<ActorRef> observers;

    public IvrEndpoint(ActorRef gateway, MediaSession session, NotifiedEntity agent, String domain) {
        super(gateway, session, agent, new EndpointIdentifier("mobicents/ivr/$", domain));
        this.agent = agent;
        this.observers = new ArrayList<ActorRef>();
    }

    private void send(Object message) {
        Class<?> klass = message.getClass();
        String parameters = message.toString();
        MgcpEvent event = null;
        if (Play.class.equals(klass)) {
            event = AUMgcpEvent.aupa.withParm(parameters);
        } else if (PlayCollect.class.equals(klass)) {
            event = AUMgcpEvent.aupc.withParm(parameters);
        } else if (PlayRecord.class.equals(klass)) {
            event = AUMgcpEvent.aupr.withParm(parameters);
        }
        EventName[] signal = new EventName[]{new EventName(PACKAGE_NAME, event)};
        RequestIdentifier requestId = new RequestIdentifier(DEFAULT_REQUEST_ID);
        NotificationRequest request = new NotificationRequest((Object)this.self(), this.id, requestId);
        request.setNotifiedEntity(this.agent);
        request.setRequestedEvents(REQUESTED_EVENTS);
        request.setSignalRequests(signal);
        this.gateway.tell((Object)request, this.self());
    }

    private void stop() {
        EventName[] signal = new EventName[]{new EventName(PACKAGE_NAME, AUMgcpEvent.aues)};
        RequestIdentifier requestId = new RequestIdentifier(DEFAULT_REQUEST_ID);
        NotificationRequest request = new NotificationRequest((Object)this.self(), this.id, requestId);
        request.setSignalRequests(signal);
        request.setNotifiedEntity(this.agent);
        request.setRequestedEvents(REQUESTED_EVENTS);
        this.gateway.tell((Object)request, this.self());
    }

    @Override
    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (Observe.class.equals(klass)) {
            Observe request = (Observe)message;
            ActorRef observer = request.observer();
            if (observer != null) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        } else if (StopObserving.class.equals(klass)) {
            StopObserving request = (StopObserving)message;
            ActorRef observer = request.observer();
            if (observer != null) {
                this.observers.remove(observer);
            }
        } else if (InviteEndpoint.class.equals(klass)) {
            EndpointCredentials credentials = new EndpointCredentials(this.id);
            sender.tell((Object)credentials, self);
        } else if (UpdateEndpointId.class.equals(klass)) {
            UpdateEndpointId request = (UpdateEndpointId)message;
            this.id = request.id();
        } else if (Play.class.equals(klass) || PlayCollect.class.equals(klass) || PlayRecord.class.equals(klass)) {
            this.send(message);
        } else if (StopEndpoint.class.equals(klass)) {
            this.stop();
        } else if (Notify.class.equals(klass)) {
            this.notification(message);
        } else if (NotificationRequestResponse.class.equals(klass)) {
            this.response(message);
        }
    }

    private void fail(int code) {
        ActorRef self = this.self();
        String error = Integer.toString(code);
        String message = "The IVR request failed with the following error code " + error;
        JainIPMgcpException exception = new JainIPMgcpException(message);
        IvrEndpointResponse response = new IvrEndpointResponse((Throwable)exception);
        for (ActorRef observer : this.observers) {
            observer.tell(response, self);
        }
    }

    private void response(Object message) {
        NotificationRequestResponse response = (NotificationRequestResponse)message;
        ReturnCode code = response.getReturnCode();
        if (!ReturnCode.Transaction_Executed_Normally.equals(code)) {
            int value = code.getValue();
            this.fail(value);
        }
    }

    private void notification(Object message) {
        Notify notification = (Notify)message;
        ActorRef self = this.self();
        NotifyResponse response = new NotifyResponse((Object)this, ReturnCode.Transaction_Executed_Normally);
        int transaction = notification.getTransactionHandle();
        response.setTransactionHandle(transaction);
        this.gateway.tell((Object)response, self);
        EventName[] observedEvents = notification.getObservedEvents();
        if (observedEvents.length == 1) {
            MgcpEvent event = observedEvents[0].getEventIdentifier();
            Map<String, String> parameters = this.parse(event.getParms());
            int code = Integer.parseInt(parameters.get("rc"));
            switch (code) {
                case 100: 
                case 326: 
                case 327: 
                case 328: 
                case 329: {
                    String digits = parameters.get("dc");
                    if (digits == null) {
                        digits = EMPTY_STRING;
                    }
                    IvrEndpointResponse<String> result = new IvrEndpointResponse<String>(digits);
                    for (ActorRef observer : this.observers) {
                        observer.tell(result, self);
                    }
                    break;
                }
                default: {
                    this.fail(code);
                }
            }
        }
    }

    private Map<String, String> parse(String input) {
        String[] tokens;
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String token : tokens = input.split(" ")) {
            String[] values = token.split("=");
            if (values.length == 1) {
                parameters.put(values[0], null);
                continue;
            }
            if (values.length != 2) continue;
            parameters.put(values[0], values[1]);
        }
        return parameters;
    }

    static {
        RequestedAction[] action = new RequestedAction[]{RequestedAction.NotifyImmediately};
        IvrEndpoint.REQUESTED_EVENTS[0] = new RequestedEvent(new EventName(PACKAGE_NAME, AUMgcpEvent.auoc), action);
        IvrEndpoint.REQUESTED_EVENTS[1] = new RequestedEvent(new EventName(PACKAGE_NAME, AUMgcpEvent.auof), action);
        EMPTY_STRING = new String();
    }
}

