/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.mgcp;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.mgcp.CloseConnection;
import org.mobicents.servlet.restcomm.mgcp.ConnectionStateChanged;
import org.mobicents.servlet.restcomm.mgcp.EndpointCredentials;
import org.mobicents.servlet.restcomm.mgcp.InitializeConnection;
import org.mobicents.servlet.restcomm.mgcp.InviteEndpoint;
import org.mobicents.servlet.restcomm.mgcp.MediaSession;
import org.mobicents.servlet.restcomm.mgcp.OpenConnection;
import org.mobicents.servlet.restcomm.mgcp.UpdateConnection;
import org.mobicents.servlet.restcomm.mgcp.UpdateEndpointId;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import scala.concurrent.duration.Duration;

public final class Connection
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State uninitialized;
    private final State closed;
    private final State halfOpen;
    private final State open;
    private final State initializing;
    private final State closing;
    private final State openingHalfWay;
    private final State opening;
    private final State modifying;
    private final FiniteStateMachine fsm;
    private final ActorRef gateway;
    private final MediaSession session;
    private final NotifiedEntity agent;
    private final long timeout;
    private final List<ActorRef> observers;
    private ActorRef endpoint;
    private EndpointIdentifier endpointId;
    private ConnectionIdentifier connId;
    private ConnectionDescriptor localDesc;
    private ConnectionDescriptor remoteDesc;

    public Connection(ActorRef gateway, MediaSession session, NotifiedEntity agent, long timeout) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.closed = new State("closed", (Action)new Closed(source), null);
        this.halfOpen = new State("half open", (Action)new HalfOpen(source), null);
        this.open = new State("open", (Action)new Open(source), null);
        this.initializing = new State("initializing", (Action)new EnteringInitialization(source), (Action)new ExitingInitialization(source));
        this.closing = new State("closing", (Action)new Closing(source), null);
        this.openingHalfWay = new State("opening halfway", (Action)new OpeningHalfWay(source), null);
        this.opening = new State("opening", (Action)new Opening(source), null);
        this.modifying = new State("modifying", (Action)new Modifying(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.initializing));
        transitions.add(new Transition(this.uninitialized, this.closed));
        transitions.add(new Transition(this.closed, this.openingHalfWay));
        transitions.add(new Transition(this.closed, this.opening));
        transitions.add(new Transition(this.halfOpen, this.closing));
        transitions.add(new Transition(this.halfOpen, this.modifying));
        transitions.add(new Transition(this.open, this.closing));
        transitions.add(new Transition(this.open, this.closed));
        transitions.add(new Transition(this.open, this.modifying));
        transitions.add(new Transition(this.initializing, this.closed));
        transitions.add(new Transition(this.closing, this.closed));
        transitions.add(new Transition(this.openingHalfWay, this.closed));
        transitions.add(new Transition(this.openingHalfWay, this.halfOpen));
        transitions.add(new Transition(this.opening, this.closed));
        transitions.add(new Transition(this.opening, this.open));
        transitions.add(new Transition(this.modifying, this.open));
        transitions.add(new Transition(this.modifying, this.closing));
        transitions.add(new Transition(this.modifying, this.closed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.gateway = gateway;
        this.session = session;
        this.agent = agent;
        this.timeout = timeout;
        this.observers = new ArrayList<ActorRef>();
        this.connId = null;
        this.localDesc = null;
        this.remoteDesc = null;
    }

    private void observe(Object message) {
        ActorRef self = this.self();
        Observe request = (Observe)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** Connection Current State: " + state.toString());
            this.logger.info(" ********** Connection Processing Message: " + klass.getName());
        }
        if (Observe.class.equals(klass)) {
            this.observe(message);
        } else if (StopObserving.class.equals(klass)) {
            this.stopObserving(message);
        } else if (InitializeConnection.class.equals(klass)) {
            this.fsm.transition(message, this.initializing);
        } else if (EndpointCredentials.class.equals(klass)) {
            this.fsm.transition(message, this.closed);
        } else if (OpenConnection.class.equals(klass)) {
            OpenConnection request = (OpenConnection)message;
            if (request.descriptor() == null) {
                this.fsm.transition(message, this.openingHalfWay);
            } else {
                this.fsm.transition(message, this.opening);
            }
        } else if (UpdateConnection.class.equals(klass)) {
            this.fsm.transition(message, this.modifying);
        } else if (CloseConnection.class.equals(klass)) {
            this.fsm.transition(message, this.closing);
        } else if (message instanceof JainMgcpResponseEvent) {
            JainMgcpResponseEvent response = (JainMgcpResponseEvent)message;
            int code = response.getReturnCode().getValue();
            if (code == 100) {
                return;
            }
            if (code == 200) {
                if (this.openingHalfWay.equals((Object)state)) {
                    this.fsm.transition(message, this.halfOpen);
                } else if (this.opening.equals((Object)state)) {
                    this.fsm.transition(message, this.open);
                } else if (this.closing.equals((Object)state)) {
                    this.fsm.transition(message, this.closed);
                } else if (this.modifying.equals((Object)state)) {
                    this.fsm.transition(message, this.open);
                }
            } else if (this.modifying.equals((Object)state)) {
                this.fsm.transition(message, this.closing);
            } else {
                this.fsm.transition(message, this.closed);
            }
        } else if (message instanceof ReceiveTimeout) {
            this.fsm.transition(message, this.closed);
        }
    }

    private void stopObserving(Object message) {
        StopObserving request = (StopObserving)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private final class Modifying
    extends AbstractAction {
        public Modifying(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            ConnectionDescriptor descriptor;
            UpdateConnection request = (UpdateConnection)message;
            String sessionId = Integer.toString(Connection.this.session.id());
            CallIdentifier callId = new CallIdentifier(sessionId);
            ModifyConnection mdcx = new ModifyConnection((Object)this.source, callId, Connection.this.endpointId, Connection.this.connId);
            ConnectionMode mode = request.mode();
            if (mode != null) {
                mdcx.setMode(mode);
            }
            if ((descriptor = request.descriptor()) != null) {
                mdcx.setRemoteConnectionDescriptor(descriptor);
                Connection.this.remoteDesc = descriptor;
            }
            Connection.this.gateway.tell((Object)mdcx, this.source);
            Connection.this.getContext().setReceiveTimeout((Duration)Duration.create((long)Connection.this.timeout, (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    private final class Opening
    extends AbstractOpeningAction {
        public Opening(ActorRef source) {
            super(source);
        }
    }

    private final class OpeningHalfWay
    extends AbstractOpeningAction {
        public OpeningHalfWay(ActorRef source) {
            super(source);
        }
    }

    private abstract class AbstractOpeningAction
    extends AbstractAction {
        public AbstractOpeningAction(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            OpenConnection request = (OpenConnection)message;
            String sessionId = Integer.toString(Connection.this.session.id());
            CallIdentifier callId = new CallIdentifier(sessionId);
            CreateConnection crcx = new CreateConnection((Object)this.source, callId, Connection.this.endpointId, request.mode());
            Connection.this.remoteDesc = request.descriptor();
            if (Connection.this.remoteDesc != null) {
                crcx.setRemoteConnectionDescriptor(Connection.this.remoteDesc);
            }
            crcx.setNotifiedEntity(Connection.this.agent);
            Connection.this.gateway.tell((Object)crcx, this.source);
            Connection.this.getContext().setReceiveTimeout((Duration)Duration.create((long)Connection.this.timeout, (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    private final class Closing
    extends AbstractAction {
        public Closing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String sessionId = Integer.toString(Connection.this.session.id());
            CallIdentifier callId = new CallIdentifier(sessionId);
            DeleteConnection dlcx = new DeleteConnection((Object)this.source, callId, Connection.this.endpointId, Connection.this.connId);
            Connection.this.gateway.tell((Object)dlcx, this.source);
            Connection.this.getContext().setReceiveTimeout((Duration)Duration.create((long)Connection.this.timeout, (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    private final class ExitingInitialization
    extends AbstractAction {
        public ExitingInitialization(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            EndpointCredentials response = (EndpointCredentials)message;
            Connection.this.endpointId = response.endpointId();
        }
    }

    private final class EnteringInitialization
    extends AbstractAction {
        public EnteringInitialization(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            InitializeConnection request = (InitializeConnection)message;
            Connection.this.endpoint = request.endpoint();
            if (Connection.this.endpoint != null) {
                InviteEndpoint invite = new InviteEndpoint();
                Connection.this.endpoint.tell((Object)invite, this.source);
            }
        }
    }

    private final class Open
    extends AbstractOpenAction {
        public Open(ActorRef source) {
            super(source);
        }

        @Override
        public void execute(Object message) throws Exception {
            UntypedActorContext context = Connection.this.getContext();
            context.setReceiveTimeout((Duration)Duration.Undefined());
            Class<?> klass = message.getClass();
            if (CreateConnectionResponse.class.equals(klass)) {
                super.execute(message);
            } else if (ModifyConnectionResponse.class.equals(klass)) {
                ModifyConnectionResponse response = (ModifyConnectionResponse)message;
                Connection.this.localDesc = response.getLocalConnectionDescriptor();
            }
            ConnectionStateChanged event = new ConnectionStateChanged(Connection.this.localDesc, ConnectionStateChanged.State.OPEN);
            for (ActorRef observer : Connection.this.observers) {
                observer.tell((Object)event, this.source);
            }
            this.log(ConnectionStateChanged.State.OPEN);
        }
    }

    private final class HalfOpen
    extends AbstractOpenAction {
        public HalfOpen(ActorRef source) {
            super(source);
        }

        @Override
        public void execute(Object message) throws Exception {
            super.execute(message);
            UntypedActorContext context = Connection.this.getContext();
            context.setReceiveTimeout((Duration)Duration.Undefined());
            ConnectionStateChanged event = new ConnectionStateChanged(Connection.this.localDesc, ConnectionStateChanged.State.HALF_OPEN);
            for (ActorRef observer : Connection.this.observers) {
                observer.tell((Object)event, this.source);
            }
            this.log(ConnectionStateChanged.State.HALF_OPEN);
        }
    }

    private abstract class AbstractOpenAction
    extends AbstractAction {
        public AbstractOpenAction(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            CreateConnectionResponse response = (CreateConnectionResponse)message;
            if (Connection.this.connId == null) {
                Connection.this.connId = response.getConnectionIdentifier();
            }
            Connection.this.localDesc = response.getLocalConnectionDescriptor();
            if (Connection.this.endpointId.getLocalEndpointName().endsWith("$")) {
                Connection.this.endpointId = response.getSpecificEndpointIdentifier();
                Connection.this.endpoint.tell((Object)new UpdateEndpointId(Connection.this.endpointId), this.source);
            }
        }
    }

    private final class Closed
    extends AbstractAction {
        public Closed(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UntypedActorContext context = Connection.this.getContext();
            context.setReceiveTimeout((Duration)Duration.Undefined());
            ConnectionStateChanged event = new ConnectionStateChanged(ConnectionStateChanged.State.CLOSED);
            for (ActorRef observer : Connection.this.observers) {
                observer.tell((Object)event, this.source);
            }
            this.log(ConnectionStateChanged.State.CLOSED);
            if (message instanceof ReceiveTimeout) {
                Connection.this.logger.error("The media gateway failed to respond in the requested timout period.");
            }
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }

        protected void log(ConnectionStateChanged.State state) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n");
            switch (state) {
                case CLOSED: {
                    buffer.append("Closed a connection");
                }
                case HALF_OPEN: {
                    buffer.append("Opened a connection halfway");
                }
                case OPEN: {
                    buffer.append("Opened a connection");
                }
            }
            if (Connection.this.connId != null && Connection.this.endpointId != null) {
                buffer.append(" with ID ").append(Connection.this.connId.toString()).append(" ");
                buffer.append("to an endpoint with ID ").append(Connection.this.endpointId.toString());
            }
            Connection.this.logger.debug(buffer.toString());
        }
    }
}

