/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.ss7;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.media.hardware.dahdi.Channel;
import org.mobicents.media.server.component.audio.AudioOutput;
import org.mobicents.media.server.component.oob.OOBOutput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.dtmf.DtmfTonesData;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class SS7Output
extends AbstractSink {
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private AudioFormat destinationFormat;
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    private Channel channel;
    private Formats formats;
    private Sender sender;
    private Processor dsp;
    private Scheduler scheduler;
    private static final int QUEUE_SIZE = 5;
    private static final int OOB_QUEUE_SIZE = 5;
    private ArrayList<Frame> queue = new ArrayList(5);
    private ArrayList<Frame> oobQueue = new ArrayList(5);
    private static final int SEND_SIZE = 32;
    private AudioOutput output;
    private OOBOutput oobOutput;
    private OOBTranslator oobTranslator;

    protected SS7Output(Scheduler scheduler, Channel channel, AudioFormat destinationFormat) {
        super("Output");
        this.channel = channel;
        this.destinationFormat = destinationFormat;
        this.sender = new Sender();
        this.scheduler = scheduler;
        this.output = new AudioOutput(scheduler, 1);
        this.output.join((AbstractSink)this);
        this.oobOutput = new OOBOutput(scheduler, 1);
        this.oobTranslator = new OOBTranslator();
        this.oobOutput.join((AbstractSink)this.oobTranslator);
    }

    public AudioOutput getAudioOutput() {
        return this.output;
    }

    public OOBOutput getOOBOutput() {
        return this.oobOutput;
    }

    public void activate() {
        this.output.start();
        this.oobOutput.start();
    }

    public void deactivate() {
        this.output.stop();
        this.oobOutput.stop();
    }

    public void setDsp(Processor dsp) {
        this.dsp = dsp;
    }

    public Processor getDsp() {
        return this.dsp;
    }

    public void start() {
        super.start();
        this.sender.submit();
    }

    public void stop() {
        super.stop();
        this.sender.cancel();
    }

    public void setFormats(Formats formats) throws FormatNotSupportedException {
    }

    public void setDestinationFormat(AudioFormat destinationFormat) {
        this.destinationFormat = destinationFormat;
    }

    public void onMediaTransfer(Frame frame) throws IOException {
        if (this.dsp != null && this.destinationFormat != null) {
            try {
                frame = this.dsp.process(frame, (Format)this.format, (Format)this.destinationFormat);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        if (this.queue.size() >= 5) {
            this.queue.remove(0);
        }
        this.queue.add(frame);
    }

    private class OOBTranslator
    extends AbstractSink {
        private byte currTone;
        private long latestSeq;
        private int seqNumber;
        private boolean hasEndOfEvent;
        private long endSeq;
        byte[] data;

        public OOBTranslator() {
            super("oob translator");
            this.currTone = (byte)-1;
            this.latestSeq = 0L;
            this.seqNumber = 1;
            this.hasEndOfEvent = false;
            this.endSeq = 0L;
            this.data = new byte[4];
        }

        public void onMediaTransfer(Frame buffer) throws IOException {
            byte[] data = buffer.getData();
            if (data.length != 4) {
                return;
            }
            boolean endOfEvent = false;
            boolean bl = endOfEvent = (data[1] & 0x80) != 0;
            if (endOfEvent) {
                this.hasEndOfEvent = true;
                this.endSeq = buffer.getSequenceNumber();
                return;
            }
            if (this.currTone == data[0]) {
                if (this.hasEndOfEvent) {
                    if (buffer.getSequenceNumber() <= this.endSeq && buffer.getSequenceNumber() > this.endSeq - 8L) {
                        return;
                    }
                } else if (buffer.getSequenceNumber() < this.latestSeq + 8L && buffer.getSequenceNumber() > this.latestSeq - 8L) {
                    if (buffer.getSequenceNumber() > this.latestSeq) {
                        this.latestSeq = buffer.getSequenceNumber();
                    }
                    return;
                }
            }
            this.hasEndOfEvent = false;
            this.endSeq = 0L;
            this.latestSeq = buffer.getSequenceNumber();
            this.currTone = data[0];
            for (int i = 0; i < 5; ++i) {
                Frame currFrame = Memory.allocate((int)SS7Output.this.packetSize);
                currFrame.setHeader(null);
                currFrame.setSequenceNumber((long)this.seqNumber++);
                currFrame.setTimestamp(System.currentTimeMillis());
                currFrame.setLength(SS7Output.this.packetSize);
                currFrame.setDuration(20000000L);
                currFrame.setOffset(0);
                currFrame.setLength(SS7Output.this.packetSize);
                System.arraycopy(DtmfTonesData.buffer[data[0]], i * SS7Output.this.packetSize, currFrame.getData(), 0, SS7Output.this.packetSize);
                if (SS7Output.this.dsp != null && SS7Output.this.destinationFormat != null) {
                    try {
                        currFrame = SS7Output.this.dsp.process(currFrame, (Format)SS7Output.this.format, (Format)SS7Output.this.destinationFormat);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        e.printStackTrace();
                        return;
                    }
                }
                SS7Output.this.oobQueue.add(currFrame);
            }
        }

        public void activate() {
        }

        public void deactivate() {
        }
    }

    private class Sender
    extends Task {
        private Frame currFrame = null;
        private byte[] smallBuffer = new byte[32];
        int framePosition = 0;
        int readCount = 0;

        public int getQueueNumber() {
            SS7Output.this.scheduler;
            return Scheduler.SENDER_QUEUE;
        }

        public void submit() {
            this.activate(false);
            Scheduler scheduler = SS7Output.this.scheduler;
            SS7Output.this.scheduler;
            scheduler.submit((Task)this, Scheduler.SENDER_QUEUE);
        }

        public long perform() {
            if (this.currFrame == null) {
                if (SS7Output.this.oobQueue.size() > 0) {
                    this.currFrame = (Frame)SS7Output.this.oobQueue.remove(0);
                    this.framePosition = 0;
                } else if (SS7Output.this.queue.size() > 0) {
                    this.currFrame = (Frame)SS7Output.this.queue.remove(0);
                    this.framePosition = 0;
                }
            }
            this.readCount = 0;
            if (this.currFrame != null) {
                byte[] data = this.currFrame.getData();
                if (this.framePosition + 32 < data.length) {
                    System.arraycopy(data, this.framePosition, this.smallBuffer, 0, 32);
                    this.readCount = 32;
                    this.framePosition += 32;
                } else if (this.framePosition < data.length - 1) {
                    System.arraycopy(data, this.framePosition, this.smallBuffer, 0, data.length - this.framePosition);
                    this.readCount = data.length - this.framePosition;
                    this.currFrame.recycle();
                    this.currFrame = null;
                    this.framePosition = 0;
                }
            }
            while (this.readCount < this.smallBuffer.length) {
                this.smallBuffer[this.readCount++] = 0;
            }
            try {
                SS7Output.this.channel.write(this.smallBuffer, this.readCount);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Scheduler scheduler = SS7Output.this.scheduler;
            SS7Output.this.scheduler;
            scheduler.submit((Task)this, Scheduler.SENDER_QUEUE);
            return 0L;
        }
    }
}

