/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.ss7;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.media.hardware.dahdi.Channel;
import org.mobicents.media.server.component.audio.AudioInput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class SS7Input
extends AbstractSource {
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    private AudioFormat sourceFormat;
    private Processor dsp;
    private Channel channel;
    private byte[] smallBuffer = new byte[32];
    private byte[] tempBuffer = new byte[160];
    private int currPosition = 0;
    private int seqNumber = 1;
    private int readBytes = 0;
    private int currIndex = 0;
    private ArrayList<Frame> framesBuffer = new ArrayList(2);
    private AudioInput input;

    protected SS7Input(Scheduler scheduler, Channel channel, AudioFormat sourceFormat) {
        super("input", scheduler, Scheduler.INPUT_QUEUE.intValue());
        this.channel = channel;
        this.sourceFormat = sourceFormat;
        this.input = new AudioInput(1, this.packetSize);
        this.connect((AbstractSink)this.input);
    }

    public AudioInput getAudioInput() {
        return this.input;
    }

    public void reset() {
        super.reset();
    }

    public void setDsp(Processor dsp) {
        this.dsp = dsp;
    }

    public Processor getDsp() {
        return this.dsp;
    }

    protected int getPacketsLost() {
        return 0;
    }

    public Frame evolve(long timestamp) {
        if (this.framesBuffer.size() > 0) {
            return this.framesBuffer.remove(0);
        }
        return null;
    }

    public void setSourceFormat(AudioFormat sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public void readData() {
        this.readBytes = 0;
        try {
            this.readBytes = this.channel.read(this.smallBuffer);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.readBytes == 0) {
            return;
        }
        this.currIndex = 0;
        if (this.currPosition + this.readBytes <= this.tempBuffer.length) {
            System.arraycopy(this.smallBuffer, 0, this.tempBuffer, this.currPosition, this.readBytes);
            this.currPosition += this.readBytes;
            this.currIndex = this.readBytes;
        } else {
            System.arraycopy(this.smallBuffer, 0, this.tempBuffer, this.currPosition, this.tempBuffer.length - this.currPosition);
            this.currPosition = this.tempBuffer.length;
            this.currIndex = this.tempBuffer.length - this.currPosition;
        }
        if (this.currPosition == this.tempBuffer.length) {
            Frame currFrame = Memory.allocate((int)this.tempBuffer.length);
            currFrame.setHeader(null);
            currFrame.setSequenceNumber((long)this.seqNumber++);
            currFrame.setTimestamp(System.currentTimeMillis());
            currFrame.setOffset(0);
            currFrame.setLength(this.tempBuffer.length);
            currFrame.setDuration(20000000L);
            System.arraycopy(this.tempBuffer, 0, currFrame.getData(), 0, this.tempBuffer.length);
            currFrame.setFormat((Format)this.sourceFormat);
            if (this.dsp != null && this.sourceFormat != null) {
                try {
                    currFrame = this.dsp.process(currFrame, (Format)this.sourceFormat, (Format)this.format);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            this.currPosition = 0;
            if (this.currIndex < this.readBytes) {
                System.arraycopy(this.smallBuffer, this.currIndex, this.tempBuffer, this.currPosition, this.readBytes - this.currIndex);
            }
            if (this.framesBuffer.size() > 1) {
                this.framesBuffer.remove(0);
            }
            this.framesBuffer.add(currFrame);
            this.onFill();
        }
    }

    public void onFill() {
        this.wakeup();
    }
}

