/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.io.ss7;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.hardware.dahdi.Channel;
import org.mobicents.media.hardware.dahdi.SelectorKeyImpl;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.io.ss7.ProtocolHandler;
import org.mobicents.media.server.io.ss7.SS7Input;
import org.mobicents.media.server.io.ss7.SS7Manager;
import org.mobicents.media.server.io.ss7.SS7Output;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;

public class SS7DataChannel {
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private AudioFormat g711a = FormatFactory.createAudioFormat((String)"pcma", (int)8000, (int)8, (int)1);
    private AudioFormat g711u = FormatFactory.createAudioFormat((String)"pcmu", (int)8000, (int)8, (int)1);
    private final long ssrc = System.currentTimeMillis();
    private Channel channel;
    private int channelID;
    private SS7Input input;
    private SS7Output output;
    private SS7Handler ss7Handler;
    private SS7Manager ss7Manager;
    private volatile long rxCount;
    private volatile long txCount;
    private Formats formats = new Formats();
    private Logger logger = Logger.getLogger(SS7DataChannel.class);
    private boolean isALaw = false;
    private boolean shouldLoop = false;
    private AudioComponent audioComponent;
    private OOBComponent oobComponent;

    public SS7DataChannel(SS7Manager ss7Manager, int dahdiChannelID, int audioChannelID, boolean isALaw) throws IOException {
        this.ss7Manager = ss7Manager;
        this.ss7Handler = new SS7Handler();
        this.channelID = dahdiChannelID;
        this.channel = ss7Manager.open(this.channelID);
        this.isALaw = isALaw;
        if (isALaw) {
            this.input = new SS7Input(ss7Manager.scheduler, this.channel, this.g711a);
            this.output = new SS7Output(ss7Manager.scheduler, this.channel, this.g711a);
        } else {
            this.input = new SS7Input(ss7Manager.scheduler, this.channel, this.g711u);
            this.output = new SS7Output(ss7Manager.scheduler, this.channel, this.g711u);
        }
        this.audioComponent = new AudioComponent(audioChannelID);
        this.audioComponent.addInput(this.input.getAudioInput());
        this.audioComponent.addOutput(this.output.getAudioOutput());
        this.oobComponent = new OOBComponent(audioChannelID);
        this.oobComponent.addOutput(this.output.getOOBOutput());
    }

    public AudioComponent getAudioComponent() {
        return this.audioComponent;
    }

    public OOBComponent getOOBComponent() {
        return this.oobComponent;
    }

    public void setOutputDsp(Processor dsp) {
        this.output.setDsp(dsp);
    }

    public void setInputDsp(Processor dsp) {
        this.input.setDsp(dsp);
    }

    public void setCodec(boolean isALaw) {
        this.isALaw = isALaw;
        this.channel.setCodec(isALaw);
        if (isALaw) {
            this.input.setSourceFormat(this.g711a);
            this.output.setDestinationFormat(this.g711a);
        } else {
            this.input.setSourceFormat(this.g711u);
            this.output.setDestinationFormat(this.g711u);
        }
    }

    public void bind() {
        this.ss7Manager.bind(this.channel, this.ss7Handler);
        this.channel.setCodec(this.isALaw);
        this.input.activate();
        this.output.activate();
        this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
        this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
    }

    public int getChannelID() {
        return this.channelID;
    }

    public void activateLoop() {
        this.input.deactivate();
        this.output.deactivate();
        this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
        this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
        this.shouldLoop = true;
    }

    public void deactivateLoop() {
        this.input.activate();
        this.output.activate();
        this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
        this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
        this.shouldLoop = false;
    }

    public boolean inLoop() {
        return this.shouldLoop;
    }

    public void close() {
        this.ss7Manager.unbind(this.channel);
        this.rxCount = 0L;
        this.txCount = 0L;
        this.input.deactivate();
        this.output.deactivate();
        this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
        this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
    }

    public int getPacketsLost() {
        return this.input.getPacketsLost();
    }

    public long getPacketsReceived() {
        return this.rxCount;
    }

    public long getPacketsTransmitted() {
        return this.txCount;
    }

    private class SS7Handler
    implements ProtocolHandler {
        private volatile boolean isReading = false;
        private volatile boolean isWritting;
        private int readBytes = 0;
        private byte[] smallBuffer = new byte[32];

        private SS7Handler() {
        }

        @Override
        public void receive(Channel channel) {
            if (!SS7DataChannel.this.shouldLoop) {
                SS7DataChannel.this.input.readData();
            } else {
                this.readBytes = 0;
                try {
                    this.readBytes = channel.read(this.smallBuffer);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (this.readBytes == 0) {
                    return;
                }
                while (this.readBytes < this.smallBuffer.length) {
                    this.smallBuffer[this.readBytes++] = 0;
                }
                try {
                    channel.write(this.smallBuffer, this.readBytes);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isReadable() {
            return !this.isReading;
        }

        @Override
        public boolean isWriteable() {
            return true;
        }

        protected void allowReading() {
            this.isReading = false;
        }

        @Override
        public void send(Channel channel) {
        }

        @Override
        public void setKey(SelectorKeyImpl key) {
        }
    }
}

