/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.asr;

import akka.actor.ActorRef;
import akka.actor.UntypedActor;
import com.iSpeech.SpeechResult;
import com.iSpeech.iSpeechRecognizer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.asr.AsrInfo;
import org.mobicents.servlet.restcomm.asr.AsrRequest;
import org.mobicents.servlet.restcomm.asr.AsrResponse;
import org.mobicents.servlet.restcomm.asr.GetAsrInfo;

public final class ISpeechAsr
extends UntypedActor
implements iSpeechRecognizer.SpeechRecognizerEvent {
    private static final Map<String, String> languages = new HashMap<String, String>();
    private final String key;
    private final boolean production;

    public ISpeechAsr(Configuration configuration) {
        this.key = configuration.getString("api-key");
        this.production = configuration.getBoolean("api-key[@production]");
    }

    private AsrInfo info() {
        return new AsrInfo(languages.keySet());
    }

    public void onReceive(Object message) throws Exception {
        block7: {
            Class<?> klass = message.getClass();
            ActorRef self = this.self();
            ActorRef sender = this.sender();
            if (AsrRequest.class.equals(klass)) {
                AsrRequest request = (AsrRequest)message;
                Map<String, Object> attributes = request.attributes();
                try {
                    if (attributes != null) {
                        sender.tell(new AsrResponse<String>(this.recognize(message), attributes), self);
                        break block7;
                    }
                    sender.tell(new AsrResponse<String>(this.recognize(message)), self);
                }
                catch (Exception exception) {
                    if (attributes != null) {
                        sender.tell(new AsrResponse(exception, attributes), self);
                        break block7;
                    }
                    sender.tell(new AsrResponse(exception), self);
                }
            } else if (GetAsrInfo.class.equals(klass)) {
                sender.tell(new AsrResponse<AsrInfo>(this.info()), self);
            }
        }
    }

    private String recognize(Object message) throws Exception {
        AsrRequest request = (AsrRequest)message;
        File file = request.file();
        String language = languages.get(request.language());
        iSpeechRecognizer recognizer = iSpeechRecognizer.getInstance((String)this.key, (boolean)this.production);
        recognizer.setFreeForm(3);
        recognizer.setLanguage(language);
        SpeechResult results = recognizer.startFileRecognize("audio/x-wav", file, (iSpeechRecognizer.SpeechRecognizerEvent)this);
        return results.Text;
    }

    public void stateChanged(int event, int value, Exception exception) {
        if (3 == event) {
            // empty if block
        }
    }

    static {
        languages.put("en", "en-US");
        languages.put("en-gb", "en-GB");
        languages.put("es", "es-ES");
        languages.put("it", "it-IT");
        languages.put("fr", "fr-FR");
        languages.put("pl", "pl-PL");
        languages.put("pt", "pt-PT");
    }
}

