/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReasonCode;
import jain.protocol.ip.mgcp.message.parms.RestartMethod;

public final class RestartInProgress
extends JainMgcpCommandEvent {
    private RestartMethod restartMethod = null;
    private int restartDelay = 0;
    private ReasonCode reasonCode = null;

    public RestartInProgress(Object source, EndpointIdentifier endpointIdentifier, RestartMethod restartMethod) throws IllegalArgumentException {
        super(source, endpointIdentifier, 109);
        this.setRestartMethod(restartMethod);
    }

    public void setRestartMethod(RestartMethod restartMethod) throws IllegalArgumentException {
        if (restartMethod == null) {
            throw new IllegalArgumentException("Restart method cannot be null-valued!");
        }
        this.restartMethod = restartMethod;
    }

    public RestartMethod getRestartMethod() {
        return this.restartMethod;
    }

    public void setRestartDelay(int restartDelay) throws IllegalArgumentException {
        if (restartDelay < 0 || restartDelay > 999999) {
            throw new IllegalArgumentException("Restart delay must be in the range 0 through 999999, inclusive!");
        }
        this.restartDelay = restartDelay;
    }

    public int getRestartDelay() {
        return this.restartDelay;
    }

    public void setReasonCode(ReasonCode reasonCode) {
        this.reasonCode = reasonCode;
    }

    public ReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public String toString() {
        String text = super.BuildCommandHeader("RSIP");
        if (this.reasonCode != null) {
            text = text + "E: " + this.reasonCode.toString() + "\n";
        }
        if (this.restartDelay != 0) {
            text = text + "RD: " + this.restartDelay + "\n";
        }
        if (this.restartMethod != null) {
            text = text + "RM: " + this.restartMethod.toString() + "\n";
        }
        return text;
    }
}

