/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;

public final class ModifyConnection
extends JainMgcpCommandEvent {
    private CallIdentifier callIdentifier = null;
    private ConnectionIdentifier connectionIdentifier = null;
    private BearerInformation bearerInformation = null;
    private LocalOptionValue[] localConnectionOptions = null;
    private ConnectionMode mode = null;
    private NotificationRequestParms notificationRequestParms = null;
    private NotifiedEntity notifiedEntity = null;
    private ConnectionDescriptor remoteConnectionDescriptor = null;

    public ModifyConnection(Object source, CallIdentifier callIdentifier, EndpointIdentifier endpointIdentifier, ConnectionIdentifier connectionIdentifier) throws IllegalArgumentException {
        super(source, endpointIdentifier, 106);
        this.setCallIdentifier(callIdentifier);
        this.setConnectionIdentifier(connectionIdentifier);
    }

    public void setCallIdentifier(CallIdentifier callIdentifier) throws IllegalArgumentException {
        if (callIdentifier == null) {
            throw new IllegalArgumentException("Call identifier cannot be null-valued!");
        }
        this.callIdentifier = callIdentifier;
    }

    public void setConnectionIdentifier(ConnectionIdentifier connectionIdentifier) throws IllegalArgumentException {
        if (connectionIdentifier == null) {
            throw new IllegalArgumentException("Connection identifier cannot be null-valued!");
        }
        this.connectionIdentifier = connectionIdentifier;
    }

    public void setNotifiedEntity(NotifiedEntity notifiedEntity) {
        this.notifiedEntity = notifiedEntity;
    }

    public void setLocalConnectionOptions(LocalOptionValue[] localConnectionOptions) {
        this.localConnectionOptions = localConnectionOptions;
    }

    public void setMode(ConnectionMode mode) {
        this.mode = mode;
    }

    public void setRemoteConnectionDescriptor(ConnectionDescriptor remoteConnectionDescriptor) {
        this.remoteConnectionDescriptor = remoteConnectionDescriptor;
    }

    public void setNotificationRequestParms(NotificationRequestParms notificationRequestParms) {
        this.notificationRequestParms = notificationRequestParms;
    }

    public void setBearerInformation(BearerInformation bearerInformation) {
        this.bearerInformation = bearerInformation;
    }

    public CallIdentifier getCallIdentifier() {
        return this.callIdentifier;
    }

    public ConnectionIdentifier getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    public LocalOptionValue[] getLocalConnectionOptions() {
        return this.localConnectionOptions;
    }

    public ConnectionMode getMode() {
        return this.mode;
    }

    public ConnectionDescriptor getRemoteConnectionDescriptor() {
        return this.remoteConnectionDescriptor;
    }

    public NotificationRequestParms getNotificationRequestParms() {
        return this.notificationRequestParms;
    }

    public BearerInformation getBearerInformation() {
        return this.bearerInformation;
    }

    public String toString() {
        String text = super.BuildCommandHeader("MDCX");
        if (this.callIdentifier != null) {
            text = text + "C: " + this.callIdentifier.toString() + "\n";
        }
        if (this.connectionIdentifier != null) {
            text = text + "I: " + this.connectionIdentifier.toString() + "\n";
        }
        if (this.bearerInformation != null) {
            text = text + "B: e:" + this.bearerInformation.toString() + "\n";
        }
        if (this.localConnectionOptions != null) {
            text = text + super.BuildListParmLine("L", this.localConnectionOptions);
        }
        if (this.mode != null) {
            text = text + "M: " + this.mode.toString() + "\n";
        }
        if (this.notificationRequestParms != null) {
            text = text + this.notificationRequestParms.toString();
        }
        if (this.notifiedEntity != null) {
            text = text + "N: " + this.notifiedEntity.toString() + "\n";
        }
        if (this.remoteConnectionDescriptor != null) {
            text = text + "\n" + this.remoteConnectionDescriptor.toString() + "\n";
        }
        return text;
    }
}

