/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.CapabilityValue;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReasonCode;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.RestartMethod;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;

public final class AuditEndpointResponse
extends JainMgcpResponseEvent {
    private BearerInformation bearerInformation = null;
    private CapabilityValue[] capabilities = null;
    private ConnectionIdentifier[] connectionIdentifiers = null;
    private EventName[] detectEvents = null;
    private DigitMap digitMap = null;
    private EventName[] eventStates = null;
    private NotifiedEntity notifiedEntity = null;
    private EventName[] observedEvents = null;
    private RequestedEvent[] requestedEvents = null;
    private RequestIdentifier requestIdentifier = null;
    private EventName[] signalRequests = null;
    private ReasonCode reasonCode = null;
    private RestartMethod restartMethod = null;
    private int restartDelay = 0;
    private EndpointIdentifier[] endpointIdentifierList = null;

    public AuditEndpointResponse(Object source, ReturnCode returnCode, EndpointIdentifier[] endpointIdentifierList) throws IllegalArgumentException {
        this(source, returnCode);
        this.setEndpointIdentifierList(endpointIdentifierList);
    }

    public AuditEndpointResponse(Object source, ReturnCode returnCode) throws IllegalArgumentException {
        super(source, returnCode, 202);
    }

    public void setEndpointIdentifierList(EndpointIdentifier[] endpointIdentifierList) throws IllegalArgumentException {
        if (endpointIdentifierList == null) {
            throw new IllegalArgumentException("List of endpoint identifiers cannot be null-valued!");
        }
        int i = 0;
        while (i < endpointIdentifierList.length) {
            if (endpointIdentifierList[i] == null) {
                throw new IllegalArgumentException("Entry " + i + " in the list of endpoint identifiers is null!");
            }
            ++i;
        }
        this.endpointIdentifierList = endpointIdentifierList;
    }

    public EndpointIdentifier[] getEndpointIdentifierList() {
        return this.endpointIdentifierList;
    }

    public void setRequestedEvents(RequestedEvent[] requestedEvents) {
        this.requestedEvents = requestedEvents;
    }

    public RequestedEvent[] getRequestedEvents() {
        return this.requestedEvents;
    }

    public void setDigitMap(DigitMap digitMap) {
        this.digitMap = digitMap;
    }

    public DigitMap getDigitMap() {
        return this.digitMap;
    }

    public void setSignalRequests(EventName[] signalRequests) {
        this.signalRequests = signalRequests;
    }

    public EventName[] getSignalRequests() {
        return this.signalRequests;
    }

    public void setRequestIdentifier(RequestIdentifier requestIdentifier) {
        this.requestIdentifier = requestIdentifier;
    }

    public RequestIdentifier getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public void setNotifiedEntity(NotifiedEntity notifiedEntity) {
        this.notifiedEntity = notifiedEntity;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    public void setConnectionIdentifiers(ConnectionIdentifier[] connectionIdentifiers) {
        this.connectionIdentifiers = connectionIdentifiers;
    }

    public ConnectionIdentifier[] getConnectionIdentifiers() {
        return this.connectionIdentifiers;
    }

    public void setDetectEvents(EventName[] detectEvents) {
        this.detectEvents = detectEvents;
    }

    public EventName[] getDetectEvents() {
        return this.detectEvents;
    }

    public void setObservedEvents(EventName[] observedEvents) {
        this.observedEvents = observedEvents;
    }

    public EventName[] getObservedEvents() {
        return this.observedEvents;
    }

    public void setEventStates(EventName[] eventStates) {
        this.eventStates = eventStates;
    }

    public EventName[] getEventStates() {
        return this.eventStates;
    }

    public void setBearerInformation(BearerInformation bearerInformation) {
        this.bearerInformation = bearerInformation;
    }

    public BearerInformation getBearerInformation() {
        return this.bearerInformation;
    }

    public void setRestartMethod(RestartMethod restartMethod) {
        this.restartMethod = restartMethod;
    }

    public RestartMethod getRestartMethod() {
        return this.restartMethod;
    }

    public void setRestartDelay(int restartDelay) throws IllegalArgumentException {
        if (restartDelay < 0 || restartDelay > 999999) {
            throw new IllegalArgumentException("Restart delay must be between 0 and 999999, inclusive!");
        }
        this.restartDelay = restartDelay;
    }

    public int getRestartDelay() {
        return this.restartDelay;
    }

    public void setReasonCode(ReasonCode reasonCode) {
        this.reasonCode = reasonCode;
    }

    public ReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public void setCapabilities(CapabilityValue[] capabilities) {
        this.capabilities = capabilities;
    }

    public CapabilityValue[] getCapabilities() {
        return this.capabilities;
    }

    public String toString() {
        String text = super.BuildResponseHeader();
        if (this.bearerInformation != null) {
            text = text + "B: e:" + this.bearerInformation.toString() + "\n";
        }
        if (this.capabilities != null) {
            text = text + super.BuildListParmLine("A", this.capabilities);
        }
        if (this.connectionIdentifiers != null) {
            text = text + super.BuildListParmLine("I", this.connectionIdentifiers);
        }
        if (this.detectEvents != null) {
            text = text + super.BuildListParmLine("T", this.detectEvents);
        }
        if (this.digitMap != null) {
            text = text + "D: " + this.digitMap.toString() + "\n";
        }
        if (this.eventStates != null) {
            text = text + super.BuildListParmLine("ES", this.eventStates);
        }
        if (this.notifiedEntity != null) {
            text = text + "N: " + this.notifiedEntity.toString() + "\n";
        }
        if (this.observedEvents != null) {
            text = text + super.BuildListParmLine("O", this.observedEvents);
        }
        if (this.requestedEvents != null) {
            text = text + super.BuildListParmLine("R", this.requestedEvents);
        }
        if (this.requestIdentifier != null) {
            text = text + "X: " + this.requestIdentifier.toString() + "\n";
        }
        if (this.signalRequests != null) {
            text = text + super.BuildListParmLine("S", this.signalRequests);
        }
        if (this.reasonCode != null) {
            text = text + "E: " + this.reasonCode.toString() + "\n";
        }
        if (this.restartMethod != null) {
            text = text + "RM: " + this.restartMethod.toString() + "\n";
        }
        if (this.restartDelay != 0) {
            text = text + "RD: " + this.restartDelay + "\n";
        }
        if (this.endpointIdentifierList != null) {
            text = text + super.BuildListParmLine("Z", this.endpointIdentifierList);
        }
        return text;
    }
}

