/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.ConsoleCommand;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.ConsoleOutput;
import org.jboss.aesh.console.InternalCommands;
import org.jboss.aesh.console.alias.Alias;
import org.jboss.aesh.console.alias.AliasCompletion;
import org.jboss.aesh.console.alias.AliasManager;
import org.jboss.aesh.console.helper.InterruptHandler;
import org.jboss.aesh.console.helper.Search;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.console.operator.ControlOperatorParser;
import org.jboss.aesh.console.operator.RedirectionCompletion;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.edit.EditMode;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.PasteManager;
import org.jboss.aesh.edit.ViEditMode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.EditAction;
import org.jboss.aesh.edit.actions.EditActionManager;
import org.jboss.aesh.edit.actions.Movement;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.edit.actions.PrevWordAction;
import org.jboss.aesh.history.FileHistory;
import org.jboss.aesh.history.History;
import org.jboss.aesh.history.InMemoryHistory;
import org.jboss.aesh.history.SearchDirection;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.undo.UndoAction;
import org.jboss.aesh.undo.UndoManager;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.FileUtils;
import org.jboss.aesh.util.LoggerUtil;
import org.jboss.aesh.util.Parser;

public class Console {
    private Buffer buffer;
    private Terminal terminal;
    private UndoManager undoManager;
    private PasteManager pasteManager;
    private EditMode editMode;
    private History history;
    private List<Completion> completionList;
    private Settings settings;
    private Search search;
    private Action prevAction;
    private ConsoleCommand command;
    private boolean displayCompletion;
    private boolean askDisplayCompletion;
    private boolean running;
    private StringBuilder redirectPipeOutBuffer;
    private StringBuilder redirectPipeErrBuffer;
    private List<ConsoleOperation> operations;
    private ConsoleOperation currentOperation;
    private AliasManager aliasManager;
    private StringBuilder multiLine;
    private Logger logger;
    private Pattern endsWithBackslashPattern;

    public Console() throws IOException {
        this(Settings.getInstance());
    }

    public Console(Settings settings) throws IOException {
        block4: {
            this.prevAction = Action.EDIT;
            this.displayCompletion = false;
            this.askDisplayCompletion = false;
            this.running = false;
            this.multiLine = new StringBuilder();
            this.logger = LoggerUtil.getLogger(this.getClass().getName());
            this.endsWithBackslashPattern = Pattern.compile(".*\\s\\\\$");
            this.reset(settings);
            if (settings.hasInterruptHook()) {
                try {
                    if (Class.forName("sun.misc.Signal") != null) {
                        new InterruptHandler(this).initInterrupt();
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!settings.isLogging()) break block4;
                    this.logger.log(Level.WARNING, "Class sun.misc.Signal was not found. No interrupt handling enabled.");
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void start() {
                try {
                    if (Settings.getInstance().isAliasEnabled()) {
                        Console.this.aliasManager.persist();
                    }
                    Settings.getInstance().getTerminal().reset();
                    Settings.getInstance().quit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void reset(Settings settings) throws IOException {
        if (this.running) {
            throw new RuntimeException("Cant reset an already running Console, must stop if first!");
        }
        if (Settings.getInstance().isLogging()) {
            this.logger.info("RESET");
        }
        if (Settings.getInstance().doReadInputrc()) {
            Config.parseInputrc(Settings.getInstance());
        }
        Config.readRuntimeProperties(Settings.getInstance());
        this.setTerminal(settings.getTerminal(), settings.getInputStream(), settings.getStdOut(), settings.getStdErr());
        this.editMode = settings.getFullEditMode();
        this.undoManager = new UndoManager();
        this.pasteManager = new PasteManager();
        this.buffer = new Buffer(null);
        this.history = settings.isHistoryPersistent() ? new FileHistory(settings.getHistoryFile().getAbsolutePath(), settings.getHistorySize()) : new InMemoryHistory(settings.getHistorySize());
        this.completionList = new ArrayList<Completion>();
        this.completionList.add(new RedirectionCompletion());
        if (Settings.getInstance().isAliasEnabled()) {
            this.aliasManager = new AliasManager(Settings.getInstance().getAliasFile());
            this.completionList.add(new AliasCompletion(this.aliasManager));
        }
        this.operations = new ArrayList<ConsoleOperation>();
        this.currentOperation = null;
        this.redirectPipeOutBuffer = new StringBuilder();
        this.redirectPipeErrBuffer = new StringBuilder();
        this.settings = settings;
        this.running = true;
    }

    private void setTerminal(Terminal term, InputStream in, OutputStream stdOut, OutputStream stdErr) {
        this.terminal = term;
        this.terminal.init(in, stdOut, stdErr);
    }

    public int getTerminalHeight() {
        return this.terminal.getHeight();
    }

    public int getTerminalWidth() {
        return this.terminal.getWidth();
    }

    public History getHistory() {
        return this.history;
    }

    public void pushToStdOut(String input) throws IOException {
        if (input != null && input.length() > 0) {
            if (this.currentOperation != null && ControlOperator.isRedirectionOut(this.currentOperation.getControlOperator())) {
                this.redirectPipeOutBuffer.append(input);
            } else {
                this.terminal.writeToStdOut(input);
            }
        }
    }

    public void pushToStdOut(char[] input) throws IOException {
        if (input != null && input.length > 0) {
            if (this.currentOperation != null && ControlOperator.isRedirectionOut(this.currentOperation.getControlOperator())) {
                this.redirectPipeOutBuffer.append(input);
            } else {
                this.terminal.writeToStdOut(input);
            }
        }
    }

    public void pushToStdErr(String input) throws IOException {
        if (input != null && input.length() > 0) {
            if (this.currentOperation != null && ControlOperator.isRedirectionErr(this.currentOperation.getControlOperator())) {
                this.redirectPipeErrBuffer.append(input);
            } else {
                this.terminal.writeToStdErr(input);
            }
        }
    }

    public void pushToStdErr(char[] input) throws IOException {
        if (input != null && input.length > 0) {
            if (this.currentOperation != null && ControlOperator.isRedirectionErr(this.currentOperation.getControlOperator())) {
                this.redirectPipeErrBuffer.append(input);
            } else {
                this.terminal.writeToStdErr(input);
            }
        }
    }

    public void addCompletion(Completion completion) {
        this.completionList.add(completion);
    }

    public void addCompletions(List<Completion> completionList) {
        this.completionList.addAll(completionList);
    }

    public void stop() throws IOException {
        this.settings.getInputStream().close();
        this.settings.setInputStream(null);
        this.terminal.reset();
        this.terminal = null;
        this.running = false;
    }

    protected void attachProcess(ConsoleCommand cc) throws IOException {
        this.command = cc;
    }

    private void detachProcess() throws IOException {
        this.command = null;
        this.terminal.writeToStdOut(this.buffer.getPrompt());
    }

    public ConsoleOutput read(String prompt) throws IOException {
        return this.read(prompt, null);
    }

    public ConsoleOutput read(String prompt, Character mask) throws IOException {
        ConsoleOutput output;
        if (!this.running) {
            throw new RuntimeException("Cant reuse a stopped Console before its reset again!");
        }
        if (this.currentOperation != null && (output = this.parseCurrentOperation()) != null) {
            return output;
        }
        this.buffer.reset(prompt, mask);
        if (this.command == null) {
            this.terminal.writeToStdOut(this.buffer.getPrompt());
        }
        this.search = null;
        while (true) {
            int[] in;
            if (this.command != null && !this.command.isAttached()) {
                this.detachProcess();
            }
            if ((in = this.terminal.read(this.settings.isReadAhead()))[0] == -1) {
                return null;
            }
            Operation operation = this.editMode.parseInput(in);
            operation.setInput(in);
            String result = null;
            if (this.command != null) {
                this.command.processOperation(operation);
            } else {
                result = this.parseOperation(operation, mask);
            }
            if (result == null) continue;
            if (mask == null && this.endsWithBackslashPattern.matcher(result).find()) {
                this.appendMultiLine(result.substring(0, result.length() - 1));
                ConsoleOutput tempOutput = this.read("> ");
                result = this.getMultiLine() + tempOutput.getBuffer();
                this.resetMultiLine();
            }
            this.operations = ControlOperatorParser.findAllControlOperators(result);
            ConsoleOutput output2 = this.parseOperations();
            if ((output2 = this.processInternalCommands(output2)).getBuffer() != null) {
                return output2;
            }
            this.buffer.reset(prompt, mask);
            this.terminal.writeToStdOut(this.buffer.getPrompt());
            this.search = null;
        }
    }

    private String parseOperation(Operation operation, Character mask) throws IOException {
        Action action = operation.getAction();
        if (this.askDisplayCompletion) {
            this.askDisplayCompletion = false;
            if ('y' == (char)operation.getInput()[0]) {
                this.displayCompletion = true;
                this.complete();
            } else {
                this.terminal.writeToStdOut(Config.getLineSeparator());
                this.terminal.writeToStdOut(this.buffer.getLineWithPrompt());
                this.syncCursor();
            }
        } else if (action == Action.EDIT) {
            this.writeChars(operation.getInput(), mask);
        } else if (mask != null) {
            if (action == Action.DELETE) {
                if (mask.charValue() == '\u0000') {
                    this.deleteWithMaskEnabled();
                } else {
                    this.performAction(EditActionManager.parseAction(operation, this.buffer.getCursor(), this.buffer.length()));
                }
            }
        } else if (action == Action.SEARCH && !this.settings.isHistoryDisabled()) {
            if (this.search == null) {
                this.search = new Search(operation, operation.getInput()[0]);
            } else {
                this.search.setOperation(operation);
                this.search.setInput(operation.getInput()[0]);
            }
            this.doSearch(this.search);
            if (this.search.isFinished()) {
                return this.search.getResult();
            }
        } else if (action == Action.MOVE || action == Action.DELETE || action == Action.CHANGE || action == Action.YANK) {
            this.performAction(EditActionManager.parseAction(operation, this.buffer.getCursor(), this.buffer.length()));
        } else if (action != Action.ABORT) {
            if (action == Action.CASE) {
                this.addActionToUndoStack();
                this.changeCase();
            } else if (action == Action.COMPLETE) {
                this.complete();
            } else if (action != Action.EXIT) {
                if (action == Action.HISTORY) {
                    if (operation.getMovement() == Movement.NEXT) {
                        this.getHistoryElement(true);
                    } else if (operation.getMovement() == Movement.PREV) {
                        this.getHistoryElement(false);
                    }
                } else if (action == Action.UNDO) {
                    this.undo();
                } else if (action == Action.PASTE_FROM_CLIPBOARD) {
                    this.addActionToUndoStack();
                } else if (action == Action.PASTE) {
                    if (operation.getMovement() == Movement.NEXT) {
                        this.doPaste(0, true);
                    } else {
                        this.doPaste(0, false);
                    }
                } else if (action == Action.CHANGE_EDITMODE) {
                    this.changeEditMode(operation.getMovement());
                } else if (action == Action.CLEAR) {
                    this.clear(true);
                } else if (action == Action.REPLACE) {
                    this.replace(operation.getInput()[0]);
                } else if (action == Action.NO_ACTION) {
                    // empty if block
                }
            }
        }
        if (action == Action.HISTORY && !this.settings.isHistoryDisabled()) {
            this.prevAction = action;
        }
        if (action == Action.NEWLINE) {
            this.clearUndoStack();
            if (mask == null) {
                this.addToHistory(this.buffer.getLine());
            }
            this.prevAction = Action.NEWLINE;
            this.printNewline();
            return this.buffer.getLineNoMask();
        }
        return null;
    }

    private void doSearch(Search search) throws IOException {
        switch (search.getOperation().getMovement()) {
            case PREV: {
                this.history.setSearchDirection(SearchDirection.REVERSE);
                search.setSearchTerm(new StringBuilder(this.buffer.getLine()));
                if (search.getSearchTerm().length() <= 0) break;
                search.setResult(this.history.search(search.getSearchTerm().toString()));
                break;
            }
            case NEXT: {
                this.history.setSearchDirection(SearchDirection.FORWARD);
                search.setSearchTerm(new StringBuilder(this.buffer.getLine()));
                if (search.getSearchTerm().length() <= 0) break;
                search.setResult(this.history.search(search.getSearchTerm().toString()));
                break;
            }
            case PREV_WORD: {
                this.history.setSearchDirection(SearchDirection.REVERSE);
                if (search.getSearchTerm().length() <= 0) break;
                search.setResult(this.history.search(search.getSearchTerm().toString()));
                break;
            }
            case NEXT_WORD: {
                this.history.setSearchDirection(SearchDirection.FORWARD);
                if (search.getSearchTerm().length() <= 0) break;
                search.setResult(this.history.search(search.getSearchTerm().toString()));
                break;
            }
            case PREV_BIG_WORD: {
                if (search.getSearchTerm().length() <= 0) break;
                search.getSearchTerm().deleteCharAt(search.getSearchTerm().length() - 1);
                break;
            }
            case ALL: {
                search.getSearchTerm().appendCodePoint(search.getInput());
                String tmpResult = this.history.search(search.getSearchTerm().toString());
                if (tmpResult == null) {
                    search.getSearchTerm().deleteCharAt(search.getSearchTerm().length() - 1);
                    break;
                }
                search.setResult(tmpResult);
                break;
            }
            case END: {
                if (search.getResult() != null) {
                    this.moveCursor(-this.buffer.getCursor());
                    this.setBufferLine(search.getResult());
                    this.redrawLine();
                    this.printNewline();
                    search.setResult(this.buffer.getLineNoMask());
                    search.setFinished(true);
                    return;
                }
                this.moveCursor(-this.buffer.getCursor());
                this.setBufferLine("");
                this.redrawLine();
                break;
            }
            case NEXT_BIG_WORD: {
                if (search.getResult() != null) {
                    this.moveCursor(-this.buffer.getCursor());
                    this.setBufferLine(search.getResult());
                    search.setResult(null);
                    break;
                }
                this.moveCursor(-this.buffer.getCursor());
                this.setBufferLine("");
            }
        }
        if (this.editMode.getCurrentAction() == Action.SEARCH) {
            if (search.getSearchTerm().length() == 0) {
                if (search.getResult() != null) {
                    this.printSearch("", search.getResult());
                } else {
                    this.printSearch("", "");
                }
            } else if (search.getResult() != null) {
                this.printSearch(search.getSearchTerm().toString(), search.getResult());
            }
        } else {
            this.redrawLine();
            this.terminal.writeToStdOut(Buffer.printAnsi(this.buffer.getPrompt().length() + 1 + "G"));
        }
    }

    private void changeEditMode(Movement movement) {
        if (this.editMode.getMode() == Mode.EMACS && movement == Movement.PREV) {
            Settings.getInstance().setEditMode(Mode.VI);
            Settings.getInstance().resetEditMode();
        } else if (this.editMode.getMode() == Mode.VI && movement == Movement.NEXT) {
            Settings.getInstance().setEditMode(Mode.EMACS);
            Settings.getInstance().resetEditMode();
        }
        this.editMode = Settings.getInstance().getFullEditMode();
    }

    private void getHistoryElement(boolean first) throws IOException {
        String fromHistory;
        if (this.settings.isHistoryDisabled()) {
            return;
        }
        if (this.prevAction == Action.NEWLINE) {
            this.history.setCurrent(this.buffer.getLine());
        }
        if ((fromHistory = first ? this.history.getNextFetch() : this.history.getPreviousFetch()) != null) {
            this.setBufferLine(fromHistory);
            this.moveCursor(-this.buffer.getCursor() + this.buffer.length());
            this.redrawLine();
        }
        this.prevAction = Action.HISTORY;
    }

    private void setBufferLine(String newLine) throws IOException {
        int currentRow;
        if (newLine.length() + this.buffer.getPrompt().length() >= this.getTerminalWidth() && newLine.length() >= this.buffer.getLine().length() && (currentRow = this.getCurrentRow()) > -1) {
            int cursorRow = this.buffer.getCursorWithPrompt() / this.getTerminalWidth();
            if (currentRow + newLine.length() / this.getTerminalWidth() - cursorRow >= this.getTerminalHeight()) {
                int numNewRows = currentRow + (newLine.length() + this.buffer.getPrompt().length()) / this.getTerminalWidth() - cursorRow - this.getTerminalHeight();
                if ((newLine.length() + this.buffer.getPrompt().length()) % this.getTerminalWidth() == 0) {
                    ++numNewRows;
                }
                if (numNewRows > 0) {
                    if (Settings.getInstance().isLogging()) {
                        int totalRows = (newLine.length() + this.buffer.getPrompt().length()) / this.getTerminalWidth() + 1;
                        this.logger.info("ADDING " + numNewRows + ", totalRows:" + totalRows + ", currentRow:" + currentRow + ", cursorRow:" + cursorRow);
                    }
                    this.terminal.writeToStdOut(Buffer.printAnsi(numNewRows + "S"));
                    this.terminal.writeToStdOut(Buffer.printAnsi(numNewRows + "A"));
                }
            }
        }
        this.buffer.setLine(newLine);
    }

    private void insertBufferLine(String insert, int position) throws IOException {
        int currentRow;
        if (insert.length() + this.buffer.totalLength() >= this.getTerminalWidth() && (currentRow = this.getCurrentRow()) > -1) {
            int newLine = insert.length() + this.buffer.totalLength();
            int cursorRow = this.buffer.getCursorWithPrompt() / this.getTerminalWidth();
            if (currentRow + newLine / this.getTerminalWidth() - cursorRow >= this.getTerminalHeight()) {
                int numNewRows = currentRow + newLine / this.getTerminalWidth() - cursorRow - this.getTerminalHeight();
                if ((insert.length() + this.buffer.totalLength()) % this.getTerminalWidth() == 0) {
                    ++numNewRows;
                }
                if (numNewRows > 0) {
                    this.terminal.writeToStdOut(Buffer.printAnsi(numNewRows + "S"));
                    this.terminal.writeToStdOut(Buffer.printAnsi(numNewRows + "A"));
                }
            }
        }
        this.buffer.insert(position, insert);
    }

    private void addToHistory(String line) {
        if (!this.settings.isHistoryDisabled()) {
            this.history.push(line);
        }
    }

    private void writeChars(int[] chars, Character mask) throws IOException {
        for (int c : chars) {
            this.writeChar(c, mask);
        }
    }

    private void writeChar(int c, Character mask) throws IOException {
        this.buffer.write((char)c);
        if (mask != null) {
            if (mask.charValue() != '\u0000') {
                this.terminal.writeToStdOut(mask.charValue());
            }
        } else {
            this.terminal.writeToStdOut((char)c);
        }
        if (this.buffer.getCursorWithPrompt() > this.getTerminalWidth() && this.buffer.getCursorWithPrompt() % this.getTerminalWidth() == 1) {
            this.terminal.writeToStdOut(' ');
            this.terminal.writeToStdOut('\r');
        }
        if (this.buffer.getCursor() < this.buffer.length()) {
            if (this.buffer.totalLength() > this.getTerminalWidth() && (this.buffer.totalLength() - 1) % this.getTerminalWidth() == 1) {
                int totalRows;
                int ansiCurrentRow = this.getCurrentRow();
                int currentRow = this.buffer.getCursorWithPrompt() / this.getTerminalWidth();
                if (currentRow > 0 && this.buffer.getCursorWithPrompt() % this.getTerminalWidth() == 0) {
                    --currentRow;
                }
                if ((totalRows = this.buffer.totalLength() / this.getTerminalWidth()) > 0 && this.buffer.totalLength() % this.getTerminalWidth() == 0) {
                    --totalRows;
                }
                if (ansiCurrentRow + (totalRows - currentRow) > this.getTerminalHeight()) {
                    this.terminal.writeToStdOut(Buffer.printAnsi("1S"));
                    this.terminal.writeToStdOut(Buffer.printAnsi("1A"));
                }
            }
            this.redrawLine();
        }
    }

    private void deleteWithMaskEnabled() throws IOException {
        if (this.buffer.getLineNoMask().length() > 0) {
            this.buffer.delete(this.buffer.getLineNoMask().length() - 1, this.buffer.getLineNoMask().length());
        }
    }

    private boolean performAction(EditAction action) throws IOException {
        action.doAction(this.buffer.getLine());
        if (action.getAction() == Action.MOVE) {
            this.moveCursor(action.getEnd() - action.getStart());
            return true;
        }
        if (action.getAction() == Action.DELETE || action.getAction() == Action.CHANGE) {
            this.addActionToUndoStack();
            if (action.getEnd() > action.getStart()) {
                if (action.getStart() != this.buffer.getCursor()) {
                    this.moveCursor(action.getStart() - this.buffer.getCursor());
                }
                this.addToPaste(this.buffer.getLine().substring(action.getStart(), action.getEnd()));
                this.buffer.delete(action.getStart(), action.getEnd());
            } else {
                this.addToPaste(this.buffer.getLine().substring(action.getEnd(), action.getStart()));
                this.buffer.delete(action.getEnd(), action.getStart());
                this.moveCursor(action.getEnd() - action.getStart());
            }
            if (this.editMode.getMode() == Mode.VI && this.buffer.getCursor() == this.buffer.length() && !((ViEditMode)this.editMode).isInEditMode()) {
                this.moveCursor(-1);
            }
            this.redrawLine();
        } else if (action.getAction() == Action.YANK) {
            if (action.getEnd() > action.getStart()) {
                this.addToPaste(this.buffer.getLine().substring(action.getStart(), action.getEnd()));
            } else {
                this.addToPaste(this.buffer.getLine().substring(action.getEnd(), action.getStart()));
            }
        }
        return true;
    }

    private void addActionToUndoStack() throws IOException {
        UndoAction ua = new UndoAction(this.buffer.getCursor(), this.buffer.getLine());
        this.undoManager.addUndo(ua);
    }

    private void clearUndoStack() {
        this.undoManager.clear();
    }

    private void addToPaste(String buffer) {
        this.pasteManager.addText(new StringBuilder(buffer));
    }

    private boolean doPaste(int index, boolean before) throws IOException {
        StringBuilder pasteBuffer = this.pasteManager.get(index);
        if (pasteBuffer == null) {
            return false;
        }
        this.addActionToUndoStack();
        if (before || this.buffer.getCursor() >= this.buffer.getLine().length()) {
            this.insertBufferLine(pasteBuffer.toString(), this.buffer.getCursor());
            this.redrawLine();
        } else {
            this.insertBufferLine(pasteBuffer.toString(), this.buffer.getCursor() + 1);
            this.redrawLine();
            this.moveCursor(1);
        }
        return true;
    }

    public final void moveCursor(int where) throws IOException {
        if (this.editMode.getMode() == Mode.VI && (this.editMode.getCurrentAction() == Action.MOVE || this.editMode.getCurrentAction() == Action.DELETE)) {
            this.terminal.writeToStdOut(this.buffer.move(where, this.getTerminalWidth(), true));
        } else {
            this.terminal.writeToStdOut(this.buffer.move(where, this.getTerminalWidth()));
        }
    }

    private void redrawLine() throws IOException {
        this.drawLine(this.buffer.getPrompt() + this.buffer.getLine());
    }

    private void drawLine(String line) throws IOException {
        if (line.length() > this.getTerminalWidth() || line.length() + Math.abs(this.buffer.getDelta()) > this.getTerminalWidth()) {
            int currentRow = 0;
            if (this.buffer.getCursorWithPrompt() > 0) {
                currentRow = this.buffer.getCursorWithPrompt() / this.getTerminalWidth();
            }
            if (currentRow > 0 && this.buffer.getCursorWithPrompt() % this.getTerminalWidth() == 0) {
                --currentRow;
            }
            if (Settings.getInstance().isLogging()) {
                this.logger.info("actualRow:" + this.getCurrentRow() + ", actualColumn:" + this.getCurrentColumn());
                this.logger.info("currentRow:" + currentRow + ", cursorWithPrompt:" + this.buffer.getCursorWithPrompt() + ", width:" + this.getTerminalWidth() + ", height:" + this.getTerminalHeight() + ", delta:" + this.buffer.getDelta() + ", buffer:" + this.buffer.getLine());
            }
            this.terminal.writeToStdOut(Buffer.printAnsi("s"));
            if (currentRow > 0) {
                for (int i = 0; i < currentRow; ++i) {
                    this.terminal.writeToStdOut(Buffer.printAnsi("A"));
                }
            }
            this.terminal.writeToStdOut(Buffer.printAnsi("0G"));
            this.terminal.writeToStdOut(line);
            if (this.buffer.getDelta() < 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i > this.buffer.getDelta(); --i) {
                    sb.append(' ');
                }
                this.terminal.writeToStdOut(sb.toString());
            }
            this.terminal.writeToStdOut(Buffer.printAnsi("u"));
        } else {
            this.terminal.writeToStdOut(Buffer.printAnsi("s"));
            this.terminal.writeToStdOut(Buffer.printAnsi("0G"));
            this.terminal.writeToStdOut(Buffer.printAnsi("2K"));
            this.terminal.writeToStdOut(line);
            this.terminal.writeToStdOut(Buffer.printAnsi("u"));
        }
    }

    private void printSearch(String searchTerm, String result) throws IOException {
        int cursor = result.indexOf(searchTerm);
        StringBuilder out = this.history.getSearchDirection() == SearchDirection.REVERSE ? new StringBuilder("(reverse-i-search) `") : new StringBuilder("(forward-i-search) `");
        out.append(searchTerm).append("': ");
        cursor += out.length();
        out.append(result);
        this.buffer.disablePrompt(true);
        this.moveCursor(-this.buffer.getCursor());
        this.terminal.writeToStdOut(ANSI.moveCursorToBeginningOfLine());
        this.setBufferLine(out.toString());
        this.moveCursor(cursor);
        this.drawLine(this.buffer.getLine());
        this.buffer.disablePrompt(false);
    }

    private void printNewline() throws IOException {
        this.moveCursor(this.buffer.totalLength());
        this.terminal.writeToStdOut(Config.getLineSeparator());
    }

    private void changeCase() throws IOException {
        if (this.buffer.changeCase()) {
            this.moveCursor(1);
            this.redrawLine();
        }
    }

    private void undo() throws IOException {
        UndoAction ua = this.undoManager.getNext();
        if (ua != null) {
            this.setBufferLine(ua.getBuffer());
            this.redrawLine();
            this.moveCursor(ua.getCursorPosition() - this.buffer.getCursor());
        }
    }

    private void complete() throws IOException {
        if (this.completionList.size() < 1) {
            return;
        }
        ArrayList<CompleteOperation> possibleCompletions = new ArrayList<CompleteOperation>();
        int pipeLinePos = 0;
        if (ControlOperatorParser.doStringContainPipeline(this.buffer.getLine())) {
            pipeLinePos = ControlOperatorParser.findLastPipelinePositionBeforeCursor(this.buffer.getLine(), this.buffer.getCursor());
            if (ControlOperatorParser.findLastRedirectionPositionBeforeCursor(this.buffer.getLine(), this.buffer.getCursor()) > pipeLinePos) {
                pipeLinePos = 0;
            }
        }
        for (Completion completion : this.completionList) {
            CompleteOperation co = pipeLinePos > 0 ? this.findAliases(this.buffer.getLine().substring(pipeLinePos, this.buffer.getCursor()), this.buffer.getCursor() - pipeLinePos) : this.findAliases(this.buffer.getLine(), this.buffer.getCursor());
            if (this.getMultiLine().length() > 0) {
                String multi = this.getMultiLine();
            } else {
                completion.complete(co);
            }
            if (co.getCompletionCandidates() == null || co.getCompletionCandidates().size() <= 0) continue;
            possibleCompletions.add(co);
        }
        if (Settings.getInstance().isLogging()) {
            this.logger.info("Found completions: " + possibleCompletions);
        }
        if (possibleCompletions.size() >= 1) {
            if (possibleCompletions.size() == 1 && ((CompleteOperation)possibleCompletions.get(0)).getCompletionCandidates().size() == 1) {
                this.displayCompletion(((CompleteOperation)possibleCompletions.get(0)).getCompletionCandidates().get(0), ((CompleteOperation)possibleCompletions.get(0)).getFormattedCompletionCandidates().get(0), ((CompleteOperation)possibleCompletions.get(0)).hasAppendSeparator(), ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
            } else {
                String startsWith = Parser.findStartsWithOperation(possibleCompletions);
                if (startsWith.length() > 0) {
                    this.displayCompletion("", startsWith, false, ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
                } else {
                    ArrayList<String> completions = new ArrayList<String>();
                    for (CompleteOperation co : possibleCompletions) {
                        completions.addAll(co.getCompletionCandidates());
                    }
                    if (completions.size() > 100) {
                        if (this.displayCompletion) {
                            this.displayCompletions(completions);
                            this.displayCompletion = false;
                        } else {
                            this.askDisplayCompletion = true;
                            this.terminal.writeToStdOut(Config.getLineSeparator() + "Display all " + completions.size() + " possibilities? (y or n)");
                        }
                    } else {
                        this.displayCompletions(completions);
                    }
                }
            }
        }
    }

    private void displayCompletion(String fullCompletion, String completion, boolean appendSpace, char separator) throws IOException {
        if (completion.startsWith(this.buffer.getLine())) {
            this.performAction(new PrevWordAction(this.buffer.getCursor(), Action.DELETE));
            this.buffer.write(completion);
            this.terminal.writeToStdOut(completion);
        } else {
            this.buffer.write(completion);
            this.terminal.writeToStdOut(completion);
        }
        if (appendSpace) {
            this.buffer.write(separator);
            this.terminal.writeToStdOut(separator);
        }
        this.redrawLine();
    }

    private void displayCompletions(List<String> completions) throws IOException {
        int oldCursorPos = this.buffer.getCursor();
        this.printNewline();
        this.buffer.setCursor(oldCursorPos);
        this.terminal.writeToStdOut(Parser.formatDisplayList(completions, this.terminal.getHeight(), this.terminal.getWidth()));
        this.terminal.writeToStdOut(this.buffer.getLineWithPrompt());
        this.syncCursor();
    }

    private void syncCursor() throws IOException {
        if (this.buffer.getCursor() != this.buffer.getLine().length()) {
            this.terminal.writeToStdOut(Buffer.printAnsi(Math.abs(this.buffer.getCursor() - this.buffer.getLine().length()) + "D"));
        }
    }

    private void replace(int rChar) throws IOException {
        this.addActionToUndoStack();
        this.buffer.replaceChar((char)rChar);
        this.redrawLine();
    }

    private int getCurrentRow() {
        if (this.settings.isAnsiConsole() && Config.isOSPOSIXCompatible()) {
            try {
                int row;
                this.terminal.writeToStdOut(ANSI.getCurrentCursorPos());
                StringBuilder builder = new StringBuilder(8);
                while ((row = this.terminal.read(false)[0]) > -1 && row != 82) {
                    if (row == 27 || row == 91) continue;
                    builder.append((char)row);
                }
                return Integer.parseInt(builder.substring(0, builder.indexOf(";")));
            }
            catch (Exception e) {
                if (this.settings.isLogging()) {
                    this.logger.log(Level.SEVERE, "Failed to find current row with ansi code: ", e);
                }
                return -1;
            }
        }
        return -1;
    }

    private int getCurrentColumn() {
        if (this.settings.isAnsiConsole() && Config.isOSPOSIXCompatible()) {
            try {
                int row;
                this.terminal.writeToStdOut(ANSI.getCurrentCursorPos());
                StringBuilder builder = new StringBuilder(8);
                while ((row = this.settings.getInputStream().read()) > -1 && row != 82) {
                    if (row == 27 || row == 91) continue;
                    builder.append((char)row);
                }
                return Integer.parseInt(builder.substring(builder.lastIndexOf(";") + 1, builder.length()));
            }
            catch (Exception e) {
                if (this.settings.isLogging()) {
                    this.logger.log(Level.SEVERE, "Failed to find current column with ansi code: ", e);
                }
                return -1;
            }
        }
        return -1;
    }

    public void clear() throws IOException {
        this.clear(false);
    }

    public void clear(boolean includeBuffer) throws IOException {
        if (!Config.isOSPOSIXCompatible()) {
            this.printNewline();
        }
        this.terminal.writeToStdOut(ANSI.clearScreen());
        this.terminal.writeToStdOut(Buffer.printAnsi("1;1H"));
        if (includeBuffer) {
            this.terminal.writeToStdOut(this.buffer.getLineWithPrompt());
        }
    }

    private ConsoleOutput parseCurrentOperation() throws IOException {
        if (this.currentOperation.getControlOperator() == ControlOperator.OVERWRITE_OUT || this.currentOperation.getControlOperator() == ControlOperator.OVERWRITE_ERR || this.currentOperation.getControlOperator() == ControlOperator.APPEND_OUT || this.currentOperation.getControlOperator() == ControlOperator.APPEND_ERR || this.currentOperation.getControlOperator() == ControlOperator.OVERWRITE_OUT_AND_ERR) {
            ConsoleOperation nextOperation = this.operations.remove(0);
            this.persistRedirection(nextOperation.getBuffer(), this.currentOperation.getControlOperator());
            if (nextOperation.getControlOperator() == ControlOperator.NONE) {
                this.redirectPipeErrBuffer = new StringBuilder();
                this.redirectPipeOutBuffer = new StringBuilder();
                this.currentOperation = null;
                return null;
            }
            this.redirectPipeErrBuffer = new StringBuilder();
            this.redirectPipeOutBuffer = new StringBuilder();
            this.currentOperation = nextOperation;
            return this.parseCurrentOperation();
        }
        if (this.currentOperation.getControlOperator() == ControlOperator.PIPE || this.currentOperation.getControlOperator() == ControlOperator.PIPE_OUT_AND_ERR) {
            return this.parseOperations();
        }
        if (this.currentOperation.getControlOperator() == ControlOperator.OVERWRITE_IN) {
            if (Settings.getInstance().isLogging()) {
                this.logger.info(this.settings.getName() + ": syntax error while reading token: '<'");
            }
            this.pushToStdErr(this.settings.getName() + ": syntax error while reading token: '<'");
            return null;
        }
        return null;
    }

    private ConsoleOutput parseOperations() throws IOException {
        ConsoleOutput output = null;
        ConsoleOperation op = this.operations.remove(0);
        if (op.getControlOperator() == ControlOperator.OVERWRITE_OUT || op.getControlOperator() == ControlOperator.OVERWRITE_ERR || op.getControlOperator() == ControlOperator.APPEND_OUT || op.getControlOperator() == ControlOperator.APPEND_ERR || op.getControlOperator() == ControlOperator.OVERWRITE_OUT_AND_ERR || op.getControlOperator() == ControlOperator.PIPE_OUT_AND_ERR || op.getControlOperator() == ControlOperator.PIPE) {
            if (this.operations.size() != 0) {
                this.currentOperation = op;
                output = new ConsoleOutput(op, this.redirectPipeOutBuffer.toString(), this.redirectPipeErrBuffer.toString());
            }
        } else if (op.getControlOperator() == ControlOperator.OVERWRITE_IN) {
            if (this.operations.size() > 0) {
                ConsoleOperation nextOperation = this.operations.remove(0);
                if (nextOperation.getBuffer().length() > 0) {
                    List<String> files = Parser.findAllWords(nextOperation.getBuffer());
                    this.currentOperation = new ConsoleOperation(nextOperation.getControlOperator(), op.getBuffer());
                    try {
                        output = new ConsoleOutput(new ConsoleOperation(nextOperation.getControlOperator(), op.getBuffer()), FileUtils.readFile(new File(Parser.switchEscapedSpacesToSpacesInWord(files.get(0)))), this.redirectPipeErrBuffer.toString());
                    }
                    catch (IOException ioe) {
                        this.pushToStdErr(this.settings.getName() + ": " + ioe.getMessage() + Config.getLineSeparator());
                        this.currentOperation = null;
                        output = new ConsoleOutput(new ConsoleOperation(ControlOperator.NONE, ""));
                    }
                } else {
                    if (Settings.getInstance().isLogging()) {
                        this.logger.info(this.settings.getName() + ": syntax error near unexpected token '<'" + Config.getLineSeparator());
                    }
                    this.pushToStdErr(this.settings.getName() + ": syntax error near unexpected token '<'" + Config.getLineSeparator());
                    this.currentOperation = null;
                    output = new ConsoleOutput(new ConsoleOperation(ControlOperator.NONE, ""));
                }
            } else {
                if (Settings.getInstance().isLogging()) {
                    this.logger.info(this.settings.getName() + ": syntax error near unexpected token 'newline'" + Config.getLineSeparator());
                }
                this.pushToStdErr(this.settings.getName() + ": syntax error near unexpected token 'newline'" + Config.getLineSeparator());
                this.currentOperation = null;
                output = new ConsoleOutput(new ConsoleOperation(ControlOperator.NONE, ""));
            }
        } else {
            this.currentOperation = null;
            output = new ConsoleOutput(op, this.redirectPipeOutBuffer.toString(), this.redirectPipeErrBuffer.toString());
        }
        if (this.redirectPipeOutBuffer.length() > 0) {
            this.redirectPipeOutBuffer = new StringBuilder();
        }
        if (this.redirectPipeErrBuffer.length() > 0) {
            this.redirectPipeErrBuffer = new StringBuilder();
        }
        return this.findAliases(output);
    }

    private ConsoleOutput processInternalCommands(ConsoleOutput output) throws IOException {
        if (output.getBuffer() != null) {
            if (this.settings.isAliasEnabled() && output.getBuffer().startsWith(InternalCommands.ALIAS.getCommand())) {
                String out = this.aliasManager.parseAlias(output.getBuffer());
                if (out != null) {
                    this.pushToStdOut(out);
                }
                return new ConsoleOutput(new ConsoleOperation(ControlOperator.NONE, null));
            }
            if (this.settings.isAliasEnabled() && output.getBuffer().startsWith(InternalCommands.UNALIAS.getCommand())) {
                String out = this.aliasManager.removeAlias(output.getBuffer());
                if (out != null) {
                    this.pushToStdOut(out);
                }
                return new ConsoleOutput(new ConsoleOperation(ControlOperator.NONE, null));
            }
        }
        return output;
    }

    private ConsoleOutput findAliases(ConsoleOutput operation) {
        String command;
        Alias alias;
        if (this.settings.isAliasEnabled() && (alias = this.aliasManager.getAlias(command = Parser.findFirstWord(operation.getBuffer()))) != null) {
            operation.setConsoleOperation(new ConsoleOperation(operation.getControlOperator(), alias.getValue() + operation.getBuffer().substring(command.length())));
        }
        return operation;
    }

    private CompleteOperation findAliases(String buffer, int cursor) {
        String command;
        Alias alias;
        if (this.settings.isAliasEnabled() && (alias = this.aliasManager.getAlias(command = Parser.findFirstWord(buffer))) != null) {
            return new CompleteOperation(alias.getValue() + buffer.substring(command.length()), cursor + (alias.getValue().length() - command.length()));
        }
        return new CompleteOperation(buffer, cursor);
    }

    private void persistRedirection(String fileName, ControlOperator redirection) throws IOException {
        List<String> fileNames = Parser.findAllWords(fileName);
        if (fileNames.size() > 1) {
            if (Settings.getInstance().isLogging()) {
                this.logger.info(this.settings.getName() + ": can't redirect to more than one file." + Config.getLineSeparator());
            }
            this.pushToStdErr(this.settings.getName() + ": can't redirect to more than one file." + Config.getLineSeparator());
            return;
        }
        fileName = fileNames.get(0);
        try {
            if (redirection == ControlOperator.OVERWRITE_OUT) {
                FileUtils.saveFile(new File(Parser.switchEscapedSpacesToSpacesInWord(fileName)), this.redirectPipeOutBuffer.toString(), false);
            } else if (redirection == ControlOperator.OVERWRITE_ERR) {
                FileUtils.saveFile(new File(Parser.switchEscapedSpacesToSpacesInWord(fileName)), this.redirectPipeErrBuffer.toString(), false);
            } else if (redirection == ControlOperator.APPEND_OUT) {
                FileUtils.saveFile(new File(Parser.switchEscapedSpacesToSpacesInWord(fileName)), this.redirectPipeOutBuffer.toString(), true);
            } else if (redirection == ControlOperator.APPEND_ERR) {
                FileUtils.saveFile(new File(Parser.switchEscapedSpacesToSpacesInWord(fileName)), this.redirectPipeErrBuffer.toString(), true);
            }
        }
        catch (IOException e) {
            if (Settings.getInstance().isLogging()) {
                this.logger.log(Level.SEVERE, "Saving file " + fileName + " to disk failed: ", e);
            }
            this.pushToStdErr(e.getMessage());
        }
        this.redirectPipeOutBuffer = new StringBuilder();
        this.redirectPipeErrBuffer = new StringBuilder();
    }

    private void appendMultiLine(String newLine) {
        this.multiLine.append(newLine);
    }

    private void resetMultiLine() {
        this.multiLine = new StringBuilder();
    }

    private String getMultiLine() {
        return this.multiLine.toString();
    }
}

