/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.catalina;

import org.apache.catalina.Engine;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.catalina.CatalinaConnector;
import org.jboss.modcluster.container.catalina.ConnectorFactory;
import org.jboss.modcluster.container.catalina.ProxyConnectorProvider;

public class AutoProxyConnectorProvider
implements ProxyConnectorProvider {
    @Override
    public Connector createProxyConnector(ConnectorFactory factory, Engine engine) {
        int highestMaxThreads = 0;
        Connector bestConnector = null;
        for (org.apache.catalina.connector.Connector connector : engine.getService().findConnectors()) {
            Connector catalinaConnector = factory.createConnector(connector);
            if (CatalinaConnector.isAJP(connector) || catalinaConnector.isReverse()) {
                return catalinaConnector;
            }
            int maxThreads = catalinaConnector.getMaxThreads();
            if (maxThreads <= highestMaxThreads) continue;
            highestMaxThreads = maxThreads;
            bestConnector = catalinaConnector;
        }
        if (bestConnector == null) {
            throw new IllegalStateException();
        }
        return bestConnector;
    }
}

