/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.openjpa;

import java.util.Map;
import org.jboss.as.jpa.openjpa.JBossPersistenceMetaDataFactory;
import org.jboss.as.jpa.spi.JtaManager;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class OpenJPAPersistenceProviderAdaptor
implements PersistenceProviderAdaptor {
    private static final String TRANSACTION_MODE = "openjpa.TransactionMode";
    private static final String MANAGED_RUNTIME = "openjpa.ManagedRuntime";
    private static final String METADATA_FACTORY = "openjpa.MetaDataFactory";

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        if (!pu.getProperties().containsKey(TRANSACTION_MODE)) {
            properties.put(TRANSACTION_MODE, "managed");
        }
        if (!pu.getProperties().containsKey(MANAGED_RUNTIME)) {
            properties.put(MANAGED_RUNTIME, "jndi(TransactionManagerName=java:jboss/TransactionManager)");
        }
        if (!pu.getProperties().containsKey(METADATA_FACTORY)) {
            properties.put(METADATA_FACTORY, JBossPersistenceMetaDataFactory.class.getName());
        }
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        JBossPersistenceMetaDataFactory.setThreadLocalPersistenceUnitMetadata(pu);
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        JBossPersistenceMetaDataFactory.clearThreadLocalPersistenceUnitMetadata();
    }

    public void injectJtaManager(JtaManager jtaManager) {
    }

    public void addProviderDependencies(ServiceRegistry registry, ServiceTarget target, ServiceBuilder<?> builder, PersistenceUnitMetadata pu) {
    }

    public ManagementAdaptor getManagementAdaptor() {
        return null;
    }

    public boolean doesScopedPersistenceUnitNameIdentifyCacheRegionName(PersistenceUnitMetadata pu) {
        return true;
    }

    public void cleanup(PersistenceUnitMetadata pu) {
        JBossPersistenceMetaDataFactory.cleanup(pu);
    }
}

