/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v1.providers;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.saml.v1.SAML11ProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.AbstractSecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML11AssertionTokenProvider
extends AbstractSecurityTokenProvider
implements SecurityTokenProvider {
    public static final String NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    private long ASSERTION_VALIDITY = 5000L;
    private long CLOCK_SKEW = 2000L;

    @Override
    public void initialize(Map<String, String> props) {
        String skew;
        super.initialize(props);
        String validity = (String)this.properties.get("ASSERTION_VALIDITY");
        if (validity != null) {
            this.ASSERTION_VALIDITY = Long.parseLong(validity);
        }
        if ((skew = (String)this.properties.get("CLOCK_SKEW")) != null) {
            this.CLOCK_SKEW = Long.parseLong(skew);
        }
    }

    @Override
    public boolean supports(String namespace) {
        return NS.equals(namespace);
    }

    @Override
    public void issueToken(ProtocolContext context) throws ProcessingException {
        XMLGregorianCalendar issueInstant;
        SAML11ProtocolContext samlProtocolContext;
        String issuerID;
        if (!(context instanceof SAML11ProtocolContext)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        if ((issuerID = (samlProtocolContext = (SAML11ProtocolContext)context).getIssuerID()) == null) {
            throw logger.nullArgumentError("Issuer in SAML Protocol Context");
        }
        try {
            issueInstant = XMLTimeUtil.getIssueInstant();
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e);
        }
        SAML11SubjectType subject = samlProtocolContext.getSubjectType();
        List<SAML11StatementAbstractType> statements = samlProtocolContext.getStatements();
        String assertionID = IDGenerator.create("ID_");
        SAML11AssertionType assertionType = new SAML11AssertionType(assertionID, issueInstant);
        assertionType.setIssuer(issuerID);
        assertionType.addAllStatements(statements);
        try {
            AssertionUtil.createSAML11TimedConditions(assertionType, this.ASSERTION_VALIDITY, this.CLOCK_SKEW);
        }
        catch (Exception e) {
            throw logger.processingError(e);
        }
        URI authenticationMethod = URI.create(samlProtocolContext.getAuthMethod());
        SAML11AuthenticationStatementType stat = new SAML11AuthenticationStatementType(authenticationMethod, issueInstant);
        stat.setSubject(subject);
        assertionType.add(stat);
        try {
            this.tokenRegistry.addToken(assertionID, assertionType);
        }
        catch (IOException e) {
            throw logger.processingError(e);
        }
        samlProtocolContext.setIssuedAssertion(assertionType);
    }

    @Override
    public void renewToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof SAMLProtocolContext)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)context;
        AssertionType issuedAssertion = samlProtocolContext.getIssuedAssertion();
        try {
            XMLGregorianCalendar currentTime = XMLTimeUtil.getIssueInstant();
            issuedAssertion.updateIssueInstant(currentTime);
        }
        catch (ConfigurationException e) {
            throw logger.processingError(e);
        }
        try {
            AssertionUtil.createTimedConditions(issuedAssertion, this.ASSERTION_VALIDITY, this.CLOCK_SKEW);
        }
        catch (ConfigurationException e) {
            throw logger.processingError(e);
        }
        catch (IssueInstantMissingException e) {
            throw logger.processingError(e);
        }
        try {
            this.tokenRegistry.addToken(issuedAssertion.getID(), issuedAssertion);
        }
        catch (IOException e) {
            throw logger.processingError(e);
        }
        samlProtocolContext.setIssuedAssertion(issuedAssertion);
    }

    @Override
    public void cancelToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof SAML11ProtocolContext)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        SAML11ProtocolContext samlProtocolContext = (SAML11ProtocolContext)context;
        SAML11AssertionType issuedAssertion = samlProtocolContext.getIssuedAssertion();
        try {
            this.tokenRegistry.removeToken(issuedAssertion.getID());
        }
        catch (IOException e) {
            throw logger.processingError(e);
        }
    }

    @Override
    public void validateToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof SAML11ProtocolContext)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        SAML11ProtocolContext samlProtocolContext = (SAML11ProtocolContext)context;
        SAML11AssertionType issuedAssertion = samlProtocolContext.getIssuedAssertion();
        try {
            if (!AssertionUtil.hasExpired(issuedAssertion)) {
                throw logger.samlAssertionExpiredError();
            }
        }
        catch (ConfigurationException e) {
            throw logger.processingError(e);
        }
        if (issuedAssertion == null) {
            throw logger.assertionInvalidError();
        }
        if (this.tokenRegistry.getToken(issuedAssertion.getID()) == null) {
            throw logger.assertionInvalidError();
        }
    }

    @Override
    public String tokenType() {
        return NS;
    }

    @Override
    public QName getSupportedQName() {
        return new QName(NS, JBossSAMLConstants.ASSERTION.get());
    }

    @Override
    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.SAML2.toString();
    }
}

