/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.ApplicableMethodInformation;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.EjbJaccConfig;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;

public class EjbJaccConfigurator
implements ComponentConfigurator {
    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        SessionBeanComponentDescription session;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)((Object)EJBComponentDescription.class.cast(description));
        EjbJaccConfig ejbJaccConfig = new EjbJaccConfig();
        context.getDeploymentUnit().addToAttachmentList(EjbDeploymentAttachmentKeys.JACC_PERMISSIONS, (Object)ejbJaccConfig);
        for (ViewConfiguration viewConfiguration : configuration.getViews()) {
            List viewMethods = viewConfiguration.getProxyFactory().getCachedMethods();
            for (Method viewMethod : viewMethods) {
                ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions;
                EJBViewConfiguration ejbViewConfiguration;
                boolean createdPerms;
                if (!Modifier.isPublic(viewMethod.getModifiers()) || viewMethod.getDeclaringClass() == WriteReplaceInterface.class || (createdPerms = this.createPermissions(ejbJaccConfig, ejbComponentDescription, ejbViewConfiguration = (EJBViewConfiguration)((Object)EJBViewConfiguration.class.cast(viewConfiguration)), viewMethod, reflectionIndex, permissions = ejbComponentDescription.getDescriptorMethodPermissions()))) continue;
                permissions = ejbComponentDescription.getAnnotationMethodPermissions();
                this.createPermissions(ejbJaccConfig, ejbComponentDescription, ejbViewConfiguration, viewMethod, reflectionIndex, permissions);
            }
        }
        Map<String, Collection<String>> securityRoles = ejbComponentDescription.getSecurityRoleLinks();
        for (Map.Entry<String, Collection<String>> entry : securityRoles.entrySet()) {
            String roleName = entry.getKey();
            for (String roleLink : entry.getValue()) {
                EJBRoleRefPermission p = new EJBRoleRefPermission(ejbComponentDescription.getEJBName(), roleName);
                ejbJaccConfig.addRole(roleLink, (Permission)p);
            }
        }
        if (ejbComponentDescription instanceof SessionBeanComponentDescription && (session = (SessionBeanComponentDescription)((Object)SessionBeanComponentDescription.class.cast((Object)ejbComponentDescription))).isStateful()) {
            EJBMethodPermission p = new EJBMethodPermission(ejbComponentDescription.getEJBName(), "getEJBObject", "Home", null);
            ejbJaccConfig.addPermit((Permission)p);
        }
    }

    protected boolean createPermissions(EjbJaccConfig ejbJaccConfig, EJBComponentDescription description, EJBViewConfiguration ejbViewConfiguration, Method viewMethod, DeploymentReflectionIndex index, ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions) {
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)viewMethod);
        EJBMethodSecurityAttribute ejbMethodSecurityMetaData = permissions.getViewAttribute(ejbViewConfiguration.getMethodIntf(), viewMethod.getName(), methodIdentifier.getParameterTypes());
        if (ejbMethodSecurityMetaData == null) {
            ejbMethodSecurityMetaData = permissions.getViewAttribute(MethodIntf.BEAN, viewMethod.getName(), methodIdentifier.getParameterTypes());
        }
        Method classMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)index, (Class)ejbViewConfiguration.getComponentConfiguration().getComponentClass(), (Method)viewMethod);
        if (ejbMethodSecurityMetaData == null && classMethod != null) {
            methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)classMethod);
            ejbMethodSecurityMetaData = permissions.getAttribute(ejbViewConfiguration.getMethodIntf(), classMethod.getDeclaringClass().getName(), classMethod.getName(), methodIdentifier.getParameterTypes());
            if (ejbMethodSecurityMetaData == null) {
                ejbMethodSecurityMetaData = permissions.getAttribute(MethodIntf.BEAN, classMethod.getDeclaringClass().getName(), classMethod.getName(), methodIdentifier.getParameterTypes());
            }
        }
        if (ejbMethodSecurityMetaData != null) {
            MethodInterfaceType interfaceType = this.getMethodInterfaceType(ejbViewConfiguration.getMethodIntf());
            EJBMethodPermission permission = new EJBMethodPermission(description.getEJBName(), methodIdentifier.getName(), interfaceType.name(), methodIdentifier.getParameterTypes());
            if (ejbMethodSecurityMetaData.isPermitAll()) {
                ejbJaccConfig.addPermit((Permission)permission);
            }
            if (ejbMethodSecurityMetaData.isDenyAll()) {
                ejbJaccConfig.addDeny((Permission)permission);
            }
            for (String role : ejbMethodSecurityMetaData.getRolesAllowed()) {
                ejbJaccConfig.addRole(role, (Permission)permission);
            }
            return true;
        }
        return false;
    }

    protected MethodInterfaceType getMethodInterfaceType(MethodIntf viewType) {
        switch (viewType) {
            case HOME: {
                return MethodInterfaceType.Home;
            }
            case LOCAL_HOME: {
                return MethodInterfaceType.LocalHome;
            }
            case SERVICE_ENDPOINT: {
                return MethodInterfaceType.ServiceEndpoint;
            }
            case LOCAL: {
                return MethodInterfaceType.Local;
            }
            case REMOTE: {
                return MethodInterfaceType.Remote;
            }
            case TIMER: {
                return MethodInterfaceType.Timer;
            }
            case MESSAGE_ENDPOINT: {
                return MethodInterfaceType.MessageEndpoint;
            }
        }
        return null;
    }
}

