/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.component.stateful.SerializedStatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.naming.ManagedReference;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatefulSessionComponentInstance
extends SessionBeanComponentInstance
implements Cacheable<SessionID> {
    private static final long serialVersionUID = 3803978357389448971L;
    private final SessionID id;
    private final Interceptor afterBegin;
    private final Interceptor afterCompletion;
    private final Interceptor beforeCompletion;
    private final Interceptor prePassivate;
    private final Interceptor postActivate;
    private final Interceptor ejb2XRemoveInterceptor;
    private volatile Map<Object, Object> serializableInterceptors;

    protected StatefulSessionComponentInstance(StatefulSessionComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, InterceptorFactoryContext factoryContext) {
        super(component, instanceReference, preDestroyInterceptor, methodInterceptors);
        SessionID existingSession = (SessionID)factoryContext.getContextData().get(SessionID.class);
        this.id = existingSession != null ? existingSession : (SessionID)component.getCache().createIdentifier();
        this.afterBegin = component.createInterceptor(component.getAfterBegin(), factoryContext);
        this.afterCompletion = component.createInterceptor(component.getAfterCompletion(), factoryContext);
        this.beforeCompletion = component.createInterceptor(component.getBeforeCompletion(), factoryContext);
        this.prePassivate = component.createInterceptor(component.getPrePassivate(), factoryContext);
        this.postActivate = component.createInterceptor(component.getPostActivate(), factoryContext);
        this.ejb2XRemoveInterceptor = component.createInterceptor(component.getEjb2XRemoveMethod(), factoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterBegin() {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.AFTER_BEGIN);
        try {
            this.execute(this.afterBegin, this.getComponent().getAfterBeginMethod(), new Object[0]);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterCompletion(boolean committed) {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.AFTER_COMPLETION);
        try {
            this.execute(this.afterCompletion, this.getComponent().getAfterCompletionMethod(), committed);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeCompletion() {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION);
        try {
            this.execute(this.beforeCompletion, this.getComponent().getBeforeCompletionMethod(), new Object[0]);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    protected void prePassivate() {
        this.execute(this.prePassivate, null, new Object[0]);
    }

    protected void postActivate() {
        this.execute(this.postActivate, null, new Object[0]);
    }

    @Override
    public void discard() {
        if (!this.isDiscarded()) {
            super.discard();
            this.getComponent().getCache().discard(this.id);
        }
    }

    private Object execute(Interceptor interceptor, Method method, Object ... parameters) {
        if (interceptor == null) {
            return null;
        }
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setMethod(method);
        interceptorContext.putPrivateData(Component.class, (Object)this.getComponent());
        interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
        interceptorContext.putPrivateData(InvokeMethodOnTargetInterceptor.PARAMETERS_KEY, (Object)parameters);
        interceptorContext.setContextData(new HashMap());
        interceptorContext.setTarget(this.getInstance());
        try {
            return interceptor.processInvocation(interceptorContext);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public Map<Object, Object> getSerializableInterceptors() {
        return this.serializableInterceptors;
    }

    public void setSerializableInterceptors(Map<Object, Object> serializableInterceptors) {
        this.serializableInterceptors = serializableInterceptors;
    }

    @Override
    public StatefulSessionComponent getComponent() {
        return (StatefulSessionComponent)super.getComponent();
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public SessionID getId() {
        return this.id;
    }

    public Interceptor getEjb2XRemoveInterceptor() {
        return this.ejb2XRemoveInterceptor;
    }

    public String toString() {
        return " Instance of " + this.getComponent().getComponentName() + " {" + this.id + "}";
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerializedStatefulSessionComponent((ManagedReference)this.getInstanceReference().get(), this.id, this.getComponent().getCreateServiceName().getCanonicalName(), this.serializableInterceptors);
    }
}

