/*
 * Decompiled with CFR 0.152.
 */
package naturalvoices;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import naturalvoices.WordTranscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Player {
    private String rootDir;
    private List<WordTranscription> transcription;
    private String[] voices;
    public Boolean Verbose = false;
    private Boolean SSML = true;
    private Boolean Latin1 = true;
    private String Voice = "mike16";
    private String Dictionary = "";
    private String SourceText = "";
    private String Server = "localhost";
    private int Port = 7000;
    private Boolean standalone;

    private void parseTranscriptionLine(String line) {
        Pattern pattern = Pattern.compile("^Word:[\t ]*(.*?)[\t ]*Transcription:[\t ](.*?)[\t ]*$");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String word = matcher.group(1);
            String trans = matcher.group(2);
            this.transcription.add(new WordTranscription(word, trans));
        }
    }

    public Boolean getSSML() {
        return this.SSML;
    }

    public Boolean getLatin1() {
        return this.Latin1;
    }

    public String getVoice() {
        return this.Voice;
    }

    public String getDictionary() {
        return this.Dictionary;
    }

    public String getSourceText() {
        return this.SourceText;
    }

    public void setSSML(Boolean SSML) {
        this.SSML = SSML;
    }

    public void setLatin1(Boolean Latin1) {
        this.Latin1 = Latin1;
    }

    public void setVoice(String Voice) {
        this.Voice = Voice;
    }

    public void setDictionary(String Dictionary) {
        this.Dictionary = Dictionary;
    }

    public void setSourceText(String SourceText) {
        this.SourceText = SourceText;
    }

    protected String getServer() {
        return this.Server;
    }

    protected int getPort() {
        return this.Port;
    }

    protected void setServer(String Server) {
        this.Server = Server;
    }

    protected void setPort(int Port) {
        this.Port = Port;
    }

    protected Player(String rootDir, Boolean standalone) {
        this.rootDir = rootDir;
        this.standalone = standalone;
    }

    protected void run(Boolean transcribe, String outputFilename, Boolean listVoices) {
        if (!(listVoices.booleanValue() || this.SourceText != null && this.SourceText != "")) {
            return;
        }
        try {
            File temp = File.createTempFile("tts", ".txt");
            FileWriter fw = new FileWriter(temp);
            fw.write(this.SourceText);
            fw.close();
            ArrayList<String> params = new ArrayList<String>();
            params.add(String.valueOf(this.rootDir) + "/bin/TTS" + (this.standalone != false ? "Standalone" : "Client") + (outputFilename != "" ? "File" : "Player") + (System.getProperty("os.name").startsWith("Windows") ? ".exe" : ""));
            if (this.SSML.booleanValue()) {
                params.add("-ssml");
            }
            if (this.Latin1.booleanValue()) {
                params.add("-latin1");
            }
            params.add("-x");
            if (listVoices.booleanValue()) {
                params.add("?");
            } else {
                params.add(this.Voice);
            }
            params.add("-f");
            params.add(temp.getAbsolutePath());
            if (this.standalone.booleanValue()) {
                params.add("-data");
                params.add(String.valueOf(this.rootDir) + "/data");
                params.add("-root");
                params.add(String.valueOf(this.rootDir) + "/bin");
            } else {
                params.add("-s");
                params.add(this.Server);
                params.add("-p");
                params.add(Integer.toString(this.Port));
            }
            if (this.Dictionary != null && this.Dictionary != "") {
                params.add("-du");
                params.add(this.Dictionary);
            }
            if (transcribe.booleanValue()) {
                params.add("-transcribe");
            }
            if (outputFilename != "") {
                params.add("-o");
                params.add(outputFilename);
            }
            if (this.Verbose.booleanValue()) {
                System.err.println(Arrays.toString(params.toArray()));
            }
            try {
                ProcessBuilder pb = new ProcessBuilder(params);
                Process process = pb.start();
                if (transcribe.booleanValue()) {
                    InputStream stdout = process.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
                    this.transcription = new ArrayList<WordTranscription>();
                    String line = reader.readLine();
                    while (line != null) {
                        this.parseTranscriptionLine(line);
                        line = reader.readLine();
                    }
                } else if (listVoices.booleanValue()) {
                    Pattern pattern;
                    Matcher matcher;
                    InputStream stdout = process.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
                    String line = reader.readLine();
                    if (line != null && (matcher = (pattern = Pattern.compile("^VoiceList:[\t ]*(.*?)[\t ]*$")).matcher(line)).find()) {
                        String s = matcher.group(1);
                        this.voices = s.split(" ");
                    }
                } else {
                    InputStream stderr = process.getErrorStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stderr));
                    String line = reader.readLine();
                    while (line != null) {
                        if (this.Verbose.booleanValue()) {
                            System.err.println(line);
                        }
                        line = reader.readLine();
                    }
                }
                process.waitFor();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (!temp.delete()) {
                temp.deleteOnExit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void Play() {
        this.run(false, "", false);
    }

    public List<WordTranscription> Transcribe() {
        this.transcription = null;
        this.run(true, "", false);
        return this.transcription;
    }

    public void Convert(String filename) {
        if (filename != null && filename != "") {
            this.run(false, filename, false);
        }
    }

    public String[] ListVoices() {
        this.voices = null;
        this.run(false, "", true);
        return this.voices;
    }
}

