/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.net.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitSPNEGOContextAction
implements PrivilegedAction<Object> {
    protected static Logger log = Logger.getLogger(InitSPNEGOContextAction.class);
    private Socket socket;
    private LoginContext lc;

    InitSPNEGOContextAction(Socket socket, LoginContext lc) {
        this.socket = socket;
        this.lc = lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run() {
        boolean DEBUG = log.isDebugEnabled();
        byte[] token = new byte[]{};
        GSSManager manager = GSSManager.getInstance();
        GSSContext context = null;
        try {
            DataInputStream inStream = new DataInputStream(this.socket.getInputStream());
            DataOutputStream outStream = new DataOutputStream(this.socket.getOutputStream());
            Oid oid = Constants.SPNEGO;
            String nameStr = SecurityActions.getServerName();
            if (nameStr == null) {
                throw new IllegalArgumentException("Server name must be set using the org.jboss.security.negotiation.server.principal system property");
            }
            GSSName serverName = manager.createName(nameStr, null);
            context = manager.createContext(serverName, oid, null, 0);
            while (!context.isEstablished()) {
                if ((token = context.initSecContext(token, 0, token.length)) != null) {
                    if (DEBUG) {
                        log.debug((Object)("Sending token of length " + token.length));
                    }
                    outStream.writeInt(token.length);
                    outStream.write(token);
                    outStream.flush();
                }
                if (context.isEstablished()) continue;
                token = new byte[inStream.readInt()];
                if (DEBUG) {
                    log.debug((Object)("Receiving token of length " + token.length));
                }
                inStream.readFully(token);
            }
            if (DEBUG) {
                log.trace((Object)"GSSContext established");
            }
            Subject subject = this.lc.getSubject();
            Principal principal = subject.getPrincipals().iterator().next();
            try {
                this.setSecurityContext(principal, null, subject, "CLIENT");
            }
            catch (Exception e) {
                log.error((Object)("Error setting the SecurityContext: " + e.getMessage()), (Throwable)e);
            }
        }
        catch (GSSException gsse) {
            log.error((Object)("Error establishing GSSContext: " + gsse.getMessage()), (Throwable)gsse);
        }
        catch (IOException ioe) {
            log.error((Object)("Error reading/writing token: " + ioe.getMessage()), (Throwable)ioe);
        }
        finally {
            if (context != null) {
                try {
                    context.dispose();
                }
                catch (GSSException gsse) {
                    log.error((Object)("Error dispoing GSSContext: " + gsse.getMessage()), (Throwable)gsse);
                }
            }
        }
        return null;
    }

    protected void setSecurityContext(Principal principal, Object credential, Subject subject, String securityDomain) throws Exception {
        SecurityContext sc = SecurityActions.createSecurityContext(principal, null, subject, securityDomain);
        SecurityActions.setSecurityContext(sc);
    }
}

