/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.entities.Usage;
import org.mobicents.servlet.restcomm.http.converter.AbstractConverter;

public final class UsageConverter
extends AbstractConverter
implements JsonSerializer<Usage> {
    public UsageConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Usage.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Usage number = (Usage)object;
        writer.startNode("UsageRecord");
        this.writeCategory(number.getCategory(), writer);
        this.writeDescription(number.getDescription(), writer);
        this.writeAccountSid(number.getAccountSid(), writer);
        this.writeStartDate(number.getStartDate(), writer);
        this.writeEndDate(number.getEndDate(), writer);
        this.writeUsage(number.getUsage(), writer);
        this.writeUsageUnit(number.getUsageUnit(), writer);
        this.writeCount(number.getCount(), writer);
        this.writeCountUnit(number.getCountUnit(), writer);
        this.writePrice(number.getPrice(), writer);
        this.writePriceUnit(number.getPriceUnit(), writer);
        this.writeUri(number.getUri(), writer);
        writer.endNode();
    }

    private void writeCategory(Usage.Category category, HierarchicalStreamWriter writer) {
        writer.startNode("Category");
        if (category != null) {
            writer.setValue(category.toString());
        }
        writer.endNode();
    }

    private void writeCategory(Usage.Category category, JsonObject object) {
        object.addProperty("category", category.toString());
    }

    private void writeDescription(String description, HierarchicalStreamWriter writer) {
        writer.startNode("Description");
        if (description != null) {
            writer.setValue(description.toString());
        }
        writer.endNode();
    }

    private void writeDescription(String description, JsonObject object) {
        object.addProperty("description", description);
    }

    private void writeStartDate(DateTime startDate, HierarchicalStreamWriter writer) {
        writer.startNode("StartDate");
        if (startDate != null) {
            writer.setValue(startDate.toString("yyyy-MM-dd"));
        }
        writer.endNode();
    }

    private void writeStartDate(DateTime startDate, JsonObject object) {
        object.addProperty("start_date", startDate.toString("yyyy-MM-dd"));
    }

    private void writeEndDate(DateTime endDate, HierarchicalStreamWriter writer) {
        writer.startNode("EndDate");
        if (endDate != null) {
            writer.setValue(endDate.toString("yyyy-MM-dd"));
        }
        writer.endNode();
    }

    private void writeEndDate(DateTime endDate, JsonObject object) {
        object.addProperty("end_date", endDate.toString("yyyy-MM-dd"));
    }

    private void writeUsage(Long usage, HierarchicalStreamWriter writer) {
        writer.startNode("Usage");
        if (usage != null) {
            writer.setValue(usage.toString());
        }
        writer.endNode();
    }

    private void writeUsage(Long usage, JsonObject object) {
        object.addProperty("usage", usage.toString());
    }

    private void writeUsageUnit(String usageUnit, HierarchicalStreamWriter writer) {
        writer.startNode("UsageUnit");
        if (usageUnit != null) {
            writer.setValue(usageUnit);
        }
        writer.endNode();
    }

    private void writeUsageUnit(String usageUnit, JsonObject object) {
        object.addProperty("usage_unit", usageUnit);
    }

    private void writeCount(Long count, HierarchicalStreamWriter writer) {
        writer.startNode("Count");
        if (count != null) {
            writer.setValue(count.toString());
        }
        writer.endNode();
    }

    private void writeCount(Long count, JsonObject object) {
        object.addProperty("count", count.toString());
    }

    private void writeCountUnit(String countUnit, HierarchicalStreamWriter writer) {
        writer.startNode("CountUnit");
        if (countUnit != null) {
            writer.setValue(countUnit.toString());
        }
        writer.endNode();
    }

    private void writeCountUnit(String countUnit, JsonObject object) {
        object.addProperty("count_unit", countUnit);
    }

    private void writePriceUnit(String priceUnit, HierarchicalStreamWriter writer) {
        writer.startNode("PriceUnit");
        if (priceUnit != null) {
            writer.setValue(priceUnit.toString());
        }
        writer.endNode();
    }

    private void writePriceUnit(String priceUnit, JsonObject object) {
        object.addProperty("price_unit", priceUnit);
    }

    public JsonElement serialize(Usage usage, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject object = new JsonObject();
        this.writeCategory(usage.getCategory(), object);
        this.writeDescription(usage.getDescription(), object);
        this.writeAccountSid(usage.getAccountSid(), object);
        this.writeStartDate(usage.getStartDate(), object);
        this.writeEndDate(usage.getEndDate(), object);
        this.writeUsage(usage.getUsage(), object);
        this.writeUsageUnit(usage.getUsageUnit(), object);
        this.writeCount(usage.getCount(), object);
        this.writeCountUnit(usage.getCountUnit(), object);
        this.writePrice(usage.getPrice(), object);
        this.writePriceUnit(usage.getPriceUnit(), object);
        this.writeUri(usage.getUri(), object);
        return object;
    }
}

