/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.entities.SmsMessage;
import org.mobicents.servlet.restcomm.http.converter.AbstractConverter;

public class SmsMessageConverter
extends AbstractConverter
implements JsonSerializer<SmsMessage> {
    public SmsMessageConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return SmsMessage.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        SmsMessage smsMessage = (SmsMessage)object;
        writer.startNode("SMSMessage");
        this.writeSid(smsMessage.getSid(), writer);
        this.writeDateCreated(smsMessage.getDateCreated(), writer);
        this.writeDateUpdated(smsMessage.getDateUpdated(), writer);
        this.writeDateSent(smsMessage.getDateSent(), writer);
        this.writeAccountSid(smsMessage.getAccountSid(), writer);
        this.writeFrom(smsMessage.getSender(), writer);
        this.writeTo(smsMessage.getRecipient(), writer);
        this.writeBody(smsMessage.getBody(), writer);
        this.writeStatus(smsMessage.getStatus().toString(), writer);
        this.writeDirection(smsMessage.getDirection().toString(), writer);
        this.writePrice(smsMessage.getPrice(), writer);
        this.writePriceUnit(smsMessage.getPriceUnit(), writer);
        this.writeApiVersion(smsMessage.getApiVersion(), writer);
        this.writeUri(smsMessage.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(SmsMessage smsMessage, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(smsMessage.getSid(), object);
        this.writeDateCreated(smsMessage.getDateCreated(), object);
        this.writeDateUpdated(smsMessage.getDateUpdated(), object);
        this.writeDateSent(smsMessage.getDateSent(), object);
        this.writeAccountSid(smsMessage.getAccountSid(), object);
        this.writeFrom(smsMessage.getSender(), object);
        this.writeTo(smsMessage.getRecipient(), object);
        this.writeBody(smsMessage.getBody(), object);
        this.writeStatus(smsMessage.getStatus().toString(), object);
        this.writeDirection(smsMessage.getDirection().toString(), object);
        this.writePrice(smsMessage.getPrice(), object);
        this.writePriceUnit(smsMessage.getPriceUnit(), object);
        this.writeApiVersion(smsMessage.getApiVersion(), object);
        this.writeUri(smsMessage.getUri(), object);
        return object;
    }

    private void writeBody(String body, HierarchicalStreamWriter writer) {
        writer.startNode("Body");
        if (body != null) {
            writer.setValue(body);
        }
        writer.endNode();
    }

    private void writeBody(String body, JsonObject object) {
        if (body != null) {
            object.addProperty("body", body);
        } else {
            object.add("body", (JsonElement)JsonNull.INSTANCE);
        }
    }

    private void writeDateSent(DateTime dateSent, HierarchicalStreamWriter writer) {
        writer.startNode("DateSent");
        if (dateSent != null) {
            writer.setValue(dateSent.toString());
        }
        writer.endNode();
    }

    private void writeDateSent(DateTime dateSent, JsonObject object) {
        object.addProperty("date_sent", dateSent != null ? dateSent.toString() : null);
    }

    private void writeDirection(String direction, HierarchicalStreamWriter writer) {
        writer.startNode("Direction");
        writer.setValue(direction);
        writer.endNode();
    }

    private void writeDirection(String direction, JsonObject object) {
        object.addProperty("direction", direction);
    }
}

