/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.entities.ShortCode;
import org.mobicents.servlet.restcomm.http.converter.AbstractConverter;

@ThreadSafe
public final class ShortCodeConverter
extends AbstractConverter
implements JsonSerializer<ShortCode> {
    public ShortCodeConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return ShortCode.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        ShortCode shortCode = (ShortCode)object;
        writer.startNode("ShortCode");
        this.writeSid(shortCode.getSid(), writer);
        this.writeDateCreated(shortCode.getDateCreated(), writer);
        this.writeDateUpdated(shortCode.getDateUpdated(), writer);
        this.writeFriendlyName(shortCode.getFriendlyName(), writer);
        this.writeAccountSid(shortCode.getAccountSid(), writer);
        this.writeShortCode(Integer.toString(shortCode.getShortCode()), writer);
        this.writeApiVersion(shortCode.getApiVersion(), writer);
        this.writeSmsUrl(shortCode.getSmsUrl(), writer);
        this.writeSmsMethod(shortCode.getSmsMethod(), writer);
        this.writeSmsFallbackUrl(shortCode.getSmsFallbackUrl(), writer);
        this.writeSmsFallbackMethod(shortCode.getSmsFallbackMethod(), writer);
        this.writeUri(shortCode.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(ShortCode shortCode, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(shortCode.getSid(), object);
        this.writeDateCreated(shortCode.getDateCreated(), object);
        this.writeDateUpdated(shortCode.getDateUpdated(), object);
        this.writeFriendlyName(shortCode.getFriendlyName(), object);
        this.writeAccountSid(shortCode.getAccountSid(), object);
        this.writeShortCode(Integer.toString(shortCode.getShortCode()), object);
        this.writeApiVersion(shortCode.getApiVersion(), object);
        this.writeSmsUrl(shortCode.getSmsUrl(), object);
        this.writeSmsMethod(shortCode.getSmsMethod(), object);
        this.writeSmsFallbackUrl(shortCode.getSmsFallbackUrl(), object);
        this.writeSmsFallbackMethod(shortCode.getSmsFallbackMethod(), object);
        this.writeUri(shortCode.getUri(), object);
        return object;
    }

    private void writeShortCode(String shortCode, HierarchicalStreamWriter writer) {
        writer.startNode("ShortCode");
        writer.setValue(shortCode);
        writer.endNode();
    }

    private void writeShortCode(String shortCode, JsonObject object) {
        object.addProperty("short_code", shortCode);
    }
}

